/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image.json;

import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class OCIManifestTemplate
implements BuildableManifestTemplate {
    public static final String MANIFEST_MEDIA_TYPE = "application/vnd.oci.image.manifest.v1+json";
    private static final String CONTAINER_CONFIGURATION_MEDIA_TYPE = "application/vnd.oci.image.config.v1+json";
    private static final String LAYER_MEDIA_TYPE = "application/vnd.oci.image.layer.v1.tar+gzip";
    private final int schemaVersion = 2;
    private final String mediaType = "application/vnd.oci.image.manifest.v1+json";
    @Nullable
    private BuildableManifestTemplate.ContentDescriptorTemplate config;
    private final List<BuildableManifestTemplate.ContentDescriptorTemplate> layers = new ArrayList<BuildableManifestTemplate.ContentDescriptorTemplate>();

    @Override
    public int getSchemaVersion() {
        return 2;
    }

    @Override
    public String getManifestMediaType() {
        return MANIFEST_MEDIA_TYPE;
    }

    @Override
    @Nullable
    public BuildableManifestTemplate.ContentDescriptorTemplate getContainerConfiguration() {
        return this.config;
    }

    @Override
    public List<BuildableManifestTemplate.ContentDescriptorTemplate> getLayers() {
        return Collections.unmodifiableList(this.layers);
    }

    @Override
    public void setContainerConfiguration(long size, DescriptorDigest digest) {
        this.config = new BuildableManifestTemplate.ContentDescriptorTemplate(CONTAINER_CONFIGURATION_MEDIA_TYPE, size, digest);
    }

    @Override
    public void addLayer(long size, DescriptorDigest digest) {
        this.layers.add(new BuildableManifestTemplate.ContentDescriptorTemplate(LAYER_MEDIA_TYPE, size, digest));
    }
}

