/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image;

import com.google.cloud.tools.jib.image.LayerEntry;
import com.google.cloud.tools.jib.image.UnwrittenLayer;
import com.google.cloud.tools.jib.tar.TarStreamBuilder;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;

public class ReproducibleLayerBuilder {
    private final ImmutableList<LayerEntry> layerEntries;

    public ReproducibleLayerBuilder(ImmutableList<LayerEntry> layerEntries) {
        this.layerEntries = layerEntries;
    }

    public UnwrittenLayer build() {
        UniqueTarArchiveEntries uniqueTarArchiveEntries = new UniqueTarArchiveEntries();
        for (LayerEntry layerEntry : this.layerEntries) {
            uniqueTarArchiveEntries.add(new TarArchiveEntry(layerEntry.getSourceFile().toFile(), layerEntry.getAbsoluteExtractionPathString()));
        }
        List sortedFilesystemEntries = uniqueTarArchiveEntries.getSortedEntries();
        HashSet<String> names = new HashSet<String>();
        TarStreamBuilder tarStreamBuilder = new TarStreamBuilder();
        for (TarArchiveEntry entry : sortedFilesystemEntries) {
            entry.setModTime(0L);
            entry.setGroupId(0);
            entry.setUserId(0);
            entry.setUserName("");
            entry.setGroupName("");
            Verify.verify((!names.contains(entry.getName()) ? 1 : 0) != 0);
            names.add(entry.getName());
            tarStreamBuilder.addTarArchiveEntry(entry);
        }
        return new UnwrittenLayer(tarStreamBuilder.toBlob());
    }

    public ImmutableList<LayerEntry> getLayerEntries() {
        return this.layerEntries;
    }

    private static class UniqueTarArchiveEntries {
        private static final File DIRECTORY_FILE = Paths.get(".", new String[0]).toFile();
        private final List<TarArchiveEntry> entries = new ArrayList<TarArchiveEntry>();
        private final Set<String> names = new HashSet<String>();

        private UniqueTarArchiveEntries() {
        }

        private void add(TarArchiveEntry tarArchiveEntry) {
            if (this.names.contains(tarArchiveEntry.getName())) {
                return;
            }
            Path namePath = Paths.get(tarArchiveEntry.getName(), new String[0]);
            if (namePath.getParent() != namePath.getRoot()) {
                this.add(new TarArchiveEntry(DIRECTORY_FILE, namePath.getParent().toString()));
            }
            this.entries.add(tarArchiveEntry);
            this.names.add(tarArchiveEntry.getName());
        }

        private List<TarArchiveEntry> getSortedEntries() {
            ArrayList<TarArchiveEntry> sortedEntries = new ArrayList<TarArchiveEntry>(this.entries);
            sortedEntries.sort(Comparator.comparing(TarArchiveEntry::getName));
            return sortedEntries;
        }
    }
}

