/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.sqlserver;

import com.google.cloud.sql.core.CoreSocketFactory;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Properties;

public class SocketFactory
extends javax.net.SocketFactory {
    @VisibleForTesting
    protected Properties props = new Properties();

    public SocketFactory(String socketFactoryConstructorArg) throws UnsupportedEncodingException {
        String[] s = socketFactoryConstructorArg.split("\\?");
        this.props.setProperty("cloudSqlInstance", s[0]);
        if (s.length == 2 && s[1].length() > 0) {
            String[] queryParams;
            for (String param : queryParams = s[1].split("&")) {
                String[] splitParam = param.split("=");
                if (splitParam.length != 2 || splitParam[0].length() == 0 || splitParam[1].length() == 0) {
                    throw new IllegalArgumentException(String.format("Malformed query param in socketFactoryConstructorArg : %s", param));
                }
                this.props.setProperty(URLDecoder.decode(splitParam[0], StandardCharsets.UTF_8.name()), URLDecoder.decode(splitParam[1], StandardCharsets.UTF_8.name()));
            }
        } else if (s.length > 2) {
            throw new IllegalArgumentException("Only one query string allowed in socketFactoryConstructorArg");
        }
    }

    @Override
    public Socket createSocket() throws IOException {
        try {
            return CoreSocketFactory.connect((Properties)this.props);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Socket createSocket(String host, int port) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(InetAddress host, int port) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) {
        throw new UnsupportedOperationException();
    }

    static {
        CoreSocketFactory.addArtifactId((String)"cloud-sql-connector-jdbc-sqlserver");
    }
}

