/*
 * Decompiled with CFR 0.152.
 */
package com.mars.server.server.request;

import com.mars.common.base.config.MarsConfig;
import com.mars.common.base.config.model.CrossDomainConfig;
import com.mars.common.util.MarsConfiguration;
import com.sun.net.httpserver.HttpExchange;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMarsResponse {
    private Logger logger = LoggerFactory.getLogger(HttpMarsResponse.class);
    private HttpExchange httpExchange;
    private Map<String, String> header;

    public HttpMarsResponse(HttpExchange httpExchange) {
        this.httpExchange = httpExchange;
        this.header = new HashMap<String, String>();
    }

    public HttpExchange geHttpServletResponse() {
        return this.httpExchange;
    }

    public void setHeader(String key, String value) {
        this.header.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String context) {
        OutputStream out = null;
        try {
            this.crossDomain();
            this.loadHeader();
            this.httpExchange.getResponseHeaders().add("Content-Type:", "text/json;charset=UTF-8");
            byte[] responseContentByte = context.getBytes("UTF-8");
            this.httpExchange.sendResponseHeaders(200, responseContentByte.length);
            out = this.httpExchange.getResponseBody();
            out.write(responseContentByte);
        }
        catch (Exception e) {
            this.logger.error("\u54cd\u5e94\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downLoad(String fileName, InputStream inputStream) {
        OutputStream out = null;
        try {
            if (fileName == null || inputStream == null) {
                this.logger.error("downLoad\u65b9\u6cd5\u7684\u4f20\u53c2\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
                return;
            }
            this.crossDomain();
            this.httpExchange.getResponseHeaders().add("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName, "UTF-8"));
            int len = 0;
            byte[] buffer = new byte[1024];
            this.httpExchange.sendResponseHeaders(200, inputStream.available());
            out = this.httpExchange.getResponseBody();
            while ((len = inputStream.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
        }
        catch (Exception e) {
            this.logger.error("\u54cd\u5e94\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void loadHeader() {
        if (this.header != null && !this.header.isEmpty()) {
            for (String key : this.header.keySet()) {
                this.httpExchange.getResponseHeaders().set(key, this.header.get(key));
            }
        }
    }

    private void crossDomain() {
        MarsConfig marsConfig = MarsConfiguration.getConfig();
        CrossDomainConfig crossDomainConfig = marsConfig.crossDomainConfig();
        this.httpExchange.getResponseHeaders().set("Access-Control-Allow-Origin", crossDomainConfig.getOrigin());
        this.httpExchange.getResponseHeaders().set("Access-Control-Allow-Methods", crossDomainConfig.getMethods());
        this.httpExchange.getResponseHeaders().set("Access-Control-Max-Age", crossDomainConfig.getMaxAge());
        this.httpExchange.getResponseHeaders().set("Access-Control-Allow-Headers", crossDomainConfig.getHeaders());
        this.httpExchange.getResponseHeaders().set("Access-Control-Allow-Credentials", crossDomainConfig.getCredentials());
    }
}

