/*
 * Decompiled with CFR 0.152.
 */
package com.mars.server.server.request;

import com.mars.server.server.request.model.MarsFileUpLoad;
import com.sun.net.httpserver.HttpExchange;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpMarsRequest {
    private HttpExchange httpExchange;
    private Map<String, List<String>> marsParams;
    private Map<String, MarsFileUpLoad> files;

    public HttpMarsRequest(HttpExchange httpExchange) {
        this.httpExchange = httpExchange;
    }

    public void setFiles(Map<String, MarsFileUpLoad> files) {
        this.files = files;
    }

    public void setParams(Map<String, List<String>> params) {
        if (params == null || params.size() < 1) {
            return;
        }
        this.marsParams = params;
    }

    public String getMethod() {
        return this.httpExchange.getRequestMethod();
    }

    public String getUrl() {
        return this.httpExchange.getRequestURI().toString();
    }

    public List<String> getHeader(String key) {
        return this.httpExchange.getRequestHeaders().get(key);
    }

    public Map<String, Object> getParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.marsParams == null) {
            return params;
        }
        for (String key : this.marsParams.keySet()) {
            List<String> paramsList = this.marsParams.get(key);
            if (paramsList == null || paramsList.size() < 1) continue;
            String[] paramsListToArray = this.paramsListToArray(paramsList);
            if (paramsListToArray != null && paramsListToArray.length == 1) {
                params.put(key, paramsListToArray[0]);
                continue;
            }
            params.put(key, paramsListToArray);
        }
        return params;
    }

    public String getParameter(String key) {
        List<String> value;
        if (this.marsParams != null && (value = this.marsParams.get(key)) != null && value.size() > 0) {
            return value.get(0);
        }
        return null;
    }

    public String[] getParameterValues(String key) {
        if (this.marsParams != null) {
            List<String> paramsList = this.marsParams.get(key);
            return this.paramsListToArray(paramsList);
        }
        return null;
    }

    public Map<String, MarsFileUpLoad> getFiles() throws Exception {
        return this.files;
    }

    public MarsFileUpLoad getFile(String name) throws Exception {
        if (this.files != null) {
            return this.files.get(name);
        }
        return null;
    }

    public HttpExchange getHttpExchange() {
        return this.httpExchange;
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.httpExchange.getLocalAddress();
    }

    private String[] paramsListToArray(List<String> paramsList) {
        if (paramsList == null || paramsList.size() < 1) {
            return null;
        }
        String[] paramsArray = new String[paramsList.size()];
        return paramsList.toArray(paramsArray);
    }
}

