/*
 * Decompiled with CFR 0.152.
 */
package com.mars.server.server.jwt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.mars.common.util.MarsConfiguration;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class JwtManager {
    private final String SECRET = "Mars-java-cloud-config-no1";
    private final int calendarField = 13;
    private int calendarInterval = 86400;
    private static JwtManager jwtManager = new JwtManager();

    private JwtManager() {
        this.loadCalendarInterval();
    }

    public static JwtManager getJwtManager() {
        return jwtManager;
    }

    private void loadCalendarInterval() {
        this.calendarInterval = MarsConfiguration.getConfig().jwtTime();
    }

    public String createToken(Object obj) {
        Date iatDate = new Date();
        Calendar nowTime = Calendar.getInstance();
        nowTime.add(13, this.calendarInterval);
        Date expiresDate = nowTime.getTime();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("alg", "HS256");
        map.put("typ", "JWT");
        JWTCreator.Builder builder = JWT.create().withHeader(map);
        JSONObject json = JSONObject.parseObject((String)JSON.toJSONString((Object)obj));
        for (String key : json.keySet()) {
            builder.withClaim(key, json.get((Object)key).toString());
        }
        builder.withIssuedAt(iatDate);
        builder.withExpiresAt(expiresDate);
        String token = builder.sign(Algorithm.HMAC256((String)"Mars-java-cloud-config-no1"));
        return token;
    }

    public boolean verifyToken(String token) {
        Map<String, Claim> claims = this.decryptToken(token);
        return claims != null;
    }

    private Map<String, Claim> decryptToken(String token) {
        DecodedJWT jwt = null;
        try {
            JWTVerifier verifier = JWT.require((Algorithm)Algorithm.HMAC256((String)"Mars-java-cloud-config-no1")).build();
            jwt = verifier.verify(token);
            return jwt.getClaims();
        }
        catch (Exception e) {
            return null;
        }
    }

    public <T> T getObject(String token, Class<T> cls) {
        JSONObject json = new JSONObject();
        try {
            Map<String, Claim> claims = this.decryptToken(token);
            if (claims == null || claims.isEmpty()) {
                return null;
            }
            for (String key : claims.keySet()) {
                json.put(key, (Object)claims.get(key).asString());
            }
            return (T)json.toJavaObject(cls);
        }
        catch (Exception e) {
            return null;
        }
    }
}

