/*
 * Decompiled with CFR 0.152.
 */
package com.mars.iserver.par.formdata;

import com.mars.common.base.config.model.FileUploadConfig;
import com.mars.common.util.MarsConfiguration;
import com.mars.iserver.par.formdata.HttpExchangeFileUpload;
import com.mars.iserver.par.formdata.HttpExchangeRequestContext;
import com.mars.server.server.request.model.MarsFileUpLoad;
import com.sun.net.httpserver.HttpExchange;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;

public class ParsingFormData {
    public static final String PARAMS_KEY = "paramsKey";
    public static final String FILES_KEY = "filesKey";

    public static Map<String, Object> parsing(HttpExchange exchange, Map<String, List<String>> marsParams, Map<String, MarsFileUpLoad> files, String contentType) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<FileItem> fileItemList = ParsingFormData.getFileItem(exchange, contentType);
        for (FileItem item : fileItemList) {
            if (item.isFormField()) {
                String name = item.getFieldName();
                String value = item.getString("UTF-8");
                List<String> params = marsParams.get(name);
                if (params == null) {
                    params = new ArrayList<String>();
                }
                params.add(value);
                marsParams.put(name, params);
                continue;
            }
            MarsFileUpLoad marsFileUpLoad = new MarsFileUpLoad();
            marsFileUpLoad.setName(item.getFieldName());
            marsFileUpLoad.setInputStream(item.getInputStream());
            marsFileUpLoad.setFileName(item.getName());
            files.put(marsFileUpLoad.getName(), marsFileUpLoad);
        }
        result.put(PARAMS_KEY, marsParams);
        result.put(FILES_KEY, files);
        return result;
    }

    public static List<FileItem> getFileItem(HttpExchange request, String contentType) throws Exception {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        FileUploadConfig fileUploadConfig = MarsConfiguration.getConfig().fileUploadConfig();
        HttpExchangeFileUpload fileUploadBase = new HttpExchangeFileUpload();
        ((FileUploadBase)fileUploadBase).setFileItemFactory(factory);
        fileUploadBase.setFileSizeMax(fileUploadConfig.getFileSizeMax());
        fileUploadBase.setSizeMax(fileUploadConfig.getSizeMax());
        List<FileItem> fileItemList = fileUploadBase.parseRequest(new HttpExchangeRequestContext(request, contentType));
        return fileItemList;
    }
}

