/*
 * Decompiled with CFR 0.152.
 */
package com.mars.iserver.par.formdata;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.fileupload.UploadContext;

public class HttpExchangeRequestContext
implements UploadContext {
    private final HttpExchange request;
    private String contentType;

    public HttpExchangeRequestContext(HttpExchange request, String contentType) {
        this.request = request;
        this.contentType = contentType;
    }

    @Override
    public String getCharacterEncoding() {
        return "UTF-8";
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    @Deprecated
    public int getContentLength() {
        try {
            return this.request.getRequestBody().available();
        }
        catch (Exception e2) {
            return 0;
        }
    }

    @Override
    public long contentLength() {
        long size = 0L;
        try {
            Object ctList = this.request.getRequestHeaders().get("Content-length");
            if (ctList != null || ctList.size() > 0) {
                size = Long.parseLong((String)ctList.get(0));
            }
        }
        catch (NumberFormatException e) {
            try {
                size = this.request.getRequestBody().available();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return size;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.request.getRequestBody();
    }

    public String toString() {
        return String.format("ContentLength=%s, ContentType=%s", this.contentLength(), this.getContentType());
    }
}

