/*
 * Decompiled with CFR 0.152.
 */
package com.mars.iserver.par;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mars.iserver.par.formdata.ParsingFormData;
import com.mars.server.server.request.HttpMarsRequest;
import com.mars.server.server.request.model.MarsFileUpLoad;
import com.sun.net.httpserver.HttpExchange;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpMarsRequestFactory {
    public static HttpMarsRequest getHttpMarsRequest(HttpExchange httpExchange, HttpMarsRequest marsRequest) throws Exception {
        Map<String, MarsFileUpLoad> files = new HashMap<String, MarsFileUpLoad>();
        Map<String, List<String>> marsParams = new HashMap<String, List<String>>();
        if (httpExchange.getRequestMethod().toUpperCase().equals("GET")) {
            String paramStr = httpExchange.getRequestURI().getQuery();
            marsParams = HttpMarsRequestFactory.urlencoded(paramStr, marsParams, false);
        } else {
            InputStream inputStream = httpExchange.getRequestBody();
            if (inputStream == null) {
                return marsRequest;
            }
            String contentType = HttpMarsRequestFactory.getContentType(httpExchange);
            if (contentType.startsWith("application/x-www-form-urlencoded")) {
                String paramStr = HttpMarsRequestFactory.getParamStr(inputStream);
                marsParams = HttpMarsRequestFactory.urlencoded(paramStr, marsParams, true);
            } else if (contentType.startsWith("multipart/form-data")) {
                Map<String, Object> result = HttpMarsRequestFactory.formData(httpExchange, marsParams, files, contentType);
                files = (Map)result.get("filesKey");
                marsParams = (Map)result.get("paramsKey");
            } else if (contentType.startsWith("application/json")) {
                marsParams = HttpMarsRequestFactory.raw(inputStream, marsParams);
            }
        }
        marsRequest.setFiles(files);
        marsRequest.setParams(marsParams);
        return marsRequest;
    }

    private static String getContentType(HttpExchange httpExchange) {
        Object ctList = httpExchange.getRequestHeaders().get("Content-type");
        if (ctList == null || ctList.size() < 1) {
            return null;
        }
        return ((String)ctList.get(0)).trim().toLowerCase();
    }

    private static String getParamStr(InputStream inputStream) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        String line = null;
        StringBuffer paramsStr = new StringBuffer();
        while ((line = br.readLine()) != null) {
            paramsStr.append(line);
        }
        return paramsStr.toString();
    }

    private static Map<String, List<String>> urlencoded(String paramStr, Map<String, List<String>> marsParams, boolean hasDecode) throws Exception {
        if (paramStr != null) {
            String[] paramsArray = paramStr.split("&");
            if (paramsArray == null || paramsArray.length < 1) {
                return marsParams;
            }
            List<String> values = null;
            for (String paramItem : paramsArray) {
                String[] param = paramItem.split("=");
                if (param == null || param.length < 2) continue;
                String key = param[0];
                values = marsParams.get(key);
                if (values == null) {
                    values = new ArrayList<String>();
                }
                String value = param[1];
                if (hasDecode) {
                    value = URLDecoder.decode(value, "UTF-8");
                }
                values.add(value);
                marsParams.put(key, values);
            }
        }
        return marsParams;
    }

    private static Map<String, List<String>> raw(InputStream inputStream, Map<String, List<String>> marsParams) throws Exception {
        String paramStr = HttpMarsRequestFactory.getParamStr(inputStream);
        if (paramStr == null || paramStr.trim().equals("")) {
            return marsParams;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)paramStr);
        List<String> values = null;
        for (String key : jsonObject.keySet()) {
            Object val;
            values = marsParams.get(key);
            if (values == null) {
                values = new ArrayList<String>();
            }
            if ((val = jsonObject.get((Object)key)) != null) {
                if (val instanceof JSONArray) {
                    JSONArray jsonArray = (JSONArray)val;
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        values.add(jsonArray.getString(i));
                    }
                } else {
                    values.add(val.toString());
                }
            }
            marsParams.put(key, values);
        }
        return marsParams;
    }

    private static Map<String, Object> formData(HttpExchange exchange, Map<String, List<String>> marsParams, Map<String, MarsFileUpLoad> files, String contentType) throws Exception {
        return ParsingFormData.parsing(exchange, marsParams, files, contentType);
    }
}

