/*
 * Decompiled with CFR 0.152.
 */
package com.mars.iserver.execute;

import com.mars.common.ncfg.mvc.CoreServletClass;
import com.mars.common.util.MesUtil;
import com.mars.common.util.StringUtil;
import com.mars.iserver.execute.access.PathAccess;
import com.mars.iserver.par.HttpMarsRequestFactory;
import com.mars.iserver.par.factory.ParamAndResultFactory;
import com.mars.server.server.request.HttpMarsRequest;
import com.mars.server.server.request.HttpMarsResponse;
import com.mars.server.util.RequestUtil;
import com.sun.net.httpserver.HttpExchange;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestExecute {
    private Logger log = LoggerFactory.getLogger(RequestExecute.class);
    private HttpExchange httpExchange;

    public void setHttpExchange(HttpExchange httpExchange) {
        this.httpExchange = httpExchange;
    }

    public void execute() {
        HttpMarsRequest request = new HttpMarsRequest(this.httpExchange);
        HttpMarsResponse response = new HttpMarsResponse(this.httpExchange);
        try {
            Object result = "ok";
            String uri = RequestUtil.getUriName(request);
            if (!PathAccess.hasAccess(uri).booleanValue()) {
                request = HttpMarsRequestFactory.getHttpMarsRequest(this.httpExchange, request);
                Class cls = CoreServletClass.getCls();
                Object object = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Method helloMethod = cls.getDeclaredMethod("doRequest", HttpMarsRequest.class, HttpMarsResponse.class);
                result = helloMethod.invoke(object, request, response);
            }
            ParamAndResultFactory.getBaseParamAndResult().result(response, result);
        }
        catch (Exception e) {
            this.log.error("\u5904\u7406\u8bf7\u6c42\u7684\u65f6\u5019\u51fa\u9519", (Throwable)e);
            String msg = this.getErrorMsg(e);
            response.send(MesUtil.getMes((Integer)500, (String)msg).toJSONString());
        }
    }

    private String getErrorMsg(Exception e) {
        String msg = null;
        if (e instanceof InvocationTargetException) {
            InvocationTargetException invocationTargetException = (InvocationTargetException)e;
            msg = invocationTargetException.getTargetException().getMessage();
        } else {
            msg = e.getMessage();
        }
        if (StringUtil.isNull((Object)msg) || msg.trim().toUpperCase().equals("NULL")) {
            msg = "\u670d\u52a1\u7aef\u51fa\u73b0\u5f02\u5e38,\u8bf7\u67e5\u770b\u65e5\u5fd7\u4ee5\u53ca\u68c0\u67e5\u60a8\u7684\u4ee3\u7801\u8fdb\u884c\u6392\u67e5";
        }
        return msg;
    }
}

