// Copyright 2021 Tencent Inc. All rights reserved.
//
// 公共出行平台代扣服务对外API
//
// 公共出行平台代扣服务对外API
//
// API version: 1.0.0

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.weixinpayscanandride.model;

import static com.wechat.pay.java.core.util.StringUtil.toIndentedString;

import com.google.gson.annotations.SerializedName;
import java.util.List;

/** TransactionsEntity */
public class TransactionsEntity {
  /** 公众账号ID 说明：商户在微信申请公众号或移动应用成功后分配的账号ID，登录平台为mp.weixin.qq.com或open.weixin.qq.com */
  @SerializedName("appid")
  private String appid;

  /** 子商户公众账号ID 说明：子商户申请的公众号或移动应用AppID，需要在服务商的商户平台为子商户绑定 */
  @SerializedName("sub_appid")
  private String subAppid;

  /** 商户号 说明：微信支付分配的商户号 */
  @SerializedName("sp_mchid")
  private String spMchid;

  /** 子商户号 说明：微信支付分配的子商户号 */
  @SerializedName("sub_mchid")
  private String subMchid;

  /** 服务描述 说明：商户自定义字段，用于交易账单中对扣费服务的描述。 */
  @SerializedName("description")
  private String description;

  /** 订单创建时间 说明：订单成功创建时返回，按照使用rfc3339所定义的格式，格式为yyyy-MM-DDThh:mm:ss+TIMEZONE */
  @SerializedName("create_time")
  private String createTime;

  /** 商户订单号 说明：商户系统内部订单号，只能是数字、大小写字母，且在同一个商户号下唯一 */
  @SerializedName("out_trade_no")
  private String outTradeNo;

  /** 微信支付订单号 说明：微信支付订单号 */
  @SerializedName("transaction_id")
  private String transactionId;

  /** 交易状态 说明：交易状态，枚举值： */
  @SerializedName("trade_state")
  private TradeState tradeState;

  /** 交易状态描述 说明：对当前订单状态的描述和下一步操作的指引 */
  @SerializedName("trade_state_description")
  private String tradeStateDescription;

  /** 支付完成时间 说明：订单支付完成时间，按照使用rfc3339所定义的格式，格式为yyyy-MM-DDThh:mm:ss+TIMEZONE */
  @SerializedName("success_time")
  private String successTime;

  /**
   * 付款银行 说明：银行类型，采用字符串类型的银行标识，详细可参考
   * 微信支付银行类型标识（https://pay.weixin.qq.com/wiki/doc/apiv3/terms_definition/chapter1_1_3.shtml）。 特殊标识
   * BPA：该笔订单由微信进行垫付
   */
  @SerializedName("bank_type")
  private String bankType;

  /**
   * 用户还款状态 说明：该字段标识对应的垫资单是否已还款或者已撤销。注意，使用此字段前需先确认bank_type字段值为BPA 以及
   * trade_state字段值为SUCCESS或者REFUND。枚举值如下：
   */
  @SerializedName("user_repay_state")
  private UserRepayState userRepayState;

  /** 还款微信支付订单号 说明：用户还款成功的微信支付订单号。用户已还款会返回该字段。 */
  @SerializedName("repay_transaction_id")
  private String repayTransactionId;

  /**
   * 垫资还款时间 说明：垫资还款时间，该笔订单发生过垫资，并且用户还款成功后，会返回该字段信息，按照使用rfc3339所定义的格式，格式为yyyy-MM-DDThh:mm:ss+TIMEZONE
   */
  @SerializedName("repay_time")
  private String repayTime;

  /** 附加数据 说明：附加数据，在查询API和支付通知中原样返回，可作为自定义参数使用 */
  @SerializedName("attach")
  private String attach;

  /** 代扣签约ID 说明：签约成功后，微信返回的代扣签约ID */
  @SerializedName("contract_id")
  private String contractId;

  /** 交易场景 说明：交易场景值，枚举值： */
  @SerializedName("trade_scene")
  private TradeScene tradeScene;

  /** 公交场景信息 说明：返回信息中的trade_scene为BUS，返回该场景信息 */
  @SerializedName("bus_info")
  private BusSceneInfo busInfo;

  /** 地铁场景信息 说明：返回信息中的trade_scene为METRO，返回该场景信息 */
  @SerializedName("metro_info")
  private MetroSceneInfo metroInfo;

  /** 订单金额信息 说明：订单金额信息 */
  @SerializedName("amount")
  private QueryOrderAmount amount;

  /** 优惠信息 说明：优惠信息 */
  @SerializedName("promotion_detail")
  private List<PromotionDetail> promotionDetail;

  public String getAppid() {
    return appid;
  }

  public void setAppid(String appid) {
    this.appid = appid;
  }

  public String getSubAppid() {
    return subAppid;
  }

  public void setSubAppid(String subAppid) {
    this.subAppid = subAppid;
  }

  public String getSpMchid() {
    return spMchid;
  }

  public void setSpMchid(String spMchid) {
    this.spMchid = spMchid;
  }

  public String getSubMchid() {
    return subMchid;
  }

  public void setSubMchid(String subMchid) {
    this.subMchid = subMchid;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  public String getOutTradeNo() {
    return outTradeNo;
  }

  public void setOutTradeNo(String outTradeNo) {
    this.outTradeNo = outTradeNo;
  }

  public String getTransactionId() {
    return transactionId;
  }

  public void setTransactionId(String transactionId) {
    this.transactionId = transactionId;
  }

  public TradeState getTradeState() {
    return tradeState;
  }

  public void setTradeState(TradeState tradeState) {
    this.tradeState = tradeState;
  }

  public String getTradeStateDescription() {
    return tradeStateDescription;
  }

  public void setTradeStateDescription(String tradeStateDescription) {
    this.tradeStateDescription = tradeStateDescription;
  }

  public String getSuccessTime() {
    return successTime;
  }

  public void setSuccessTime(String successTime) {
    this.successTime = successTime;
  }

  public String getBankType() {
    return bankType;
  }

  public void setBankType(String bankType) {
    this.bankType = bankType;
  }

  public UserRepayState getUserRepayState() {
    return userRepayState;
  }

  public void setUserRepayState(UserRepayState userRepayState) {
    this.userRepayState = userRepayState;
  }

  public String getRepayTransactionId() {
    return repayTransactionId;
  }

  public void setRepayTransactionId(String repayTransactionId) {
    this.repayTransactionId = repayTransactionId;
  }

  public String getRepayTime() {
    return repayTime;
  }

  public void setRepayTime(String repayTime) {
    this.repayTime = repayTime;
  }

  public String getAttach() {
    return attach;
  }

  public void setAttach(String attach) {
    this.attach = attach;
  }

  public String getContractId() {
    return contractId;
  }

  public void setContractId(String contractId) {
    this.contractId = contractId;
  }

  public TradeScene getTradeScene() {
    return tradeScene;
  }

  public void setTradeScene(TradeScene tradeScene) {
    this.tradeScene = tradeScene;
  }

  public BusSceneInfo getBusInfo() {
    return busInfo;
  }

  public void setBusInfo(BusSceneInfo busInfo) {
    this.busInfo = busInfo;
  }

  public MetroSceneInfo getMetroInfo() {
    return metroInfo;
  }

  public void setMetroInfo(MetroSceneInfo metroInfo) {
    this.metroInfo = metroInfo;
  }

  public QueryOrderAmount getAmount() {
    return amount;
  }

  public void setAmount(QueryOrderAmount amount) {
    this.amount = amount;
  }

  public List<PromotionDetail> getPromotionDetail() {
    return promotionDetail;
  }

  public void setPromotionDetail(List<PromotionDetail> promotionDetail) {
    this.promotionDetail = promotionDetail;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TransactionsEntity {\n");
    sb.append("    appid: ").append(toIndentedString(appid)).append("\n");
    sb.append("    subAppid: ").append(toIndentedString(subAppid)).append("\n");
    sb.append("    spMchid: ").append(toIndentedString(spMchid)).append("\n");
    sb.append("    subMchid: ").append(toIndentedString(subMchid)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    outTradeNo: ").append(toIndentedString(outTradeNo)).append("\n");
    sb.append("    transactionId: ").append(toIndentedString(transactionId)).append("\n");
    sb.append("    tradeState: ").append(toIndentedString(tradeState)).append("\n");
    sb.append("    tradeStateDescription: ")
        .append(toIndentedString(tradeStateDescription))
        .append("\n");
    sb.append("    successTime: ").append(toIndentedString(successTime)).append("\n");
    sb.append("    bankType: ").append(toIndentedString(bankType)).append("\n");
    sb.append("    userRepayState: ").append(toIndentedString(userRepayState)).append("\n");
    sb.append("    repayTransactionId: ").append(toIndentedString(repayTransactionId)).append("\n");
    sb.append("    repayTime: ").append(toIndentedString(repayTime)).append("\n");
    sb.append("    attach: ").append(toIndentedString(attach)).append("\n");
    sb.append("    contractId: ").append(toIndentedString(contractId)).append("\n");
    sb.append("    tradeScene: ").append(toIndentedString(tradeScene)).append("\n");
    sb.append("    busInfo: ").append(toIndentedString(busInfo)).append("\n");
    sb.append("    metroInfo: ").append(toIndentedString(metroInfo)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    promotionDetail: ").append(toIndentedString(promotionDetail)).append("\n");
    sb.append("}");
    return sb.toString();
  }
}
