// Copyright 2021 Tencent Inc. All rights reserved.
//
// 营销加价购对外API
//
// 指定服务商可通过该接口报名加价购活动、查询某个区域内的加价购活动列表、锁定加价活动购资格以及解锁加价购活动资格。
//
// API version: 1.4.0

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.retailstore;

import static com.wechat.pay.java.core.http.UrlEncoder.urlEncode;
import static com.wechat.pay.java.core.util.GsonUtil.toJson;
import static java.util.Objects.requireNonNull;

import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.exception.HttpException;
import com.wechat.pay.java.core.exception.MalformedMessageException;
import com.wechat.pay.java.core.exception.ServiceException;
import com.wechat.pay.java.core.exception.ValidationException;
import com.wechat.pay.java.core.http.Constant;
import com.wechat.pay.java.core.http.DefaultHttpClientBuilder;
import com.wechat.pay.java.core.http.HostName;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.http.HttpHeaders;
import com.wechat.pay.java.core.http.HttpMethod;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.http.HttpResponse;
import com.wechat.pay.java.core.http.JsonRequestBody;
import com.wechat.pay.java.core.http.MediaType;
import com.wechat.pay.java.core.http.QueryParameter;
import com.wechat.pay.java.core.http.RequestBody;
import com.wechat.pay.java.service.retailstore.model.AddRepresentativeRequest;
import com.wechat.pay.java.service.retailstore.model.AddRepresentativesResponse;
import com.wechat.pay.java.service.retailstore.model.AddStoresRequest;
import com.wechat.pay.java.service.retailstore.model.AddStoresResponse;
import com.wechat.pay.java.service.retailstore.model.ApplyActivityRequest;
import com.wechat.pay.java.service.retailstore.model.ApplyActivityResponse;
import com.wechat.pay.java.service.retailstore.model.CreateMaterialsRequest;
import com.wechat.pay.java.service.retailstore.model.DeleteRepresentativeRequest;
import com.wechat.pay.java.service.retailstore.model.DeleteRepresentativeResponse;
import com.wechat.pay.java.service.retailstore.model.DeleteStoresRequest;
import com.wechat.pay.java.service.retailstore.model.DeleteStoresResponse;
import com.wechat.pay.java.service.retailstore.model.GetStoreRequest;
import com.wechat.pay.java.service.retailstore.model.ListActsByAreaRequest;
import com.wechat.pay.java.service.retailstore.model.ListActsByAreaResponse;
import com.wechat.pay.java.service.retailstore.model.ListRepresentativeRequest;
import com.wechat.pay.java.service.retailstore.model.ListRepresentativeResponse;
import com.wechat.pay.java.service.retailstore.model.ListStoreRequest;
import com.wechat.pay.java.service.retailstore.model.ListStoreResponse;
import com.wechat.pay.java.service.retailstore.model.LockQualificationRequest;
import com.wechat.pay.java.service.retailstore.model.LockQualificationResponse;
import com.wechat.pay.java.service.retailstore.model.Materials;
import com.wechat.pay.java.service.retailstore.model.RetailStoreInfo;
import com.wechat.pay.java.service.retailstore.model.UnlockQualificationRequest;
import com.wechat.pay.java.service.retailstore.model.UnlockQualificationResponse;

/** RetailStoreService服务 */
public class RetailStoreService {

  private final HttpClient httpClient;
  private final HostName hostName;

  private RetailStoreService(HttpClient httpClient, HostName hostName) {
    this.httpClient = requireNonNull(httpClient);
    this.hostName = hostName;
  }

  /** RetailStoreService构造器 */
  public static class Builder {

    private HttpClient httpClient;
    private HostName hostName;

    public Builder config(Config config) {
      this.httpClient = new DefaultHttpClientBuilder().config(config).build();

      return this;
    }

    public Builder hostName(HostName hostName) {
      this.hostName = hostName;
      return this;
    }

    public Builder httpClient(HttpClient httpClient) {
      this.httpClient = httpClient;
      return this;
    }

    public RetailStoreService build() {
      return new RetailStoreService(httpClient, hostName);
    }
  }

  /**
   * 门店报名品牌加价购活动
   *
   * @param request 请求参数
   * @return ApplyActivityResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public ApplyActivityResponse applyActivity(ApplyActivityRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/goods-subsidy-activity/activity/{activity_id}/apply";

    ApplyActivityRequest realRequest = request;
    // 添加 path param
    requestPath =
        requestPath.replace("{" + "activity_id" + "}", urlEncode(realRequest.getActivityId()));

    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.POST)
            .url(requestPath)
            .headers(headers)
            .body(createRequestBody(realRequest))
            .build();
    HttpResponse<ApplyActivityResponse> httpResponse =
        httpClient.execute(httpRequest, ApplyActivityResponse.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 按区域查询品牌加价购活动
   *
   * @param request 请求参数
   * @return ListActsByAreaResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public ListActsByAreaResponse listActsByArea(ListActsByAreaRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/goods-subsidy-activity/activities";

    ListActsByAreaRequest realRequest = request;
    // 添加 query param
    QueryParameter queryParameter = new QueryParameter();
    if (realRequest.getCityId() != null) {
      queryParameter.add("city_id", urlEncode(realRequest.getCityId()));
    }
    if (realRequest.getOffset() != null) {
      queryParameter.add("offset", urlEncode(realRequest.getOffset().toString()));
    }
    if (realRequest.getLimit() != null) {
      queryParameter.add("limit", urlEncode(realRequest.getLimit().toString()));
    }
    requestPath += queryParameter.getQueryStr();
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.GET)
            .url(requestPath)
            .headers(headers)
            .build();
    HttpResponse<ListActsByAreaResponse> httpResponse =
        httpClient.execute(httpRequest, ListActsByAreaResponse.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 锁定品牌加价购活动资格
   *
   * @param request 请求参数
   * @return LockQualificationResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public LockQualificationResponse lockQualification(LockQualificationRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/goods-subsidy-activity/qualification/lock";
    LockQualificationRequest realRequest = request;
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.POST)
            .url(requestPath)
            .headers(headers)
            .body(createRequestBody(realRequest))
            .build();
    HttpResponse<LockQualificationResponse> httpResponse =
        httpClient.execute(httpRequest, LockQualificationResponse.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 解锁品牌加价购活动资格
   *
   * @param request 请求参数
   * @return UnlockQualificationResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public UnlockQualificationResponse unlockQualification(UnlockQualificationRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/goods-subsidy-activity/qualification/unlock";
    UnlockQualificationRequest realRequest = request;
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.POST)
            .url(requestPath)
            .headers(headers)
            .body(createRequestBody(realRequest))
            .build();
    HttpResponse<UnlockQualificationResponse> httpResponse =
        httpClient.execute(httpRequest, UnlockQualificationResponse.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 添加零售小店活动业务代理
   *
   * @param request 请求参数
   * @return AddRepresentativesResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public AddRepresentativesResponse addRepresentative(AddRepresentativeRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/goods-subsidy-activity/retail-store-act/{activity_id}/representative";

    AddRepresentativeRequest realRequest = request;
    // 添加 path param
    requestPath =
        requestPath.replace("{" + "activity_id" + "}", urlEncode(realRequest.getActivityId()));

    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.PUT)
            .url(requestPath)
            .headers(headers)
            .body(createRequestBody(realRequest))
            .build();
    HttpResponse<AddRepresentativesResponse> httpResponse =
        httpClient.execute(httpRequest, AddRepresentativesResponse.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 添加小店活动门店
   *
   * @param request 请求参数
   * @return AddStoresResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public AddStoresResponse addStores(AddStoresRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/goods-subsidy-activity/retail-store-act/{brand_id}/stores";

    AddStoresRequest realRequest = request;
    // 添加 path param
    requestPath = requestPath.replace("{" + "brand_id" + "}", urlEncode(realRequest.getBrandId()));

    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.POST)
            .url(requestPath)
            .headers(headers)
            .body(createRequestBody(realRequest))
            .build();
    HttpResponse<AddStoresResponse> httpResponse =
        httpClient.execute(httpRequest, AddStoresResponse.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 生成小店活动物料码
   *
   * @param request 请求参数
   * @return Materials
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public Materials createMaterials(CreateMaterialsRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/goods-subsidy-activity/retail-store-act/{brand_id}/materials";

    CreateMaterialsRequest realRequest = request;
    // 添加 path param
    requestPath = requestPath.replace("{" + "brand_id" + "}", urlEncode(realRequest.getBrandId()));

    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.POST)
            .url(requestPath)
            .headers(headers)
            .body(createRequestBody(realRequest))
            .build();
    HttpResponse<Materials> httpResponse = httpClient.execute(httpRequest, Materials.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 删除零售小店活动业务代理
   *
   * @param request 请求参数
   * @return DeleteRepresentativeResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public DeleteRepresentativeResponse deleteRepresentative(DeleteRepresentativeRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/goods-subsidy-activity/retail-store-act/{activity_id}/representative";

    DeleteRepresentativeRequest realRequest = request;
    // 添加 path param
    requestPath =
        requestPath.replace("{" + "activity_id" + "}", urlEncode(realRequest.getActivityId()));

    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.DELETE)
            .url(requestPath)
            .headers(headers)
            .body(createRequestBody(realRequest))
            .build();
    HttpResponse<DeleteRepresentativeResponse> httpResponse =
        httpClient.execute(httpRequest, DeleteRepresentativeResponse.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 删除小店活动门店
   *
   * @param request 请求参数
   * @return DeleteStoresResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public DeleteStoresResponse deleteStores(DeleteStoresRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/goods-subsidy-activity/retail-store-act/{brand_id}/stores";

    DeleteStoresRequest realRequest = request;
    // 添加 path param
    requestPath = requestPath.replace("{" + "brand_id" + "}", urlEncode(realRequest.getBrandId()));

    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.DELETE)
            .url(requestPath)
            .headers(headers)
            .body(createRequestBody(realRequest))
            .build();
    HttpResponse<DeleteStoresResponse> httpResponse =
        httpClient.execute(httpRequest, DeleteStoresResponse.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 查询小店活动门店详情
   *
   * @param request 请求参数
   * @return RetailStoreInfo
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public RetailStoreInfo getStore(GetStoreRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/goods-subsidy-activity/retail-store-act/{brand_id}/stores/{store_code}";

    GetStoreRequest realRequest = request;
    // 添加 path param
    requestPath = requestPath.replace("{" + "brand_id" + "}", urlEncode(realRequest.getBrandId()));

    requestPath =
        requestPath.replace("{" + "store_code" + "}", urlEncode(realRequest.getStoreCode()));

    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.GET)
            .url(requestPath)
            .headers(headers)
            .build();
    HttpResponse<RetailStoreInfo> httpResponse =
        httpClient.execute(httpRequest, RetailStoreInfo.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 查询零售小店活动业务代理
   *
   * @param request 请求参数
   * @return ListRepresentativeResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public ListRepresentativeResponse listRepresentative(ListRepresentativeRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/goods-subsidy-activity/retail-store-act/{activity_id}/representatives";

    ListRepresentativeRequest realRequest = request;
    // 添加 path param
    requestPath =
        requestPath.replace("{" + "activity_id" + "}", urlEncode(realRequest.getActivityId()));

    // 添加 query param
    QueryParameter queryParameter = new QueryParameter();
    if (realRequest.getOffset() != null) {
      queryParameter.add("offset", urlEncode(realRequest.getOffset().toString()));
    }
    if (realRequest.getLimit() != null) {
      queryParameter.add("limit", urlEncode(realRequest.getLimit().toString()));
    }
    requestPath += queryParameter.getQueryStr();
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.GET)
            .url(requestPath)
            .headers(headers)
            .build();
    HttpResponse<ListRepresentativeResponse> httpResponse =
        httpClient.execute(httpRequest, ListRepresentativeResponse.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 查询小店活动门店列表
   *
   * @param request 请求参数
   * @return ListStoreResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public ListStoreResponse listStore(ListStoreRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/goods-subsidy-activity/retail-store-act/{brand_id}/stores";

    ListStoreRequest realRequest = request;
    // 添加 path param
    requestPath = requestPath.replace("{" + "brand_id" + "}", urlEncode(realRequest.getBrandId()));

    // 添加 query param
    QueryParameter queryParameter = new QueryParameter();
    if (realRequest.getOffset() != null) {
      queryParameter.add("offset", urlEncode(realRequest.getOffset().toString()));
    }
    if (realRequest.getLimit() != null) {
      queryParameter.add("limit", urlEncode(realRequest.getLimit().toString()));
    }
    requestPath += queryParameter.getQueryStr();
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.GET)
            .url(requestPath)
            .headers(headers)
            .build();
    HttpResponse<ListStoreResponse> httpResponse =
        httpClient.execute(httpRequest, ListStoreResponse.class);
    return httpResponse.getServiceResponse();
  }

  private RequestBody createRequestBody(Object request) {
    return new JsonRequestBody.Builder().body(toJson(request)).build();
  }
}
