// Copyright 2021 Tencent Inc. All rights reserved.
//
// 微信支付分账API
//
// 微信支付分账API
//
// API version: 0.0.9

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.profitsharing.model;

import static com.wechat.pay.java.core.util.StringUtil.toIndentedString;

import com.google.gson.annotations.SerializedName;
import com.wechat.pay.java.core.cipher.Encryption;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;

/** CreateOrderRequest */
public class CreateOrderRequest {
  /** 子商户号 说明：微信支付分配的子商户号，即分账的出资商户号。（直连商户不需要，服务商需要） */
  @SerializedName("sub_mchid")
  private String subMchid;

  /** 公众账号ID 说明：微信分配的服务商appid */
  @SerializedName("appid")
  private String appid;

  /** 子商户公众账号ID 说明：微信分配的子商户公众账号ID，分账接收方类型包含PERSONAL_SUB_OPENID时必填。（直连商户不需要，服务商需要） */
  @SerializedName("sub_appid")
  private String subAppid;

  /** 微信订单号 说明：微信支付订单号 */
  @SerializedName("transaction_id")
  private String transactionId;

  /** 商户分账单号 说明：服务商系统内部的分账单号，在服务商系统内部唯一，同一分账单号多次请求等同一次。只能是数字、大小写字母_-|*@ */
  @SerializedName("out_order_no")
  private String outOrderNo;

  /** 分账接收方列表 说明：分账接收方列表，可以设置出资商户作为分账接受方，最多可有50个分账接收方 */
  @Encryption
  @SerializedName("receivers")
  private List<CreateOrderReceiver> receivers = new ArrayList<CreateOrderReceiver>();

  /**
   * 是否解冻剩余未分资金 说明：1、如果为true，该笔订单剩余未分账的金额会解冻回分账方商户； 2、如果为false，该笔订单剩余未分账的金额不会解冻回分账方商户，可以对该笔订单再次进行分账。
   */
  @SerializedName("unfreeze_unsplit")
  private Boolean unfreezeUnsplit;

  /** 分账结果回调url 说明：异步接收微信支付分账结果通知的回调地址，通知url必须为外网可访问的url，不能携带参数 */
  @SerializedName("notify_url")
  private String notifyUrl;

  public String getSubMchid() {
    return subMchid;
  }

  public void setSubMchid(String subMchid) {
    this.subMchid = subMchid;
  }

  public String getAppid() {
    return appid;
  }

  public void setAppid(String appid) {
    this.appid = appid;
  }

  public String getSubAppid() {
    return subAppid;
  }

  public void setSubAppid(String subAppid) {
    this.subAppid = subAppid;
  }

  public String getTransactionId() {
    return transactionId;
  }

  public void setTransactionId(String transactionId) {
    this.transactionId = transactionId;
  }

  public String getOutOrderNo() {
    return outOrderNo;
  }

  public void setOutOrderNo(String outOrderNo) {
    this.outOrderNo = outOrderNo;
  }

  public List<CreateOrderReceiver> getReceivers() {
    return receivers;
  }

  public void setReceivers(List<CreateOrderReceiver> receivers) {
    this.receivers = receivers;
  }

  public Boolean getUnfreezeUnsplit() {
    return unfreezeUnsplit;
  }

  public void setUnfreezeUnsplit(Boolean unfreezeUnsplit) {
    this.unfreezeUnsplit = unfreezeUnsplit;
  }

  public String getNotifyUrl() {
    return notifyUrl;
  }

  public void setNotifyUrl(String notifyUrl) {
    this.notifyUrl = notifyUrl;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateOrderRequest {\n");
    sb.append("    subMchid: ").append(toIndentedString(subMchid)).append("\n");
    sb.append("    appid: ").append(toIndentedString(appid)).append("\n");
    sb.append("    subAppid: ").append(toIndentedString(subAppid)).append("\n");
    sb.append("    transactionId: ").append(toIndentedString(transactionId)).append("\n");
    sb.append("    outOrderNo: ").append(toIndentedString(outOrderNo)).append("\n");
    sb.append("    receivers: ").append(toIndentedString(receivers)).append("\n");
    sb.append("    unfreezeUnsplit: ").append(toIndentedString(unfreezeUnsplit)).append("\n");
    sb.append("    notifyUrl: ").append(toIndentedString(notifyUrl)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  public CreateOrderRequest cloneWithCipher(UnaryOperator<String> s) {
    CreateOrderRequest copy = new CreateOrderRequest();
    copy.subMchid = subMchid;
    copy.appid = appid;
    copy.subAppid = subAppid;
    copy.transactionId = transactionId;
    copy.outOrderNo = outOrderNo;
    if (receivers != null && receivers.size() != 0) {
      // arr
      copy.receivers = new ArrayList<>();
      for (CreateOrderReceiver val : receivers) {
        if (val != null) {
          copy.receivers.add(val.cloneWithCipher(s));
        }
      }
    }
    copy.unfreezeUnsplit = unfreezeUnsplit;
    copy.notifyUrl = notifyUrl;
    return copy;
  }
}
