// Copyright 2021 Tencent Inc. All rights reserved.
//
// 微信支付分账API
//
// 微信支付分账API
//
// API version: 0.0.9

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.profitsharing.model;

import static com.wechat.pay.java.core.util.StringUtil.toIndentedString;

import com.google.gson.annotations.SerializedName;
import com.wechat.pay.java.core.cipher.Encryption;
import java.util.function.UnaryOperator;

/** AddReceiverRequest */
public class AddReceiverRequest {
  /** 子商户号 说明：微信支付分配的子商户号，即分账的出资商户号。（直连商户不需要，服务商需要） */
  @SerializedName("sub_mchid")
  private String subMchid;

  /** 公众账号ID 说明：微信分配的公众账号ID */
  @SerializedName("appid")
  private String appid;

  /** 子商户公众账号ID 说明：子商户的公众账号ID，分账接收方类型包含PERSONAL_SUB_OPENID时必填。（直连商户不需要，服务商需要） */
  @SerializedName("sub_appid")
  private String subAppid;

  /**
   * 接收方类型 说明：枚举值： MERCHANT_ID：商户ID PERSONAL_OPENID：个人openid（由父商户APPID转换得到）
   * PERSONAL_SUB_OPENID：个人sub_openid（由子商户APPID转换得到）
   */
  @SerializedName("type")
  private ReceiverType type;

  /**
   * 接收方账号 说明：类型是MERCHANT_ID时，是商户号 类型是PERSONAL_OPENID时，是个人openid
   * 类型是PERSONAL_SUB_OPENID时，是个人sub_openid
   */
  @SerializedName("account")
  private String account;

  /**
   * 分账接收方全称 说明：分账接收方类型是MERCHANT_ID时，是商户全称（必传），当商户是小微商户或个体户时，是开户人姓名
   * 分账接收方类型是PERSONAL_OPENID时，是个人姓名（选传，传则校验） 分账接收方类型是PERSONAL_SUB_OPENID时，是个人姓名（选传，传则校验）
   * 1、此字段需要加密，的加密方法详见：敏感信息加密说明 2、使用微信支付平台证书中的公钥 3、使用RSAES-OAEP算法进行加密
   * 4、将请求中HTTP头部的Wechatpay-Serial设置为证书序列号
   */
  @Encryption
  @SerializedName("name")
  private String name;

  /**
   * 与分账方的关系类型 说明：子商户与接收方的关系。 本字段值为枚举： SERVICE_PROVIDER：服务商 STORE：门店 STAFF：员工 STORE_OWNER：店主
   * PARTNER：合作伙伴 HEADQUARTER：总部 BRAND：品牌方 DISTRIBUTOR：分销商 USER：用户 SUPPLIER：供应商 CUSTOM：自定义
   */
  @SerializedName("relation_type")
  private ReceiverRelationType relationType;

  /**
   * 自定义的分账关系 说明：子商户与接收方具体的关系，本字段最多10个字。 当字段relation_type的值为CUSTOM时，本字段必填
   * 当字段relation_type的值不为CUSTOM时，本字段无需填写
   */
  @SerializedName("custom_relation")
  private String customRelation;

  public String getSubMchid() {
    return subMchid;
  }

  public void setSubMchid(String subMchid) {
    this.subMchid = subMchid;
  }

  public String getAppid() {
    return appid;
  }

  public void setAppid(String appid) {
    this.appid = appid;
  }

  public String getSubAppid() {
    return subAppid;
  }

  public void setSubAppid(String subAppid) {
    this.subAppid = subAppid;
  }

  public ReceiverType getType() {
    return type;
  }

  public void setType(ReceiverType type) {
    this.type = type;
  }

  public String getAccount() {
    return account;
  }

  public void setAccount(String account) {
    this.account = account;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public ReceiverRelationType getRelationType() {
    return relationType;
  }

  public void setRelationType(ReceiverRelationType relationType) {
    this.relationType = relationType;
  }

  public String getCustomRelation() {
    return customRelation;
  }

  public void setCustomRelation(String customRelation) {
    this.customRelation = customRelation;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AddReceiverRequest {\n");
    sb.append("    subMchid: ").append(toIndentedString(subMchid)).append("\n");
    sb.append("    appid: ").append(toIndentedString(appid)).append("\n");
    sb.append("    subAppid: ").append(toIndentedString(subAppid)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    account: ").append(toIndentedString(account)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    relationType: ").append(toIndentedString(relationType)).append("\n");
    sb.append("    customRelation: ").append(toIndentedString(customRelation)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  public AddReceiverRequest cloneWithCipher(UnaryOperator<String> s) {
    AddReceiverRequest copy = new AddReceiverRequest();
    copy.subMchid = subMchid;
    copy.appid = appid;
    copy.subAppid = subAppid;
    copy.type = type;
    copy.account = account;
    if (name != null && !name.isEmpty()) {
      copy.name = s.apply(name);
    }
    copy.relationType = relationType;
    copy.customRelation = customRelation;
    return copy;
  }
}
