// Copyright 2021 Tencent Inc. All rights reserved.
//
// 营销商家券对外API
//
// No description provided (generated by Openapi Generator
// https://github.com/openapitools/openapi-generator)
//
// API version: 0.0.11

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.merchantexclusivecoupon;

import static com.wechat.pay.java.core.http.UrlEncoder.urlEncode;
import static com.wechat.pay.java.core.util.GsonUtil.toJson;
import static java.util.Objects.requireNonNull;

import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.exception.HttpException;
import com.wechat.pay.java.core.exception.MalformedMessageException;
import com.wechat.pay.java.core.exception.ServiceException;
import com.wechat.pay.java.core.exception.ValidationException;
import com.wechat.pay.java.core.http.Constant;
import com.wechat.pay.java.core.http.DefaultHttpClientBuilder;
import com.wechat.pay.java.core.http.HostName;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.http.HttpHeaders;
import com.wechat.pay.java.core.http.HttpMethod;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.http.HttpResponse;
import com.wechat.pay.java.core.http.JsonRequestBody;
import com.wechat.pay.java.core.http.MediaType;
import com.wechat.pay.java.core.http.QueryParameter;
import com.wechat.pay.java.core.http.RequestBody;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.AssociateTradeInfoRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.AssociateTradeInfoResponse;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.CouponCodeInfoRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.CouponCodeInfoResponse;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.CouponCodeListResponse;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.CouponEntity;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.CouponListResponse;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.CouponSendGovCardResponse;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.CreateBusiFavorStockRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.CreateBusiFavorStockResponse;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.DeactivateCouponRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.DeactivateCouponResponse;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.DeleteCouponCodeRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.DeleteCouponCodeResponse;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.DisassociateTradeInfoRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.DisassociateTradeInfoResponse;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.GetCouponNotifyRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.GetCouponNotifyResponse;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.ListCouponsByFilterRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.ModifyBudgetRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.ModifyBudgetResponse;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.ModifyStockInfoRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.PayReceiptInfoRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.PayReceiptListRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.QueryCouponCodeListRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.QueryCouponRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.QueryStockRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.ReturnCouponRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.ReturnCouponResponse;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.ReturnReceiptInfoRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.SendCouponRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.SendCouponResponse;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.SendGovCardRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.SetCouponNotifyRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.SetCouponNotifyResponse;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.StockGetResponse;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.SubsidyPayReceipt;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.SubsidyPayReceiptListResponse;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.SubsidyPayRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.SubsidyReturnReceipt;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.SubsidyReturnRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.UploadCouponCodeRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.UploadCouponCodeResponse;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.UseCouponRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.UseCouponResponse;

/** MerchantExclusiveCouponService服务 */
public class MerchantExclusiveCouponService {

  private final HttpClient httpClient;
  private final HostName hostName;

  private MerchantExclusiveCouponService(HttpClient httpClient, HostName hostName) {
    this.httpClient = requireNonNull(httpClient);
    this.hostName = hostName;
  }

  /** MerchantExclusiveCouponService构造器 */
  public static class Builder {

    private HttpClient httpClient;
    private HostName hostName;

    public Builder config(Config config) {
      this.httpClient = new DefaultHttpClientBuilder().config(config).build();

      return this;
    }

    public Builder hostName(HostName hostName) {
      this.hostName = hostName;
      return this;
    }

    public Builder httpClient(HttpClient httpClient) {
      this.httpClient = httpClient;
      return this;
    }

    public MerchantExclusiveCouponService build() {
      return new MerchantExclusiveCouponService(httpClient, hostName);
    }
  }

  /**
   * 查询预存code详情
   *
   * @param request 请求参数
   * @return CouponCodeInfoResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public CouponCodeInfoResponse couponCodeInfo(CouponCodeInfoRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/busifavor/stocks/{stock_id}/couponcodes/{coupon_code}";

    CouponCodeInfoRequest realRequest = request;
    // 添加 path param
    requestPath = requestPath.replace("{" + "stock_id" + "}", urlEncode(realRequest.getStockId()));

    requestPath =
        requestPath.replace("{" + "coupon_code" + "}", urlEncode(realRequest.getCouponCode()));

    // 添加 query param
    QueryParameter queryParameter = new QueryParameter();
    if (realRequest.getAppid() != null) {
      queryParameter.add("appid", urlEncode(realRequest.getAppid()));
    }
    requestPath += queryParameter.getQueryStr();
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.GET)
            .url(requestPath)
            .headers(headers)
            .build();
    HttpResponse<CouponCodeInfoResponse> httpResponse =
        httpClient.execute(httpRequest, CouponCodeInfoResponse.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 创建商家券
   *
   * @param request 请求参数
   * @return CreateBusiFavorStockResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public CreateBusiFavorStockResponse createBusifavorStock(CreateBusiFavorStockRequest request) {
    String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/busifavor/stocks";
    CreateBusiFavorStockRequest realRequest = request;
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.POST)
            .url(requestPath)
            .headers(headers)
            .body(createRequestBody(realRequest))
            .build();
    HttpResponse<CreateBusiFavorStockResponse> httpResponse =
        httpClient.execute(httpRequest, CreateBusiFavorStockResponse.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 删除预存code
   *
   * @param request 请求参数
   * @return DeleteCouponCodeResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public DeleteCouponCodeResponse deleteCouponCode(DeleteCouponCodeRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/busifavor/stocks/{stock_id}/couponcodes/{coupon_code}";

    DeleteCouponCodeRequest realRequest = request;
    // 添加 path param
    requestPath = requestPath.replace("{" + "stock_id" + "}", urlEncode(realRequest.getStockId()));

    requestPath =
        requestPath.replace("{" + "coupon_code" + "}", urlEncode(realRequest.getCouponCode()));

    // 添加 query param
    QueryParameter queryParameter = new QueryParameter();
    if (realRequest.getDeleteRequestNo() != null) {
      queryParameter.add("delete_request_no", urlEncode(realRequest.getDeleteRequestNo()));
    }
    requestPath += queryParameter.getQueryStr();
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.DELETE)
            .url(requestPath)
            .headers(headers)
            .build();
    HttpResponse<DeleteCouponCodeResponse> httpResponse =
        httpClient.execute(httpRequest, DeleteCouponCodeResponse.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 修改批次预算
   *
   * @param request 请求参数
   * @return ModifyBudgetResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public ModifyBudgetResponse modifyBudget(ModifyBudgetRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/busifavor/stocks/{stock_id}/budget";

    ModifyBudgetRequest realRequest = request;
    // 添加 path param
    requestPath = requestPath.replace("{" + "stock_id" + "}", urlEncode(realRequest.getStockId()));

    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.PATCH)
            .url(requestPath)
            .headers(headers)
            .body(createRequestBody(realRequest))
            .build();
    HttpResponse<ModifyBudgetResponse> httpResponse =
        httpClient.execute(httpRequest, ModifyBudgetResponse.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 修改商家券基本信息
   *
   * @param request 请求参数
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public void modifyStockInfo(ModifyStockInfoRequest request) {
    String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/busifavor/stocks/{stock_id}";

    ModifyStockInfoRequest realRequest = request;
    // 添加 path param
    requestPath = requestPath.replace("{" + "stock_id" + "}", urlEncode(realRequest.getStockId()));

    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.PATCH)
            .url(requestPath)
            .headers(headers)
            .body(createRequestBody(realRequest))
            .build();
    httpClient.execute(httpRequest, null);
  }

  /**
   * 查询预存code列表
   *
   * @param request 请求参数
   * @return CouponCodeListResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public CouponCodeListResponse queryCouponCodeList(QueryCouponCodeListRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/busifavor/stocks/{stock_id}/couponcodes";

    QueryCouponCodeListRequest realRequest = request;
    // 添加 path param
    requestPath = requestPath.replace("{" + "stock_id" + "}", urlEncode(realRequest.getStockId()));

    // 添加 query param
    QueryParameter queryParameter = new QueryParameter();
    if (realRequest.getLimit() != null) {
      queryParameter.add("limit", urlEncode(realRequest.getLimit().toString()));
    }
    if (realRequest.getOffset() != null) {
      queryParameter.add("offset", urlEncode(realRequest.getOffset().toString()));
    }
    if (realRequest.getAppid() != null) {
      queryParameter.add("appid", urlEncode(realRequest.getAppid()));
    }
    if (realRequest.getStatus() != null) {
      queryParameter.add("status", urlEncode(realRequest.getStatus().toString()));
    }
    requestPath += queryParameter.getQueryStr();
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.GET)
            .url(requestPath)
            .headers(headers)
            .build();
    HttpResponse<CouponCodeListResponse> httpResponse =
        httpClient.execute(httpRequest, CouponCodeListResponse.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 查询商家券批次详情
   *
   * @param request 请求参数
   * @return StockGetResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public StockGetResponse queryStock(QueryStockRequest request) {
    String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/busifavor/stocks/{stock_id}";

    QueryStockRequest realRequest = request;
    // 添加 path param
    requestPath = requestPath.replace("{" + "stock_id" + "}", urlEncode(realRequest.getStockId()));

    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.GET)
            .url(requestPath)
            .headers(headers)
            .build();
    HttpResponse<StockGetResponse> httpResponse =
        httpClient.execute(httpRequest, StockGetResponse.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 上传预存code
   *
   * @param request 请求参数
   * @return UploadCouponCodeResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public UploadCouponCodeResponse uploadCouponCode(UploadCouponCodeRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/busifavor/stocks/{stock_id}/couponcodes";

    UploadCouponCodeRequest realRequest = request;
    // 添加 path param
    requestPath = requestPath.replace("{" + "stock_id" + "}", urlEncode(realRequest.getStockId()));

    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.POST)
            .url(requestPath)
            .headers(headers)
            .body(createRequestBody(realRequest))
            .build();
    HttpResponse<UploadCouponCodeResponse> httpResponse =
        httpClient.execute(httpRequest, UploadCouponCodeResponse.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 获取商家券事件通知地址
   *
   * @param request 请求参数
   * @return GetCouponNotifyResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public GetCouponNotifyResponse getCouponNotify(GetCouponNotifyRequest request) {
    String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/busifavor/callbacks";

    GetCouponNotifyRequest realRequest = request;
    // 添加 query param
    QueryParameter queryParameter = new QueryParameter();
    if (realRequest.getMchid() != null) {
      queryParameter.add("mchid", urlEncode(realRequest.getMchid()));
    }
    requestPath += queryParameter.getQueryStr();
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.GET)
            .url(requestPath)
            .headers(headers)
            .build();
    HttpResponse<GetCouponNotifyResponse> httpResponse =
        httpClient.execute(httpRequest, GetCouponNotifyResponse.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 设置商家券事件通知地址
   *
   * @param request 请求参数
   * @return SetCouponNotifyResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public SetCouponNotifyResponse setCouponNotify(SetCouponNotifyRequest request) {
    String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/busifavor/callbacks";
    SetCouponNotifyRequest realRequest = request;
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.POST)
            .url(requestPath)
            .headers(headers)
            .body(createRequestBody(realRequest))
            .build();
    HttpResponse<SetCouponNotifyResponse> httpResponse =
        httpClient.execute(httpRequest, SetCouponNotifyResponse.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 关联订单信息
   *
   * @param request 请求参数
   * @return AssociateTradeInfoResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public AssociateTradeInfoResponse associateTradeInfo(AssociateTradeInfoRequest request) {
    String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/busifavor/coupons/associate";
    AssociateTradeInfoRequest realRequest = request;
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.POST)
            .url(requestPath)
            .headers(headers)
            .body(createRequestBody(realRequest))
            .build();
    HttpResponse<AssociateTradeInfoResponse> httpResponse =
        httpClient.execute(httpRequest, AssociateTradeInfoResponse.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 使券失效
   *
   * @param request 请求参数
   * @return DeactivateCouponResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public DeactivateCouponResponse deactivateCoupon(DeactivateCouponRequest request) {
    String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/busifavor/coupons/deactivate";
    DeactivateCouponRequest realRequest = request;
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.POST)
            .url(requestPath)
            .headers(headers)
            .body(createRequestBody(realRequest))
            .build();
    HttpResponse<DeactivateCouponResponse> httpResponse =
        httpClient.execute(httpRequest, DeactivateCouponResponse.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 取消关联订单信息
   *
   * @param request 请求参数
   * @return DisassociateTradeInfoResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public DisassociateTradeInfoResponse disassociateTradeInfo(DisassociateTradeInfoRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/busifavor/coupons/disassociate";
    DisassociateTradeInfoRequest realRequest = request;
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.POST)
            .url(requestPath)
            .headers(headers)
            .body(createRequestBody(realRequest))
            .build();
    HttpResponse<DisassociateTradeInfoResponse> httpResponse =
        httpClient.execute(httpRequest, DisassociateTradeInfoResponse.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 根据过滤条件查询用户的券
   *
   * @param request 请求参数
   * @return CouponListResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public CouponListResponse listCouponsByFilter(ListCouponsByFilterRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/busifavor/users/{openid}/coupons";

    ListCouponsByFilterRequest realRequest = request;
    // 添加 path param
    requestPath = requestPath.replace("{" + "openid" + "}", urlEncode(realRequest.getOpenid()));

    // 添加 query param
    QueryParameter queryParameter = new QueryParameter();
    if (realRequest.getAppid() != null) {
      queryParameter.add("appid", urlEncode(realRequest.getAppid()));
    }
    if (realRequest.getStockId() != null) {
      queryParameter.add("stock_id", urlEncode(realRequest.getStockId()));
    }
    if (realRequest.getCreatorMerchant() != null) {
      queryParameter.add("creator_merchant", urlEncode(realRequest.getCreatorMerchant()));
    }
    if (realRequest.getBelongMerchant() != null) {
      queryParameter.add("belong_merchant", urlEncode(realRequest.getBelongMerchant()));
    }
    if (realRequest.getSenderMerchant() != null) {
      queryParameter.add("sender_merchant", urlEncode(realRequest.getSenderMerchant()));
    }
    if (realRequest.getOffset() != null) {
      queryParameter.add("offset", urlEncode(realRequest.getOffset().toString()));
    }
    if (realRequest.getLimit() != null) {
      queryParameter.add("limit", urlEncode(realRequest.getLimit().toString()));
    }
    if (realRequest.getCouponState() != null) {
      queryParameter.add("coupon_state", urlEncode(realRequest.getCouponState().toString()));
    }
    requestPath += queryParameter.getQueryStr();
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.GET)
            .url(requestPath)
            .headers(headers)
            .build();
    HttpResponse<CouponListResponse> httpResponse =
        httpClient.execute(httpRequest, CouponListResponse.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 查询用户券详情
   *
   * @param request 请求参数
   * @return CouponEntity
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public CouponEntity queryCoupon(QueryCouponRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/busifavor/users/{openid}/coupons/{coupon_code}/appids/{appid}";

    QueryCouponRequest realRequest = request;
    // 添加 path param
    requestPath =
        requestPath.replace("{" + "coupon_code" + "}", urlEncode(realRequest.getCouponCode()));

    requestPath = requestPath.replace("{" + "appid" + "}", urlEncode(realRequest.getAppid()));

    requestPath = requestPath.replace("{" + "openid" + "}", urlEncode(realRequest.getOpenid()));

    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.GET)
            .url(requestPath)
            .headers(headers)
            .build();
    HttpResponse<CouponEntity> httpResponse = httpClient.execute(httpRequest, CouponEntity.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 申请退券
   *
   * @param request 请求参数
   * @return ReturnCouponResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public ReturnCouponResponse returnCoupon(ReturnCouponRequest request) {
    String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/busifavor/coupons/return";
    ReturnCouponRequest realRequest = request;
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.POST)
            .url(requestPath)
            .headers(headers)
            .body(createRequestBody(realRequest))
            .build();
    HttpResponse<ReturnCouponResponse> httpResponse =
        httpClient.execute(httpRequest, ReturnCouponResponse.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 向用户发券
   *
   * @param request 请求参数
   * @return SendCouponResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public SendCouponResponse sendCoupon(SendCouponRequest request) {
    String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/busifavor/coupons/send";
    SendCouponRequest realRequest = request;
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.POST)
            .url(requestPath)
            .headers(headers)
            .body(createRequestBody(realRequest))
            .build();
    HttpResponse<SendCouponResponse> httpResponse =
        httpClient.execute(httpRequest, SendCouponResponse.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 发放政府消费卡
   *
   * @param request 请求参数
   * @return CouponSendGovCardResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public CouponSendGovCardResponse sendGovCard(SendGovCardRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/busifavor/coupons/{card_id}/send";

    SendGovCardRequest realRequest = request;
    // 添加 path param
    requestPath = requestPath.replace("{" + "card_id" + "}", urlEncode(realRequest.getCardId()));

    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.POST)
            .url(requestPath)
            .headers(headers)
            .body(createRequestBody(realRequest))
            .build();
    HttpResponse<CouponSendGovCardResponse> httpResponse =
        httpClient.execute(httpRequest, CouponSendGovCardResponse.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 核销用户的券
   *
   * @param request 请求参数
   * @return UseCouponResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public UseCouponResponse useCoupon(UseCouponRequest request) {
    String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/busifavor/coupons/use";
    UseCouponRequest realRequest = request;
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.POST)
            .url(requestPath)
            .headers(headers)
            .body(createRequestBody(realRequest))
            .build();
    HttpResponse<UseCouponResponse> httpResponse =
        httpClient.execute(httpRequest, UseCouponResponse.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 查询商家券营销补差付款单详情
   *
   * @param request 请求参数
   * @return SubsidyPayReceipt
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public SubsidyPayReceipt payReceiptInfo(PayReceiptInfoRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/busifavor/subsidy/pay-receipts/{subsidy_receipt_id}";

    PayReceiptInfoRequest realRequest = request;
    // 添加 path param
    requestPath =
        requestPath.replace(
            "{" + "subsidy_receipt_id" + "}", urlEncode(realRequest.getSubsidyReceiptId()));

    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.GET)
            .url(requestPath)
            .headers(headers)
            .build();
    HttpResponse<SubsidyPayReceipt> httpResponse =
        httpClient.execute(httpRequest, SubsidyPayReceipt.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 查询商家券营销补差付款单列表
   *
   * @param request 请求参数
   * @return SubsidyPayReceiptListResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public SubsidyPayReceiptListResponse payReceiptList(PayReceiptListRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/busifavor/subsidy/pay-receipts";

    PayReceiptListRequest realRequest = request;
    // 添加 query param
    QueryParameter queryParameter = new QueryParameter();
    if (realRequest.getStockId() != null) {
      queryParameter.add("stock_id", urlEncode(realRequest.getStockId()));
    }
    if (realRequest.getCouponCode() != null) {
      queryParameter.add("coupon_code", urlEncode(realRequest.getCouponCode()));
    }
    if (realRequest.getOutSubsidyNo() != null) {
      queryParameter.add("out_subsidy_no", urlEncode(realRequest.getOutSubsidyNo()));
    }
    requestPath += queryParameter.getQueryStr();
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.GET)
            .url(requestPath)
            .headers(headers)
            .build();
    HttpResponse<SubsidyPayReceiptListResponse> httpResponse =
        httpClient.execute(httpRequest, SubsidyPayReceiptListResponse.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 查询商家券营销补差回退单详情
   *
   * @param request 请求参数
   * @return SubsidyReturnReceipt
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public SubsidyReturnReceipt returnReceiptInfo(ReturnReceiptInfoRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/busifavor/subsidy/return-receipts/{subsidy_return_receipt_id}";

    ReturnReceiptInfoRequest realRequest = request;
    // 添加 path param
    requestPath =
        requestPath.replace(
            "{" + "subsidy_return_receipt_id" + "}",
            urlEncode(realRequest.getSubsidyReturnReceiptId()));

    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.GET)
            .url(requestPath)
            .headers(headers)
            .build();
    HttpResponse<SubsidyReturnReceipt> httpResponse =
        httpClient.execute(httpRequest, SubsidyReturnReceipt.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 商家券营销补差付款
   *
   * @param request 请求参数
   * @return SubsidyPayReceipt
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public SubsidyPayReceipt subsidyPay(SubsidyPayRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/busifavor/subsidy/pay-receipts";
    SubsidyPayRequest realRequest = request;
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.POST)
            .url(requestPath)
            .headers(headers)
            .body(createRequestBody(realRequest))
            .build();
    HttpResponse<SubsidyPayReceipt> httpResponse =
        httpClient.execute(httpRequest, SubsidyPayReceipt.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 商家券营销补差回退
   *
   * @param request 请求参数
   * @return SubsidyReturnReceipt
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public SubsidyReturnReceipt subsidyReturn(SubsidyReturnRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/busifavor/subsidy/return-receipts";
    SubsidyReturnRequest realRequest = request;
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.POST)
            .url(requestPath)
            .headers(headers)
            .body(createRequestBody(realRequest))
            .build();
    HttpResponse<SubsidyReturnReceipt> httpResponse =
        httpClient.execute(httpRequest, SubsidyReturnReceipt.class);
    return httpResponse.getServiceResponse();
  }

  private RequestBody createRequestBody(Object request) {
    return new JsonRequestBody.Builder().body(toJson(request)).build();
  }
}
