// Copyright 2021 Tencent Inc. All rights reserved.
//
// 电商退款API
//
// 境内电商退款功能相关API文档
//
// API version: 1.1.8

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.ecommercerefund.model;

import static com.wechat.pay.java.core.util.StringUtil.toIndentedString;

import com.google.gson.annotations.SerializedName;
import java.util.List;

/** Refund4Create */
public class Refund4Create {
  /** 微信支付退款订单号 说明：微信支付退款订单号 */
  @SerializedName("refund_id")
  private String refundId;

  /** 商户退款单号 说明：商户系统内部的退款单号，商户系统内部唯一，只能是数字、大小写字母_-|*@ ，同一退款单号多次请求只退一笔。 */
  @SerializedName("out_refund_no")
  private String outRefundNo;

  /**
   * 退款创建时间
   * 说明：退款受理时间，遵循rfc3339标准格式，格式为YYYY-MM-DDTHH:mm:ss+TIMEZONE，YYYY-MM-DD表示年月日，T出现在字符串中，表示time元素的开头，HH:mm:ss表示时分秒，TIMEZONE表示时区（+08:00表示东八区时间，领先UTC
   * 8小时，即北京时间）。例如：2015-05-20T13:29:35+08:00表示，北京时间2015年5月20日13点29分35秒。
   */
  @SerializedName("create_time")
  private String createTime;

  /** 退款金额 说明：订单退款金额信息 */
  @SerializedName("amount")
  private RefundAmount amount;

  /** 优惠退款详情 说明：优惠退款功能信息 */
  @SerializedName("promotion_detail")
  private List<PromotionDetail> promotionDetail;

  /**
   * 退款出资商户 说明：REFUND_SOURCE_PARTNER_ADVANCE : 电商平台垫付 REFUND_SOURCE_SUB_MERCHANT : 二级商户，默认值
   * 注意：申请退款时可能会出现暂未扣除退款资金的情况，此时不返回本字段，需查单确认。
   */
  @SerializedName("refund_account")
  private String refundAccount;

  public String getRefundId() {
    return refundId;
  }

  public void setRefundId(String refundId) {
    this.refundId = refundId;
  }

  public String getOutRefundNo() {
    return outRefundNo;
  }

  public void setOutRefundNo(String outRefundNo) {
    this.outRefundNo = outRefundNo;
  }

  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  public RefundAmount getAmount() {
    return amount;
  }

  public void setAmount(RefundAmount amount) {
    this.amount = amount;
  }

  public List<PromotionDetail> getPromotionDetail() {
    return promotionDetail;
  }

  public void setPromotionDetail(List<PromotionDetail> promotionDetail) {
    this.promotionDetail = promotionDetail;
  }

  public String getRefundAccount() {
    return refundAccount;
  }

  public void setRefundAccount(String refundAccount) {
    this.refundAccount = refundAccount;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Refund4Create {\n");
    sb.append("    refundId: ").append(toIndentedString(refundId)).append("\n");
    sb.append("    outRefundNo: ").append(toIndentedString(outRefundNo)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    promotionDetail: ").append(toIndentedString(promotionDetail)).append("\n");
    sb.append("    refundAccount: ").append(toIndentedString(refundAccount)).append("\n");
    sb.append("}");
    return sb.toString();
  }
}
