// Copyright 2021 Tencent Inc. All rights reserved.
//
// 连锁加盟供应链分账API
//
// No description provided (generated by Openapi Generator
// https://github.com/openapitools/openapi-generator)
//
// API version: 1.0.12

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.brandprofitsharing.model;

import static com.wechat.pay.java.core.util.StringUtil.toIndentedString;

import com.google.gson.annotations.SerializedName;
import com.wechat.pay.java.core.cipher.Encryption;
import java.util.function.UnaryOperator;

/** ReceiverEntity */
public class ReceiverEntity {
  /**
   * 分账接收方类型 说明：枚举值： 1. MERCHANT_ID：商户ID 2. PERSONAL_OPENID：个人OpenID（由父商户AppID转换得到） 3.
   * PERSONAL_SUB_OPENID：个人OpenID（由品牌主的AppID转换得到）
   */
  @SerializedName("type")
  private String type;

  /**
   * 分账接收方账号 说明：分账接收方账号 1. 分账接收方类型为MERCHANT_ID时，分账接收方账号为商户号（mch_id或者sub_mch_id） 2.
   * 分账接收方类型为PERSONAL_OPENID时，分账接收方账号为个人OpenID（由服务商的AppID转换得到） 3.
   * 分账接收方类型为PERSONAL_SUB_OPENID时，分账接收方账号为个人OpenID（由品牌主的AppID转换得到）
   */
  @SerializedName("account")
  private String account;

  /** 分账金额 说明：分账金额，单位为分，只能为整数，不能超过原订单支付金额及最大分账比例金额 */
  @SerializedName("amount")
  private Long amount;

  /** 分账描述 说明：分账的原因描述，分账账单中需要体现 */
  @SerializedName("description")
  private String description;

  /**
   * 分账个人接收方姓名 说明：可选项，在接收方类型为个人的时可选填，若有值，会检查与 name 是否实名匹配，不匹配会拒绝分账请求
   * 1、分账接收方类型是PERSONAL_OPENID时，是个人姓名的密文（选传，传则校验） 此字段的加密的方式为： 2、使用微信支付平台证书中的公钥 3、使用RSAES-OAEP算法进行加密
   * 4、将请求中HTTP头部的Wechatpay-Serial设置为证书序列号 字段加密: 使用APIv3定义的方式加密
   */
  @Encryption
  @SerializedName("name")
  private String name;

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getAccount() {
    return account;
  }

  public void setAccount(String account) {
    this.account = account;
  }

  public Long getAmount() {
    return amount;
  }

  public void setAmount(Long amount) {
    this.amount = amount;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ReceiverEntity {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    account: ").append(toIndentedString(account)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  public ReceiverEntity cloneWithCipher(UnaryOperator<String> s) {
    ReceiverEntity copy = new ReceiverEntity();
    copy.type = type;
    copy.account = account;
    copy.amount = amount;
    copy.description = description;
    if (name != null && !name.isEmpty()) {
      copy.name = s.apply(name);
    }
    return copy;
  }
}
