/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.service.merchantexclusivecoupon;

import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.http.DefaultHttpClientBuilder;
import com.wechat.pay.java.core.http.HostName;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.http.HttpHeaders;
import com.wechat.pay.java.core.http.HttpMethod;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.http.HttpResponse;
import com.wechat.pay.java.core.http.JsonRequestBody;
import com.wechat.pay.java.core.http.MediaType;
import com.wechat.pay.java.core.http.QueryParameter;
import com.wechat.pay.java.core.http.RequestBody;
import com.wechat.pay.java.core.http.UrlEncoder;
import com.wechat.pay.java.core.util.GsonUtil;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.AssociateTradeInfoRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.AssociateTradeInfoResponse;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.CouponCodeInfoRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.CouponCodeInfoResponse;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.CouponCodeListResponse;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.CouponEntity;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.CouponListResponse;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.CouponSendGovCardResponse;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.CreateBusiFavorStockRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.CreateBusiFavorStockResponse;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.DeactivateCouponRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.DeactivateCouponResponse;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.DeleteCouponCodeRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.DeleteCouponCodeResponse;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.DisassociateTradeInfoRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.DisassociateTradeInfoResponse;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.GetCouponNotifyRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.GetCouponNotifyResponse;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.ListCouponsByFilterRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.ModifyBudgetRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.ModifyBudgetResponse;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.ModifyStockInfoRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.PayReceiptInfoRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.PayReceiptListRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.QueryCouponCodeListRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.QueryCouponRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.QueryStockRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.ReturnCouponRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.ReturnCouponResponse;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.ReturnReceiptInfoRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.SendCouponRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.SendCouponResponse;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.SendGovCardRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.SetCouponNotifyRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.SetCouponNotifyResponse;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.StockGetResponse;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.SubsidyPayReceipt;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.SubsidyPayReceiptListResponse;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.SubsidyPayRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.SubsidyReturnReceipt;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.SubsidyReturnRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.UploadCouponCodeRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.UploadCouponCodeResponse;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.UseCouponRequest;
import com.wechat.pay.java.service.merchantexclusivecoupon.model.UseCouponResponse;
import java.util.Objects;

public class MerchantExclusiveCouponService {
    private final HttpClient httpClient;
    private final HostName hostName;

    private MerchantExclusiveCouponService(HttpClient httpClient, HostName hostName) {
        this.httpClient = Objects.requireNonNull(httpClient);
        this.hostName = hostName;
    }

    public CouponCodeInfoResponse couponCodeInfo(CouponCodeInfoRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/busifavor/stocks/{stock_id}/couponcodes/{coupon_code}";
        CouponCodeInfoRequest realRequest = request;
        requestPath = requestPath.replace("{stock_id}", UrlEncoder.urlEncode((String)realRequest.getStockId()));
        requestPath = requestPath.replace("{coupon_code}", UrlEncoder.urlEncode((String)realRequest.getCouponCode()));
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getAppid() != null) {
            queryParameter.add("appid", (Object)UrlEncoder.urlEncode((String)realRequest.getAppid()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, CouponCodeInfoResponse.class);
        return (CouponCodeInfoResponse)httpResponse.getServiceResponse();
    }

    public CreateBusiFavorStockResponse createBusifavorStock(CreateBusiFavorStockRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/busifavor/stocks";
        CreateBusiFavorStockRequest realRequest = request;
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, CreateBusiFavorStockResponse.class);
        return (CreateBusiFavorStockResponse)httpResponse.getServiceResponse();
    }

    public DeleteCouponCodeResponse deleteCouponCode(DeleteCouponCodeRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/busifavor/stocks/{stock_id}/couponcodes/{coupon_code}";
        DeleteCouponCodeRequest realRequest = request;
        requestPath = requestPath.replace("{stock_id}", UrlEncoder.urlEncode((String)realRequest.getStockId()));
        requestPath = requestPath.replace("{coupon_code}", UrlEncoder.urlEncode((String)realRequest.getCouponCode()));
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getDeleteRequestNo() != null) {
            queryParameter.add("delete_request_no", (Object)UrlEncoder.urlEncode((String)realRequest.getDeleteRequestNo()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.DELETE).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, DeleteCouponCodeResponse.class);
        return (DeleteCouponCodeResponse)httpResponse.getServiceResponse();
    }

    public ModifyBudgetResponse modifyBudget(ModifyBudgetRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/busifavor/stocks/{stock_id}/budget";
        ModifyBudgetRequest realRequest = request;
        requestPath = requestPath.replace("{stock_id}", UrlEncoder.urlEncode((String)realRequest.getStockId()));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.PATCH).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, ModifyBudgetResponse.class);
        return (ModifyBudgetResponse)httpResponse.getServiceResponse();
    }

    public void modifyStockInfo(ModifyStockInfoRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/busifavor/stocks/{stock_id}";
        ModifyStockInfoRequest realRequest = request;
        requestPath = requestPath.replace("{stock_id}", UrlEncoder.urlEncode((String)realRequest.getStockId()));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.PATCH).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        this.httpClient.execute(httpRequest, null);
    }

    public CouponCodeListResponse queryCouponCodeList(QueryCouponCodeListRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/busifavor/stocks/{stock_id}/couponcodes";
        QueryCouponCodeListRequest realRequest = request;
        requestPath = requestPath.replace("{stock_id}", UrlEncoder.urlEncode((String)realRequest.getStockId()));
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getLimit() != null) {
            queryParameter.add("limit", (Object)UrlEncoder.urlEncode((String)realRequest.getLimit().toString()));
        }
        if (realRequest.getOffset() != null) {
            queryParameter.add("offset", (Object)UrlEncoder.urlEncode((String)realRequest.getOffset().toString()));
        }
        if (realRequest.getAppid() != null) {
            queryParameter.add("appid", (Object)UrlEncoder.urlEncode((String)realRequest.getAppid()));
        }
        if (realRequest.getStatus() != null) {
            queryParameter.add("status", (Object)UrlEncoder.urlEncode((String)realRequest.getStatus().toString()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, CouponCodeListResponse.class);
        return (CouponCodeListResponse)httpResponse.getServiceResponse();
    }

    public StockGetResponse queryStock(QueryStockRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/busifavor/stocks/{stock_id}";
        QueryStockRequest realRequest = request;
        requestPath = requestPath.replace("{stock_id}", UrlEncoder.urlEncode((String)realRequest.getStockId()));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, StockGetResponse.class);
        return (StockGetResponse)httpResponse.getServiceResponse();
    }

    public UploadCouponCodeResponse uploadCouponCode(UploadCouponCodeRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/busifavor/stocks/{stock_id}/couponcodes";
        UploadCouponCodeRequest realRequest = request;
        requestPath = requestPath.replace("{stock_id}", UrlEncoder.urlEncode((String)realRequest.getStockId()));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, UploadCouponCodeResponse.class);
        return (UploadCouponCodeResponse)httpResponse.getServiceResponse();
    }

    public GetCouponNotifyResponse getCouponNotify(GetCouponNotifyRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/busifavor/callbacks";
        GetCouponNotifyRequest realRequest = request;
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getMchid() != null) {
            queryParameter.add("mchid", (Object)UrlEncoder.urlEncode((String)realRequest.getMchid()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, GetCouponNotifyResponse.class);
        return (GetCouponNotifyResponse)httpResponse.getServiceResponse();
    }

    public SetCouponNotifyResponse setCouponNotify(SetCouponNotifyRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/busifavor/callbacks";
        SetCouponNotifyRequest realRequest = request;
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, SetCouponNotifyResponse.class);
        return (SetCouponNotifyResponse)httpResponse.getServiceResponse();
    }

    public AssociateTradeInfoResponse associateTradeInfo(AssociateTradeInfoRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/busifavor/coupons/associate";
        AssociateTradeInfoRequest realRequest = request;
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, AssociateTradeInfoResponse.class);
        return (AssociateTradeInfoResponse)httpResponse.getServiceResponse();
    }

    public DeactivateCouponResponse deactivateCoupon(DeactivateCouponRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/busifavor/coupons/deactivate";
        DeactivateCouponRequest realRequest = request;
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, DeactivateCouponResponse.class);
        return (DeactivateCouponResponse)httpResponse.getServiceResponse();
    }

    public DisassociateTradeInfoResponse disassociateTradeInfo(DisassociateTradeInfoRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/busifavor/coupons/disassociate";
        DisassociateTradeInfoRequest realRequest = request;
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, DisassociateTradeInfoResponse.class);
        return (DisassociateTradeInfoResponse)httpResponse.getServiceResponse();
    }

    public CouponListResponse listCouponsByFilter(ListCouponsByFilterRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/busifavor/users/{openid}/coupons";
        ListCouponsByFilterRequest realRequest = request;
        requestPath = requestPath.replace("{openid}", UrlEncoder.urlEncode((String)realRequest.getOpenid()));
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getAppid() != null) {
            queryParameter.add("appid", (Object)UrlEncoder.urlEncode((String)realRequest.getAppid()));
        }
        if (realRequest.getStockId() != null) {
            queryParameter.add("stock_id", (Object)UrlEncoder.urlEncode((String)realRequest.getStockId()));
        }
        if (realRequest.getCreatorMerchant() != null) {
            queryParameter.add("creator_merchant", (Object)UrlEncoder.urlEncode((String)realRequest.getCreatorMerchant()));
        }
        if (realRequest.getBelongMerchant() != null) {
            queryParameter.add("belong_merchant", (Object)UrlEncoder.urlEncode((String)realRequest.getBelongMerchant()));
        }
        if (realRequest.getSenderMerchant() != null) {
            queryParameter.add("sender_merchant", (Object)UrlEncoder.urlEncode((String)realRequest.getSenderMerchant()));
        }
        if (realRequest.getOffset() != null) {
            queryParameter.add("offset", (Object)UrlEncoder.urlEncode((String)realRequest.getOffset().toString()));
        }
        if (realRequest.getLimit() != null) {
            queryParameter.add("limit", (Object)UrlEncoder.urlEncode((String)realRequest.getLimit().toString()));
        }
        if (realRequest.getCouponState() != null) {
            queryParameter.add("coupon_state", (Object)UrlEncoder.urlEncode((String)realRequest.getCouponState().toString()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, CouponListResponse.class);
        return (CouponListResponse)httpResponse.getServiceResponse();
    }

    public CouponEntity queryCoupon(QueryCouponRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/busifavor/users/{openid}/coupons/{coupon_code}/appids/{appid}";
        QueryCouponRequest realRequest = request;
        requestPath = requestPath.replace("{coupon_code}", UrlEncoder.urlEncode((String)realRequest.getCouponCode()));
        requestPath = requestPath.replace("{appid}", UrlEncoder.urlEncode((String)realRequest.getAppid()));
        requestPath = requestPath.replace("{openid}", UrlEncoder.urlEncode((String)realRequest.getOpenid()));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, CouponEntity.class);
        return (CouponEntity)httpResponse.getServiceResponse();
    }

    public ReturnCouponResponse returnCoupon(ReturnCouponRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/busifavor/coupons/return";
        ReturnCouponRequest realRequest = request;
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, ReturnCouponResponse.class);
        return (ReturnCouponResponse)httpResponse.getServiceResponse();
    }

    public SendCouponResponse sendCoupon(SendCouponRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/busifavor/coupons/send";
        SendCouponRequest realRequest = request;
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, SendCouponResponse.class);
        return (SendCouponResponse)httpResponse.getServiceResponse();
    }

    public CouponSendGovCardResponse sendGovCard(SendGovCardRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/busifavor/coupons/{card_id}/send";
        SendGovCardRequest realRequest = request;
        requestPath = requestPath.replace("{card_id}", UrlEncoder.urlEncode((String)realRequest.getCardId()));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, CouponSendGovCardResponse.class);
        return (CouponSendGovCardResponse)httpResponse.getServiceResponse();
    }

    public UseCouponResponse useCoupon(UseCouponRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/busifavor/coupons/use";
        UseCouponRequest realRequest = request;
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, UseCouponResponse.class);
        return (UseCouponResponse)httpResponse.getServiceResponse();
    }

    public SubsidyPayReceipt payReceiptInfo(PayReceiptInfoRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/busifavor/subsidy/pay-receipts/{subsidy_receipt_id}";
        PayReceiptInfoRequest realRequest = request;
        requestPath = requestPath.replace("{subsidy_receipt_id}", UrlEncoder.urlEncode((String)realRequest.getSubsidyReceiptId()));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, SubsidyPayReceipt.class);
        return (SubsidyPayReceipt)httpResponse.getServiceResponse();
    }

    public SubsidyPayReceiptListResponse payReceiptList(PayReceiptListRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/busifavor/subsidy/pay-receipts";
        PayReceiptListRequest realRequest = request;
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getStockId() != null) {
            queryParameter.add("stock_id", (Object)UrlEncoder.urlEncode((String)realRequest.getStockId()));
        }
        if (realRequest.getCouponCode() != null) {
            queryParameter.add("coupon_code", (Object)UrlEncoder.urlEncode((String)realRequest.getCouponCode()));
        }
        if (realRequest.getOutSubsidyNo() != null) {
            queryParameter.add("out_subsidy_no", (Object)UrlEncoder.urlEncode((String)realRequest.getOutSubsidyNo()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, SubsidyPayReceiptListResponse.class);
        return (SubsidyPayReceiptListResponse)httpResponse.getServiceResponse();
    }

    public SubsidyReturnReceipt returnReceiptInfo(ReturnReceiptInfoRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/busifavor/subsidy/return-receipts/{subsidy_return_receipt_id}";
        ReturnReceiptInfoRequest realRequest = request;
        requestPath = requestPath.replace("{subsidy_return_receipt_id}", UrlEncoder.urlEncode((String)realRequest.getSubsidyReturnReceiptId()));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, SubsidyReturnReceipt.class);
        return (SubsidyReturnReceipt)httpResponse.getServiceResponse();
    }

    public SubsidyPayReceipt subsidyPay(SubsidyPayRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/busifavor/subsidy/pay-receipts";
        SubsidyPayRequest realRequest = request;
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, SubsidyPayReceipt.class);
        return (SubsidyPayReceipt)httpResponse.getServiceResponse();
    }

    public SubsidyReturnReceipt subsidyReturn(SubsidyReturnRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/busifavor/subsidy/return-receipts";
        SubsidyReturnRequest realRequest = request;
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, SubsidyReturnReceipt.class);
        return (SubsidyReturnReceipt)httpResponse.getServiceResponse();
    }

    private RequestBody createRequestBody(Object request) {
        return new JsonRequestBody.Builder().body(GsonUtil.toJson((Object)request)).build();
    }

    public static class Builder {
        private HttpClient httpClient;
        private HostName hostName;

        public Builder config(Config config) {
            this.httpClient = new DefaultHttpClientBuilder().config(config).build();
            return this;
        }

        public Builder hostName(HostName hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public MerchantExclusiveCouponService build() {
            return new MerchantExclusiveCouponService(this.httpClient, this.hostName);
        }
    }
}

