// Copyright 2021 Tencent Inc. All rights reserved.
//
// 微工卡接口文档
//
// 服务商通过本API文档提供的接口，查询商户和微工卡的授权关系、生成预授权的token口令、核身预下单、核身结果的查询等。
//
// API version: 1.5.2

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.payrollcard.model;

import static com.wechat.pay.java.core.util.StringUtil.toIndentedString;

import com.google.gson.annotations.SerializedName;
import com.wechat.pay.java.core.cipher.Encryption;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;

/** CreateTransferBatchRequest */
public class CreateTransferBatchRequest {
  /** 特约商户号 说明：特约商户号 */
  @SerializedName("sub_mchid")
  private String subMchid;
  /**
   * 特约商户AppID
   * 说明：微信分配的特约商户公众账号ID，特约商户授权类型为INFORMATION_AUTHORIZATION_TYPE和INFORMATION_AND_FUND_AUTHORIZATION_TYPE时
   * 需要填写
   */
  @SerializedName("sub_appid")
  private String subAppid;
  /** 特约商户授权类型 说明：特约商户授权类型 */
  @SerializedName("authorization_type")
  private AuthType authorizationType;
  /** 商家批次单号 说明：商户系统内部的商家批次单号，在商户系统内部唯一 */
  @SerializedName("out_batch_no")
  private String outBatchNo;
  /** 批次名称 说明：该笔批量转账的名称 */
  @SerializedName("batch_name")
  private String batchName;
  /** 批次备注 说明：转账说明，UTF8编码，最多允许32个字符 */
  @SerializedName("batch_remark")
  private String batchRemark;
  /** 转账总金额 说明：转账金额单位为“分”。转账总金额必须与批次内所有明细转账金额之和保持一致，否则无法发起转账操作 */
  @SerializedName("total_amount")
  private Long totalAmount;
  /** 转账总笔数 说明：一个转账批次单最多发起三千笔转账。转账总笔数必须与批次内所有明细之和保持一致，否则无法发起转账操作 */
  @SerializedName("total_num")
  private Integer totalNum;
  /** 转账明细列表 说明：发起批量转账的明细列表，最多三千笔 */
  @Encryption
  @SerializedName("transfer_detail_list")
  private List<TransferDetailInput> transferDetailList = new ArrayList<TransferDetailInput>();
  /** 服务商的AppID 说明：微信分配的服务商商户公众账号ID，特约商户授权类型为FUND_AUTHORIZATION_TYPE时 需要填写 */
  @SerializedName("sp_appid")
  private String spAppid;
  /**
   * 用工类型
   * 说明：微工卡服务仅支持用于与商户有用工关系的用户，需明确用工类型；参考值：长期用工：LONG_TERM_EMPLOYMENT，短期用工：SHORT_TERM_EMPLOYMENT，合作关系：COOPERATION_EMPLOYMENT
   */
  @SerializedName("employment_type")
  private EmploymentType employmentType;
  /**
   * 用工场景
   * 说明：用工场景；参考值：LOGISTICS：物流；MANUFACTURING：制造业；HOTEL：酒店；CATERING：餐饮业；EVENT：活动促销；RETAIL：零售；OTHERS：其他
   */
  @SerializedName("employment_scene")
  private EmploymentScene employmentScene;
  /** 业务来源 说明：传入业务ID后必填，区分不同任务来源于哪个业务系统 */
  @SerializedName("business_type")
  private BusinessType businessType;

  public String getSubMchid() {
    return subMchid;
  }

  public void setSubMchid(String subMchid) {
    this.subMchid = subMchid;
  }

  public String getSubAppid() {
    return subAppid;
  }

  public void setSubAppid(String subAppid) {
    this.subAppid = subAppid;
  }

  public AuthType getAuthorizationType() {
    return authorizationType;
  }

  public void setAuthorizationType(AuthType authorizationType) {
    this.authorizationType = authorizationType;
  }

  public String getOutBatchNo() {
    return outBatchNo;
  }

  public void setOutBatchNo(String outBatchNo) {
    this.outBatchNo = outBatchNo;
  }

  public String getBatchName() {
    return batchName;
  }

  public void setBatchName(String batchName) {
    this.batchName = batchName;
  }

  public String getBatchRemark() {
    return batchRemark;
  }

  public void setBatchRemark(String batchRemark) {
    this.batchRemark = batchRemark;
  }

  public Long getTotalAmount() {
    return totalAmount;
  }

  public void setTotalAmount(Long totalAmount) {
    this.totalAmount = totalAmount;
  }

  public Integer getTotalNum() {
    return totalNum;
  }

  public void setTotalNum(Integer totalNum) {
    this.totalNum = totalNum;
  }

  public List<TransferDetailInput> getTransferDetailList() {
    return transferDetailList;
  }

  public void setTransferDetailList(List<TransferDetailInput> transferDetailList) {
    this.transferDetailList = transferDetailList;
  }

  public String getSpAppid() {
    return spAppid;
  }

  public void setSpAppid(String spAppid) {
    this.spAppid = spAppid;
  }

  public EmploymentType getEmploymentType() {
    return employmentType;
  }

  public void setEmploymentType(EmploymentType employmentType) {
    this.employmentType = employmentType;
  }

  public EmploymentScene getEmploymentScene() {
    return employmentScene;
  }

  public void setEmploymentScene(EmploymentScene employmentScene) {
    this.employmentScene = employmentScene;
  }

  public BusinessType getBusinessType() {
    return businessType;
  }

  public void setBusinessType(BusinessType businessType) {
    this.businessType = businessType;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateTransferBatchRequest {\n");
    sb.append("    subMchid: ").append(toIndentedString(subMchid)).append("\n");
    sb.append("    subAppid: ").append(toIndentedString(subAppid)).append("\n");
    sb.append("    authorizationType: ").append(toIndentedString(authorizationType)).append("\n");
    sb.append("    outBatchNo: ").append(toIndentedString(outBatchNo)).append("\n");
    sb.append("    batchName: ").append(toIndentedString(batchName)).append("\n");
    sb.append("    batchRemark: ").append(toIndentedString(batchRemark)).append("\n");
    sb.append("    totalAmount: ").append(toIndentedString(totalAmount)).append("\n");
    sb.append("    totalNum: ").append(toIndentedString(totalNum)).append("\n");
    sb.append("    transferDetailList: ").append(toIndentedString(transferDetailList)).append("\n");
    sb.append("    spAppid: ").append(toIndentedString(spAppid)).append("\n");
    sb.append("    employmentType: ").append(toIndentedString(employmentType)).append("\n");
    sb.append("    employmentScene: ").append(toIndentedString(employmentScene)).append("\n");
    sb.append("    businessType: ").append(toIndentedString(businessType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  public CreateTransferBatchRequest cloneWithCipher(UnaryOperator<String> s) {
    CreateTransferBatchRequest copy = new CreateTransferBatchRequest();
    copy.subMchid = subMchid;
    copy.subAppid = subAppid;
    copy.authorizationType = authorizationType;
    copy.outBatchNo = outBatchNo;
    copy.batchName = batchName;
    copy.batchRemark = batchRemark;
    copy.totalAmount = totalAmount;
    copy.totalNum = totalNum;
    if (transferDetailList != null && transferDetailList.size() != 0) {
      // arr
      copy.transferDetailList = new ArrayList<>();
      for (TransferDetailInput val : transferDetailList) {
        if (val != null) {
          copy.transferDetailList.add(val.cloneWithCipher(s));
        }
      }
    }
    copy.spAppid = spAppid;
    copy.employmentType = employmentType;
    copy.employmentScene = employmentScene;
    copy.businessType = businessType;
    return copy;
  }
}
