/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.access.mybatis;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snaker.engine.access.jdbc.JdbcHelper;
import org.snaker.engine.access.mybatis.MybatisTransactionFactory;
import org.snaker.engine.access.transaction.TransactionObjectHolder;
import org.snaker.engine.helper.ConfigHelper;

public abstract class MybatisHelper {
    private static final Logger log = LoggerFactory.getLogger(MybatisHelper.class);
    private static final String SCAN_PACKAGE = "org.snaker.engine.entity";
    private static SqlSessionFactory sqlSessionFactory = null;
    private static final String[] resources = new String[]{"mapper/process.xml", "mapper/order.xml", "mapper/task.xml", "mapper/task-actor.xml", "mapper/hist-order.xml", "mapper/hist-task.xml", "mapper/hist-task-actor.xml", "mapper/query.xml", "mapper/hist-query.xml"};

    public static void initialize() {
        try {
            InputStream in = Resources.getResourceAsStream((String)"mybatis.cfg.xml");
            sqlSessionFactory = new SqlSessionFactoryBuilder().build(in, ConfigHelper.getProperties());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(DataSource ds) {
        MybatisTransactionFactory transactionFactory = new MybatisTransactionFactory();
        Environment environment = new Environment("snaker", (TransactionFactory)transactionFactory, ds);
        Configuration configuration = new Configuration(environment);
        configuration.getTypeAliasRegistry().registerAliases(SCAN_PACKAGE, Object.class);
        if (log.isInfoEnabled()) {
            Map typeAliases = configuration.getTypeAliasRegistry().getTypeAliases();
            for (Map.Entry entry : typeAliases.entrySet()) {
                log.info("Scanned class:[name=" + (String)entry.getKey() + ",class=" + ((Class)entry.getValue()).getName() + "]");
            }
        }
        try {
            for (String resource : resources) {
                InputStream in = Resources.getResourceAsStream((String)resource);
                XMLMapperBuilder xmlMapperBuilder = new XMLMapperBuilder(in, configuration, resource, configuration.getSqlFragments());
                xmlMapperBuilder.parse();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ErrorContext.instance().reset();
        }
        sqlSessionFactory = new SqlSessionFactoryBuilder().build(configuration);
    }

    public static Connection getConnection() throws SQLException {
        if (sqlSessionFactory != null) {
            log.info("found sqlSessionFactory:" + sqlSessionFactory);
        } else {
            log.info("don't found available sqlSessionFactory");
            sqlSessionFactory = MybatisHelper.getSqlSessionFactory();
        }
        DataSource dataSource = sqlSessionFactory.getConfiguration().getEnvironment().getDataSource();
        return JdbcHelper.getConnection((DataSource)dataSource);
    }

    public static SqlSession getSession(SqlSessionFactory sqlSessionFactory) {
        SqlSession session = (SqlSession)TransactionObjectHolder.get();
        if (session != null) {
            return session;
        }
        if (sqlSessionFactory != null) {
            log.info("found sqlSessionFactory:" + sqlSessionFactory);
            return sqlSessionFactory.openSession();
        }
        log.info("don't found available sqlSessionFactory");
        return MybatisHelper.getSqlSessionFactory().openSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SqlSessionFactory getSqlSessionFactory() {
        if (sqlSessionFactory != null) return sqlSessionFactory;
        Class<MybatisHelper> clazz = MybatisHelper.class;
        synchronized (MybatisHelper.class) {
            if (sqlSessionFactory != null) return sqlSessionFactory;
            MybatisHelper.initialize();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sqlSessionFactory;
        }
    }
}

