/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.client.http;

import java.util.Base64;
import java.util.Optional;
import java.util.function.Consumer;

public class HttpConfig {
    public final String pushUrl;
    public final long connectionTimeoutMs;
    public final long requestTimeoutMs;
    public final Optional<String> tenantId;
    public final String contentType;
    public final Optional<String> username;
    public final Optional<String> password;
    public final ClientSpecificConfig clientSpecific;

    public final Optional<String> basicAuthToken() {
        return this.username.flatMap(u -> this.password.flatMap(p -> Optional.of(Base64.getEncoder().encodeToString((u + ":" + p).getBytes()))));
    }

    public final ApacheHttpConfig apache() {
        return (ApacheHttpConfig)this.clientSpecific;
    }

    public final JavaHttpConfig java() {
        return (JavaHttpConfig)this.clientSpecific;
    }

    public HttpConfig(String pushUrl, long connectionTimeoutMs, long requestTimeoutMs, Optional<String> tenantId, String contentType, Optional<String> username, Optional<String> password, ClientSpecificConfig clientSpecific) {
        this.pushUrl = pushUrl;
        this.connectionTimeoutMs = connectionTimeoutMs;
        this.requestTimeoutMs = requestTimeoutMs;
        this.tenantId = tenantId;
        this.contentType = contentType;
        this.username = username;
        this.password = password;
        this.clientSpecific = clientSpecific;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class JavaHttpConfig
    implements ClientSpecificConfig {
        public final long innerThreadsExpirationMs;

        public JavaHttpConfig(long innerThreadsExpirationMs) {
            this.innerThreadsExpirationMs = innerThreadsExpirationMs;
        }
    }

    public static class ApacheHttpConfig
    implements ClientSpecificConfig {
        public final int maxConnections;
        public final long connectionKeepAliveMs;

        public ApacheHttpConfig(int maxConnections, long connectionKeepAliveMs) {
            this.maxConnections = maxConnections;
            this.connectionKeepAliveMs = connectionKeepAliveMs;
        }
    }

    public static interface ClientSpecificConfig {
    }

    public static class Builder {
        public static final ApacheHttpConfig apache = new ApacheHttpConfig(1, 120000L);
        public static final JavaHttpConfig java = new JavaHttpConfig(300000L);
        private String pushUrl = "http://localhost:3100/loki/api/v1/push";
        private long connectionTimeoutMs = 30000L;
        private long requestTimeoutMs = 5000L;
        private Optional<String> tenantId = Optional.empty();
        private Optional<String> username = Optional.empty();
        private Optional<String> password = Optional.empty();
        private ClientSpecificConfig clientSpecific = java;

        public HttpConfig build(String contentType) {
            return new HttpConfig(this.pushUrl, this.connectionTimeoutMs, this.requestTimeoutMs, this.tenantId, contentType, this.username, this.password, this.clientSpecific);
        }

        public Builder fill(Consumer<Builder> func) {
            func.accept(this);
            return this;
        }

        public Builder setPushUrl(String pushUrl) {
            this.pushUrl = pushUrl;
            return this;
        }

        public Builder setConnectionTimeoutMs(long connectionTimeoutMs) {
            this.connectionTimeoutMs = connectionTimeoutMs;
            return this;
        }

        public Builder setRequestTimeoutMs(long requestTimeoutMs) {
            this.requestTimeoutMs = requestTimeoutMs;
            return this;
        }

        public Builder setTenantId(Optional<String> tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder setUsername(Optional<String> username) {
            this.username = username;
            return this;
        }

        public Builder setPassword(Optional<String> password) {
            this.password = password;
            return this;
        }

        public Builder setClientConfig(ClientSpecificConfig clientSpecificConfig) {
            this.clientSpecific = clientSpecificConfig;
            return this;
        }
    }
}

