/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.pinyin.support.style;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.pinyin.model.CharToneInfo;
import com.github.houbb.pinyin.model.ToneItem;
import com.github.houbb.pinyin.spi.IPinyinToneStyle;
import com.github.houbb.pinyin.util.ToneHelper;

@ThreadSafe
public abstract class AbstractPinyinToneStyle
implements IPinyinToneStyle {
    protected abstract String getCharFormat(String var1, CharToneInfo var2);

    @Override
    public String style(String charTone) {
        if (StringUtil.isEmpty((String)charTone)) {
            return charTone;
        }
        CharToneInfo toneInfo = this.getCharToneInfo(charTone);
        return this.getCharFormat(charTone, toneInfo);
    }

    private CharToneInfo getCharToneInfo(String tone) {
        CharToneInfo charToneInfo = new CharToneInfo();
        charToneInfo.setIndex(-1);
        int length = tone.length();
        for (int i = 0; i < length; ++i) {
            char currentChar = tone.charAt(i);
            ToneItem toneItem = ToneHelper.getToneItem(currentChar);
            if (!ObjectUtil.isNotNull((Object)toneItem)) continue;
            charToneInfo.setToneItem(toneItem);
            charToneInfo.setIndex(i);
            break;
        }
        return charToneInfo;
    }

    String connector(String tone, int index, String letter) {
        int maxIndex = index + 1;
        if (index + 1 == tone.length()) {
            return tone.substring(0, index) + letter;
        }
        return tone.substring(0, index) + letter + tone.substring(maxIndex);
    }
}

