/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.io;

import com.github.houbb.heaven.response.exception.CommonRuntimeException;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class StreamUtil {
    private StreamUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public static String toString(InputStream is, String charset) {
        try (ByteArrayOutputStream boa = new ByteArrayOutputStream();){
            int len = 0;
            byte[] buffer = new byte[1024];
            while ((len = is.read(buffer)) != -1) {
                boa.write(buffer, 0, len);
            }
            byte[] result = boa.toByteArray();
            String string = new String(result, charset);
            return string;
        }
        catch (Exception e) {
            throw new CommonRuntimeException(e);
        }
    }

    @Deprecated
    public static String toString(InputStream is) {
        return StreamUtil.toString(is, "UTF-8");
    }

    public static String getFileContent(String path) {
        return StreamUtil.getFileContent(path, "UTF-8");
    }

    /*
     * Exception decompiling
     */
    public static String getFileContent(String path, String charset) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static InputStream getInputStream(String filePath) {
        InputStream inputStream;
        try {
            inputStream = new URL(filePath).openStream();
        }
        catch (MalformedURLException localMalformedURLException) {
            try {
                inputStream = new FileInputStream(filePath);
            }
            catch (Exception localException2) {
                ClassLoader localClassLoader = Thread.currentThread().getContextClassLoader();
                if (localClassLoader == null) {
                    localClassLoader = StreamUtil.class.getClassLoader();
                }
                if ((inputStream = localClassLoader.getResourceAsStream(filePath)) == null) {
                    throw new CommonRuntimeException("Could not find file: " + filePath);
                }
            }
        }
        catch (IOException localIOException1) {
            throw new CommonRuntimeException(localIOException1);
        }
        return inputStream;
    }

    public static void closeStream(Closeable closeable) {
        if (ObjectUtil.isNotNull(closeable)) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                throw new CommonRuntimeException(e);
            }
        }
    }

    public static List<String> readAllLines(String path) {
        InputStream inputStream = StreamUtil.class.getResourceAsStream(path);
        return StreamUtil.readAllLines(inputStream, "UTF-8", true);
    }

    public static List<String> readAllLines(InputStream is) {
        return StreamUtil.readAllLines(is, "UTF-8", true);
    }

    public static List<String> readAllLines(InputStream is, String charset, boolean ignoreEmpty) {
        try {
            ArrayList<String> lines = new ArrayList<String>();
            BufferedReader e = new BufferedReader(new InputStreamReader(is, Charset.forName(charset)));
            while (e.ready()) {
                String entry = e.readLine();
                if (StringUtil.isEmpty(entry) && ignoreEmpty) continue;
                lines.add(entry);
            }
            return lines;
        }
        catch (IOException e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static String getFileContent(String path, int startIndex, int endIndex) {
        return StreamUtil.getFileContent(path, startIndex, endIndex, StandardCharsets.UTF_8);
    }

    public static String getFileContent(String path, int startIndex, int endIndex, Charset charset) {
        try {
            InputStream inputStream = StreamUtil.class.getResourceAsStream(path);
            inputStream.skip(startIndex);
            byte[] bytes = new byte[endIndex - startIndex];
            inputStream.read(bytes);
            return new String(bytes, charset);
        }
        catch (IOException e) {
            throw new CommonRuntimeException(e);
        }
    }
}

