/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.io;

import com.github.houbb.heaven.response.exception.CommonRuntimeException;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.util.ArrayUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public final class FileUtil {
    private FileUtil() {
    }

    public static String getFileContent(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            try {
                FileInputStream inputStream = new FileInputStream(file);
                return FileUtil.getFileContent(inputStream);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return "";
    }

    public static String getFileContent(InputStream inputStream) {
        return FileUtil.getFileContent(inputStream, "UTF-8");
    }

    public static String getFileContent(InputStream inputStream, String charset) {
        try {
            int size = inputStream.available();
            byte[] bytes = new byte[size];
            int readSize = inputStream.read(bytes);
            inputStream.close();
            String jsonText = new String(bytes, charset);
            return jsonText;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSuffix(String fileName) {
        return fileName.substring(fileName.lastIndexOf(46) + 1);
    }

    public static List<String> getFileContentEachLine(String filePath, int initLine) {
        File file = new File(filePath);
        return FileUtil.getFileContentEachLine(file, initLine);
    }

    public static List<String> getFileContentEachLine(String filePath) {
        File file = new File(filePath);
        return FileUtil.getFileContentEachLine(file, 0);
    }

    public static List<String> getFileContentEachLineTrim(String filePath, int initLine) {
        List<String> stringList = FileUtil.getFileContentEachLine(filePath, initLine);
        LinkedList<String> resultList = new LinkedList<String>();
        for (String string : stringList) {
            resultList.add(string.trim());
        }
        return resultList;
    }

    public static List<String> getFileContentEachLine(File file) {
        return FileUtil.getFileContentEachLine(file, 0);
    }

    public static List<String> getFileContentEachLine(File file, int initLine) {
        LinkedList<String> contentList = new LinkedList<String>();
        if (!file.exists()) {
            return contentList;
        }
        String charset = "UTF-8";
        try (FileInputStream fileInputStream = new FileInputStream(file);
             InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, charset);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String dataEachLine;
            int lineNo;
            for (lineNo = 0; lineNo < initLine; ++lineNo) {
                String string = bufferedReader.readLine();
            }
            while ((dataEachLine = bufferedReader.readLine()) != null) {
                ++lineNo;
                if (Objects.equals("", dataEachLine)) continue;
                contentList.add(dataEachLine);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return contentList;
    }

    public static List<String> getFileContentEachLine(File file, int initLine, int endLine, String charset) {
        LinkedList<String> contentList = new LinkedList<String>();
        if (!file.exists()) {
            return contentList;
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);
             InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, charset);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String dataEachLine;
            int lineNo;
            for (lineNo = 0; lineNo < initLine; ++lineNo) {
                String string = bufferedReader.readLine();
            }
            while ((dataEachLine = bufferedReader.readLine()) != null && lineNo < endLine) {
                ++lineNo;
                contentList.add(dataEachLine);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return contentList;
    }

    public static List<String> readAllLines(File file, String charset, int initLine, int endLine, boolean ignoreEmpty) {
        ArgUtil.notNull(file, "file");
        ArgUtil.notEmpty(charset, "charset");
        LinkedList<String> contentList = new LinkedList<String>();
        if (!file.exists()) {
            return contentList;
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);
             InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, charset);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String dataEachLine;
            int lineNo;
            for (lineNo = 0; lineNo < initLine; ++lineNo) {
                String string = bufferedReader.readLine();
            }
            while ((dataEachLine = bufferedReader.readLine()) != null && lineNo < endLine) {
                ++lineNo;
                if (ignoreEmpty && StringUtil.isEmpty(dataEachLine)) continue;
                contentList.add(dataEachLine);
            }
        }
        catch (IOException e) {
            throw new CommonRuntimeException(e);
        }
        return contentList;
    }

    public static List<String> readAllLines(String filePath, String charset, boolean ignoreEmpty) {
        File file = new File(filePath);
        return FileUtil.readAllLines(file, charset, 0, Integer.MAX_VALUE, ignoreEmpty);
    }

    public static List<String> readAllLines(String filePath, String charset) {
        return FileUtil.readAllLines(filePath, charset, false);
    }

    public static List<String> readAllLines(String filePath) {
        return FileUtil.readAllLines(filePath, "UTF-8");
    }

    public static void copyDir(String sourceDir, String targetDir) throws IOException {
        File file = new File(sourceDir);
        Object[] filePath = file.list();
        if (!new File(targetDir).exists()) {
            new File(targetDir).mkdir();
        }
        if (ArrayUtil.isNotEmpty(filePath)) {
            for (Object aFilePath : filePath) {
                if (new File(sourceDir + File.separator + (String)aFilePath).isDirectory()) {
                    FileUtil.copyDir(sourceDir + File.separator + (String)aFilePath, targetDir + File.separator + (String)aFilePath);
                }
                if (!new File(sourceDir + File.separator + (String)aFilePath).isFile()) continue;
                FileUtil.copyFile(sourceDir + File.separator + (String)aFilePath, targetDir + File.separator + (String)aFilePath);
            }
        }
    }

    public static void copyFile(String sourceFile, String targetPath) throws IOException {
        File oldFile = new File(sourceFile);
        File file = new File(targetPath);
        try (FileInputStream in = new FileInputStream(oldFile);
             FileOutputStream out = new FileOutputStream(file);){
            byte[] buffer = new byte[0x200000];
            while (in.read(buffer) != -1) {
                out.write(buffer);
            }
        }
    }

    public static void write(String filePath, CharSequence line) {
        FileUtil.write(filePath, Collections.singletonList(line), new OpenOption[0]);
    }

    public static void write(String filePath, Iterable<? extends CharSequence> lines, OpenOption ... openOptions) {
        FileUtil.write(filePath, lines, "UTF-8", openOptions);
    }

    public static void write(String filePath, Iterable<? extends CharSequence> lines, String charset, OpenOption ... openOptions) {
        try {
            ArgUtil.notNull(lines, "charSequences");
            CharsetEncoder encoder = Charset.forName(charset).newEncoder();
            Path path = Paths.get(filePath, new String[0]);
            OutputStream out = path.getFileSystem().provider().newOutputStream(path, openOptions);
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, encoder));){
                for (CharSequence charSequence : lines) {
                    writer.append(charSequence);
                    writer.newLine();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean createFile(String filePath) {
        boolean mkdirResult;
        if (StringUtil.isEmpty(filePath)) {
            return false;
        }
        if (FileUtil.exists(filePath, new LinkOption[0])) {
            return true;
        }
        File file = new File(filePath);
        File dir = file.getParentFile();
        if (FileUtil.notExists(dir) && !(mkdirResult = dir.mkdirs())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean exists(String filePath, LinkOption ... options) {
        if (StringUtil.isEmpty(filePath)) {
            return false;
        }
        Path path = Paths.get(filePath, new String[0]);
        return Files.exists(path, options);
    }

    public static boolean notExists(String filePath, LinkOption ... options) {
        return !FileUtil.exists(filePath, options);
    }

    public static boolean notExists(File file) {
        ArgUtil.notNull(file, "file");
        return !file.exists();
    }

    public static boolean isEmpty(String filePath) {
        if (StringUtil.isEmpty(filePath)) {
            return true;
        }
        File file = new File(filePath);
        return file.length() <= 0L;
    }

    public static boolean isNotEmpty(String filePath) {
        return !FileUtil.isEmpty(filePath);
    }

    /*
     * Exception decompiling
     */
    public static byte[] getFileBytes(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static byte[] getFileBytes(String filePath) {
        ArgUtil.notNull(filePath, "filePath");
        File file = new File(filePath);
        return FileUtil.getFileBytes(file);
    }

    public static void createFile(String filePath, byte[] bytes) {
        File file = FileUtil.createFileAssertSuccess(filePath);
        try (FileOutputStream fos = new FileOutputStream(file);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            bos.write(bytes);
        }
        catch (Exception e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static File createFileAssertSuccess(String filePath) {
        boolean mkdirResult;
        ArgUtil.notEmpty(filePath, "filePath");
        File file = new File(filePath);
        if (file.exists()) {
            return file;
        }
        File dir = file.getParentFile();
        if (FileUtil.notExists(dir) && !(mkdirResult = dir.mkdirs())) {
            throw new CommonRuntimeException("Parent file create fail " + filePath);
        }
        try {
            boolean createFile = file.createNewFile();
            if (!createFile) {
                throw new CommonRuntimeException("Create new file fail for path " + filePath);
            }
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void deleteFile(File file) {
        boolean result;
        ArgUtil.notNull(file, "file");
        if (file.exists() && !(result = file.delete())) {
            throw new CommonRuntimeException("Delete file fail for path " + file.getAbsolutePath());
        }
    }

    public static File createTempFile(String name, String suffix) {
        try {
            ArgUtil.notEmpty(name, "prefix");
            ArgUtil.notEmpty(suffix, "suffix");
            return File.createTempFile(name, suffix);
        }
        catch (IOException e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static File createTempFile(String nameWithSuffix) {
        try {
            ArgUtil.notEmpty(nameWithSuffix, "fileName");
            String[] strings = nameWithSuffix.split("\\.");
            return File.createTempFile(strings[0], strings[1]);
        }
        catch (IOException e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static boolean isImage(String string) {
        if (StringUtil.isEmpty(string)) {
            return false;
        }
        return string.endsWith(".png") || string.endsWith(".jpeg") || string.endsWith(".jpg") || string.endsWith(".gif");
    }
}

