/*
 * Decompiled with CFR 0.152.
 */
package com.github.heqiao2010.lunar;

import com.github.heqiao2010.lunar.LunarCalendar;
import com.github.heqiao2010.lunar.LunarCodes;
import java.util.Calendar;

public class LunarUtils {
    public static long luanrDiff(LunarCalendar lc1, LunarCalendar lc2, int field) {
        return LunarUtils.solarDiff(lc1, lc2, field);
    }

    public static long solarDiff(Calendar solar1, Calendar solar2, int field) {
        long t1 = solar1.getTimeInMillis();
        long t2 = solar2.getTimeInMillis();
        switch (field) {
            case 13: {
                return (long)Math.rint((double)(t1 - t2) / 1000.0);
            }
            case 12: {
                return (long)Math.rint((double)(t1 - t2) / 60000.0);
            }
            case 10: {
                return (long)Math.rint((double)(t1 - t2) / 3600000.0);
            }
            case 5: {
                return (long)Math.rint((double)(t1 - t2) / 8.64E7);
            }
            case 2: {
                return (long)Math.rint((double)(t1 - t2) / 2.592E9);
            }
            case 1: {
                return (long)Math.rint((double)(t1 - t2) / 3.1536E10);
            }
        }
        return -1L;
    }

    public static long lengthOfMonth(int lunarYear, int month, boolean isLeapMonth) {
        int i;
        short[] codes = LunarCodes.monthCodes(lunarYear);
        int n = i = isLeapMonth ? month + 1 : month;
        if (codes[0] > 0 && month > codes[0]) {
            ++i;
        }
        return LunarCodes.lengthOfMonth(lunarYear, month, codes[i]);
    }

    public static int binSearch(int[] array, int n) {
        if (null == array || array.length == 0) {
            return -1;
        }
        int min = 0;
        int max = array.length - 1;
        if (n <= array[min]) {
            return min;
        }
        if (n >= array[max]) {
            return max;
        }
        while (max - min > 1) {
            int newIndex = (max + min) / 2;
            if (array[newIndex] > n) {
                max = newIndex;
                continue;
            }
            if (array[newIndex] < n) {
                min = newIndex;
                continue;
            }
            return newIndex;
        }
        if (array[max] == n) {
            return max;
        }
        if (array[min] == n) {
            return min;
        }
        return min;
    }
}

