/*
 * Decompiled with CFR 0.152.
 */
package com.github.heqiao2010.lunar;

import com.github.heqiao2010.lunar.LunarCodes;
import com.github.heqiao2010.lunar.LunarData;
import com.github.heqiao2010.lunar.LunarUtils;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class LunarCalendar
extends GregorianCalendar {
    private static final long serialVersionUID = 7241031233810655166L;
    private int lunarYear;
    private int lunarMonth;
    private int dayOfLunarMonth;
    private boolean isLeapMonth = false;
    private int leapMonth = 0;

    public LunarCalendar() {
        this.computeBySolarDate(this.get(1), this.get(2), this.get(5));
    }

    public LunarCalendar(TimeZone zone) {
        super(zone);
        this.computeBySolarDate(this.get(1), this.get(2), this.get(5));
    }

    public LunarCalendar(Locale aLocale) {
        super(aLocale);
        this.computeBySolarDate(this.get(1), this.get(2), this.get(5));
    }

    public LunarCalendar(TimeZone zone, Locale aLocale) {
        super(zone, aLocale);
        this.computeBySolarDate(this.get(1), this.get(2), this.get(5));
    }

    public LunarCalendar(int year, int month, int dayOfMonth) {
        super(year, month, dayOfMonth);
        this.computeBySolarDate(this.get(1), this.get(2), this.get(5));
    }

    public LunarCalendar(int year, int month, int dayOfMonth, int hourOfDay, int minute) {
        super(year, month, dayOfMonth, hourOfDay, minute);
        this.computeBySolarDate(this.get(1), this.get(2), this.get(5));
    }

    public LunarCalendar(int year, int month, int dayOfMonth, int hourOfDay, int minute, int second) {
        super(year, month, dayOfMonth, hourOfDay, minute, second);
        this.computeBySolarDate(this.get(1), this.get(2), this.get(5));
    }

    public LunarCalendar(int lunarYear, int lunarMonth, int dayOfLunarMonth, boolean isLeapMonth) {
        this.computeByLunarDate(lunarYear, lunarMonth, dayOfLunarMonth, isLeapMonth);
    }

    public LunarCalendar(Calendar calendar) {
        super(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
        this.computeBySolarDate(this.get(1), this.get(2), this.get(5));
    }

    public static LunarCalendar solar2Lunar(Calendar solar) {
        return new LunarCalendar(solar);
    }

    public static Calendar lunar2Solar(int lunarYear, int lunarMonth, int LunarDate, boolean isLeapMonth) {
        LunarCalendar ret = new LunarCalendar();
        ret.computeByLunarDate(lunarYear, lunarMonth, LunarDate, isLeapMonth);
        return ret;
    }

    @Override
    public void add(int field, int amount) {
        super.add(field, amount);
        this.computeBySolarDate(this.get(1), this.get(2), this.get(5));
    }

    public void addByLunar(int field, int amount) {
        switch (field) {
            case 5: {
                super.add(5, amount);
                this.computeBySolarDate(this.get(1), this.get(2), this.get(5));
                break;
            }
            case 2: {
                this.addLunarMonths(amount);
                break;
            }
            case 1: {
                this.checkComputeLunarDate(this.lunarYear + amount, this.lunarMonth, this.dayOfLunarMonth, false);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("unsupported field: %d", field));
            }
        }
    }

    public void addLunarMonths(int amount) {
        int y = this.lunarYear;
        int m = -1;
        int index = LunarCodes.monthIndex(y, this.lunarMonth, this.isLeapMonth);
        boolean isLeapMonth = false;
        int sum = index + amount;
        if (amount > 0) {
            for (int _y = this.lunarYear; _y < 2150; ++_y) {
                short[] a = LunarCodes.monthCodes(_y);
                int lunarMonths = a.length - 1;
                if ((sum -= lunarMonths) > 0) {
                    ++y;
                }
                if (sum > 0) continue;
                m = sum == 0 ? lunarMonths : lunarMonths + sum;
                boolean bl = isLeapMonth = a[0] > 0 && a[0] + 1 == m;
                if (!isLeapMonth && (a[0] <= 0 || a[0] >= m)) break;
                --m;
                break;
            }
            if (sum > 0) {
                throw new IllegalArgumentException(String.format("add of month out of range: %d", amount));
            }
        } else if (amount < 0) {
            if (sum > 0) {
                m = sum;
            } else if (sum == 0) {
                Map.Entry<Integer, Boolean> en = LunarCodes.month(--y, -1);
                m = en.getKey();
                isLeapMonth = en.getValue();
            } else {
                for (int i = this.lunarYear - 1; i > 1850; --i) {
                    int lunarMonths = LunarCodes.monthCodes(i).length - 1;
                    --y;
                    if ((sum += lunarMonths) < 0) continue;
                    Map.Entry<Integer, Boolean> en = sum == 0 ? LunarCodes.month(--y, -1) : LunarCodes.month(y, sum + 1);
                    m = en.getKey();
                    isLeapMonth = en.getValue();
                    break;
                }
            }
            if (sum < 0) {
                throw new IllegalArgumentException(String.format("add of month out of range: %d", amount));
            }
        }
        this.checkComputeLunarDate(y, m, this.dayOfLunarMonth, isLeapMonth);
    }

    private void checkComputeLunarDate(int y, int m, int d, boolean isLeap) {
        int days = d;
        if (d > 29 && (long)d > LunarUtils.lengthOfMonth(y, m, isLeap)) {
            --days;
        }
        this.computeByLunarDate(y, m, days, isLeap);
    }

    @Override
    public void set(int field, int value) {
        super.set(field, value);
        this.computeBySolarDate(this.get(1), this.get(2), this.get(5));
    }

    @Override
    public void roll(int field, int amount) {
        super.roll(field, amount);
        this.computeBySolarDate(this.get(1), this.get(2), this.get(5));
    }

    @Override
    public String toString() {
        if (this.lunarYear < 1850 || this.lunarYear > 2150 || this.lunarMonth < 1 || this.lunarMonth > 12 || this.dayOfLunarMonth < 1 || this.dayOfLunarMonth > 30) {
            return String.format("Wrong lunar date: %d %d %d", this.lunarYear, this.lunarMonth, this.dayOfLunarMonth);
        }
        return String.format("%s\u5e74%s%s\u6708%s", LunarData.getYearName(this.lunarYear), this.isLeapMonth() ? "\u95f0" : "", Character.valueOf(LunarData.getMonthName(this.lunarMonth)), LunarData.getDayName(this.dayOfLunarMonth));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LunarCalendar)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LunarCalendar that = (LunarCalendar)o;
        return this.lunarYear == that.lunarYear && this.lunarMonth == that.lunarMonth && this.dayOfLunarMonth == that.dayOfLunarMonth && this.isLeapMonth == that.isLeapMonth && this.leapMonth == that.leapMonth;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.lunarYear;
        result = 31 * result + this.lunarMonth;
        result = 31 * result + this.dayOfLunarMonth;
        result = 31 * result + this.leapMonth;
        result = 31 * result + (this.isLeapMonth ? 1 : 0);
        return result;
    }

    @Override
    public Object clone() {
        LunarCalendar other = (LunarCalendar)super.clone();
        other.lunarYear = this.getLunarYear();
        other.lunarMonth = this.getLunarMonth();
        other.dayOfLunarMonth = this.getDayOfLunarMonth();
        other.leapMonth = this.getLeapMonth();
        other.isLeapMonth = this.isLeapMonth();
        return other;
    }

    public String getLunar(boolean showLeap) {
        if (this.lunarMonth < 1 || this.lunarMonth > 12 || this.dayOfLunarMonth < 1 || this.dayOfLunarMonth > 30) {
            throw new IllegalArgumentException(String.format("Wrong lunar dayOfLunarMonth: %d %d", this.lunarMonth, this.dayOfLunarMonth));
        }
        if (showLeap) {
            return String.format("%s%s\u6708%s", this.isLeapMonth() ? "\u95f0" : "", Character.valueOf(LunarData.getMonthName(this.lunarMonth)), LunarData.getDayName(this.dayOfLunarMonth));
        }
        return String.format("%s\u6708%s", Character.valueOf(LunarData.getMonthName(this.lunarMonth)), LunarData.getDayName(this.dayOfLunarMonth));
    }

    public String getFullLunarName() {
        return String.format("%s %s %s", this, LunarData.getTraditionalYearName(this.lunarYear), Character.valueOf(LunarData.getAnimalYearName(this.lunarYear)));
    }

    private int[] builderSolarCodes(int solarYear) {
        if (solarYear < 1850 || solarYear > 2150) {
            throw new IllegalArgumentException("Illegal solar year: " + solarYear);
        }
        int lunarIndex = solarYear - 1850;
        int[] solarCodes = new int[LunarData.LUNAR_INFO[lunarIndex].length];
        for (int i = 0; i < solarCodes.length; ++i) {
            if (0 == i) {
                solarCodes[i] = LunarData.LUNAR_INFO[lunarIndex][i];
                continue;
            }
            if (1 == i) {
                if (LunarData.LUNAR_INFO[lunarIndex][1] > 999) {
                    solarCodes[i] = (solarYear - 1) * 10000 + LunarData.LUNAR_INFO[lunarIndex][i];
                    continue;
                }
                solarCodes[i] = solarYear * 10000 + LunarData.LUNAR_INFO[lunarIndex][i];
                continue;
            }
            solarCodes[i] = solarYear * 10000 + LunarData.LUNAR_INFO[lunarIndex][i];
        }
        return solarCodes;
    }

    private void computeByLunarDate(int lunarYear, int lunarMonth, int lunarDate, boolean isLeapMonth) {
        long length;
        if (lunarYear < 1850 || lunarYear > 2150) {
            throw new IllegalArgumentException(String.format("LunarYear must in (%d, %d)", 1850, 2150));
        }
        this.lunarYear = lunarYear;
        this.lunarMonth = lunarMonth;
        this.dayOfLunarMonth = lunarDate;
        this.isLeapMonth = isLeapMonth;
        short code = LunarCodes.lunarMonthCode(lunarYear, lunarMonth, isLeapMonth);
        if (lunarDate == 30 && (length = LunarCodes.lengthOfMonth(lunarYear, lunarMonth, code)) != 30L) {
            throw new IllegalArgumentException(String.format("\u519c\u5386%d\u5e74%d\u6708, \u95f0\u6708=%s\uff0c\u6708\u5929\u6570\u4e3a%d < %d", lunarYear, lunarMonth, isLeapMonth, length, lunarDate));
        }
        super.set(1, lunarYear + LunarCodes.codeYear(code));
        super.set(2, LunarCodes.codeMonth(code) - 1);
        super.set(5, LunarCodes.codeDay(code));
        super.add(5, lunarDate - 1);
    }

    private void computeBySolarDate(int solarYear, int solarMonth, int solarDate) {
        if (solarYear < 1850 || solarYear == 1850 && solarMonth < 1 || solarYear == 1850 && solarMonth == 1 && solarDate < 12 || solarYear > 2150 || solarYear == 2150 && solarMonth > 11 || solarYear == 2150 && solarMonth == 11 && solarDate > 31) {
            return;
        }
        int solarCode = solarYear * 10000 + 100 * (1 + solarMonth) + solarDate;
        this.leapMonth = LunarData.LUNAR_INFO[solarYear - 1850][0];
        int[] solarCodes = this.builderSolarCodes(solarYear);
        int newMonth = LunarUtils.binSearch(solarCodes, solarCode);
        if (-1 == newMonth) {
            throw new IllegalArgumentException("No lunarInfo found by solarCode: " + solarCode);
        }
        int xDate = Long.valueOf(LunarCodes.solarDateCodesDiff(solarCode, solarCodes[newMonth], 5)).intValue();
        if (0 == newMonth) {
            int preYear = solarYear - 1;
            this.leapMonth = LunarData.LUNAR_INFO[preYear - 1850][0];
            short[] preSolarCodes = LunarData.LUNAR_INFO[preYear - 1850];
            int nearSolarCode = preSolarCodes[preSolarCodes.length - 1];
            nearSolarCode = (nearSolarCode / 100 == 13 ? preYear + 1 : preYear) * 10000 + (nearSolarCode / 100 == 13 ? nearSolarCode - 1200 : nearSolarCode);
            if (nearSolarCode > solarCode) {
                newMonth = 11;
                nearSolarCode = preYear * 10000 + preSolarCodes[preSolarCodes.length - 2];
            } else {
                newMonth = 12;
            }
            xDate = Long.valueOf(LunarCodes.solarDateCodesDiff(solarCode, nearSolarCode, 5)).intValue();
            if (xDate < 0) {
                throw new IllegalArgumentException("Wrong solarCode: " + solarCode);
            }
            this.dayOfLunarMonth = 1 + xDate;
            this.lunarYear = preYear;
            this.lunarMonth = newMonth;
            this.isLeapMonth = 0 != this.leapMonth && this.leapMonth == newMonth;
        } else if (solarCodes.length == newMonth + 1 && xDate >= 30) {
            newMonth = 1;
            short[] nextSolarCodes = LunarData.LUNAR_INFO[solarYear + 1 - 1850];
            int nearSolarCode = solarYear * 10000 + nextSolarCodes[1];
            xDate = Long.valueOf(LunarCodes.solarDateCodesDiff(solarCode, nearSolarCode, 5)).intValue();
            if (xDate < 0) {
                throw new IllegalArgumentException("Wrong solarCode: " + solarCode);
            }
            this.dayOfLunarMonth = 1 + xDate;
            this.lunarYear = solarYear + 1;
            this.lunarMonth = newMonth;
            this.isLeapMonth = false;
        } else {
            if (xDate < 0) {
                throw new IllegalArgumentException("Wrong solarCode: " + solarCode);
            }
            this.dayOfLunarMonth = 1 + xDate;
            this.lunarYear = solarYear;
            this.isLeapMonth = 0 != this.leapMonth && this.leapMonth + 1 == newMonth;
            this.lunarMonth = 0 != this.leapMonth && this.leapMonth < newMonth ? newMonth - 1 : newMonth;
        }
    }

    public int getLunarYear() {
        return this.lunarYear;
    }

    public int getLunarMonth() {
        return this.lunarMonth;
    }

    public int getDayOfLunarMonth() {
        return this.dayOfLunarMonth;
    }

    public int getLeapMonth() {
        return this.leapMonth;
    }

    public boolean isLeapMonth() {
        return this.isLeapMonth;
    }
}

