/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jlogs;

import com.github.drinkjava2.jlogs.ConsoleLog;
import com.github.drinkjava2.jlogs.Log;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Properties;

public abstract class LogFactory {
    private static boolean printed = false;
    private static Class<?> dbProLogClass = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Log getLog(Class<?> clazz) {
        if (dbProLogClass == Void.TYPE) {
            return new ConsoleLog(clazz);
        }
        if (dbProLogClass != null) {
            try {
                Constructor<?> constr = dbProLogClass.getConstructor(Class.class);
                return (Log)constr.newInstance(clazz);
            }
            catch (Exception e) {
                if (!LogFactory.printed()) {
                    System.err.println("Can not load log class: " + dbProLogClass + ", will use ConsoleLog JLog logger. \r\n" + e.getMessage());
                }
                dbProLogClass = Void.TYPE;
                return new ConsoleLog(clazz);
            }
        }
        InputStream is = Log.class.getClassLoader().getResourceAsStream("jlogs.properties");
        if (is == null) {
            if (!LogFactory.printed()) {
                System.out.println("Not found jlogs.properties for jSqlBox,  will use ConsoleLog as default logger.");
            }
            dbProLogClass = Void.TYPE;
            return new ConsoleLog(clazz);
        }
        Properties prop = new Properties();
        String className = "";
        try {
            prop.load(is);
            className = prop.getProperty("log");
            dbProLogClass = Class.forName(className);
            if (!LogFactory.printed()) {
                System.out.print("jlog.properties found, will use " + className + " as JLog logger.");
            }
            Log log = LogFactory.getLog(clazz);
            return log;
        }
        catch (Exception e) {
            if (!LogFactory.printed()) {
                System.err.println("No or wrong jlog.properties file: " + className + ", will use ConsoleLog as JLog logger. \r\n" + e.getMessage());
            }
            dbProLogClass = Void.TYPE;
            ConsoleLog consoleLog = new ConsoleLog(clazz);
            return consoleLog;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static boolean printed() {
        boolean old = printed;
        printed = true;
        return old;
    }
}

