/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import com.github.drinkjava2.jdialects.Dialect;
import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jdialects.Type;
import com.github.drinkjava2.jdialects.TypeUtils;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jdialects.springsrc.utils.ReflectionUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class TableModelUtilsOfEntity {
    public static Map<Class<?>, TableModel> globalTableModelCache = new ConcurrentHashMap();
    public static Map<String, Class<?>> globalTableToEntityCache = new ConcurrentHashMap();

    public static Class<?> tableNameToEntityClass(String tableName) {
        String lowCase = tableName.toLowerCase();
        Class<?> result = globalTableToEntityCache.get(lowCase);
        if (result != null) {
            return result;
        }
        for (Map.Entry<Class<?>, TableModel> entry : globalTableModelCache.entrySet()) {
            if (!lowCase.equalsIgnoreCase(entry.getValue().getTableName())) continue;
            globalTableToEntityCache.put(lowCase, entry.getKey());
            return entry.getKey();
        }
        return null;
    }

    private static boolean matchNameCheck(String annotationName, String cName) {
        if (("javax.persistence." + annotationName).equals(cName)) {
            return true;
        }
        if (("com.github.drinkjava2.jdialects.annotation.jpa." + annotationName).equals(cName)) {
            return true;
        }
        if (("com.github.drinkjava2.jdialects.annotation.jdia." + annotationName).equals(cName)) {
            return true;
        }
        for (int i = 0; i <= 9; ++i) {
            if (!("com.github.drinkjava2.jdialects.annotation.jdia." + annotationName + i).equals(cName)) continue;
            return true;
        }
        return false;
    }

    private static List<Map<String, Object>> getEntityAnnos(Object targetClass, String annotationName) {
        Annotation[] anno = null;
        anno = targetClass instanceof Field ? ((Field)targetClass).getAnnotations() : ((Class)targetClass).getAnnotations();
        ArrayList<Map<String, Object>> l = new ArrayList<Map<String, Object>>();
        for (Annotation annotation : anno) {
            Class<? extends Annotation> type = annotation.annotationType();
            String cName = type.getName();
            if (!TableModelUtilsOfEntity.matchNameCheck(annotationName, cName)) continue;
            l.add(TableModelUtilsOfEntity.changeAnnotationValuesToMap(annotation, type));
        }
        return l;
    }

    private static Map<String, Object> getFirstEntityAnno(Object targetClass, String annotationName) {
        Annotation[] anno = null;
        anno = targetClass instanceof Field ? ((Field)targetClass).getAnnotations() : ((Class)targetClass).getAnnotations();
        for (Annotation annotation : anno) {
            Class<? extends Annotation> type = annotation.annotationType();
            String cName = type.getName();
            if (!TableModelUtilsOfEntity.matchNameCheck(annotationName, cName)) continue;
            return TableModelUtilsOfEntity.changeAnnotationValuesToMap(annotation, type);
        }
        return new HashMap<String, Object>();
    }

    private static boolean existEntityAnno(Object targetClass, String annotationName) {
        Map<String, Object> annotion = TableModelUtilsOfEntity.getFirstEntityAnno(targetClass, annotationName);
        return annotion.size() == 1;
    }

    private static Map<String, Object> changeAnnotationValuesToMap(Annotation annotation, Class<? extends Annotation> type) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("AnnotationExist", true);
        for (Method method : type.getDeclaredMethods()) {
            try {
                result.put(method.getName(), method.invoke((Object)annotation, (Object[])null));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static TableModel entity2ReadOnlyModel(Class<?> entityClass) {
        DialectException.assureNotNull(entityClass, "Entity class can not be null");
        TableModel model = globalTableModelCache.get(entityClass);
        if (model != null) {
            return model;
        }
        model = TableModelUtilsOfEntity.entity2ModelWithConfig(entityClass);
        model.setReadOnly(true);
        globalTableModelCache.put(entityClass, model);
        return model;
    }

    public static TableModel[] entity2ReadOnlyModel(Class<?> ... entityClasses) {
        ArrayList<TableModel> l = new ArrayList<TableModel>();
        for (Class<?> clazz : entityClasses) {
            l.add(TableModelUtilsOfEntity.entity2ReadOnlyModel(clazz));
        }
        return l.toArray(new TableModel[l.size()]);
    }

    public static TableModel entity2EditableModel(Class<?> entityClass) {
        DialectException.assureNotNull(entityClass, "Entity class can not be null");
        TableModel model = globalTableModelCache.get(entityClass);
        if (model != null) {
            return model.newCopy();
        }
        model = TableModelUtilsOfEntity.entity2ModelWithConfig(entityClass);
        model.setReadOnly(true);
        globalTableModelCache.put(entityClass, model);
        return model.newCopy();
    }

    public static TableModel[] entity2EditableModels(Class<?> ... entityClasses) {
        ArrayList<TableModel> l = new ArrayList<TableModel>();
        for (Class<?> clazz : entityClasses) {
            l.add(TableModelUtilsOfEntity.entity2EditableModel(clazz));
        }
        return l.toArray(new TableModel[l.size()]);
    }

    private static TableModel entity2ModelIgnoreConfigMethod(Class<?> entityClass) {
        Map<String, Object> uuidAnyMp;
        Map<String, Object> tableGenMap;
        Map<String, Object> seqMap;
        DialectException.assureNotNull(entityClass, "entity2Model method does not accept a null class");
        String tableName = null;
        Map<String, Object> entityMap = TableModelUtilsOfEntity.getFirstEntityAnno(entityClass, "Entity");
        tableName = (String)entityMap.get("name");
        Map<String, Object> tableMap = TableModelUtilsOfEntity.getFirstEntityAnno(entityClass, "Table");
        if (!StrUtils.isEmpty(tableMap.get("name"))) {
            tableName = (String)tableMap.get("name");
        }
        if (StrUtils.isEmpty(tableName)) {
            tableName = Dialect.globalNamingConversion != null ? Dialect.globalNamingConversion.getTableName(entityClass) : entityClass.getSimpleName();
        }
        TableModel model = new TableModel(tableName);
        model.setEntityClass(entityClass);
        if (!tableMap.isEmpty()) {
            Annotation[] uniques;
            Annotation[] indexes = (Annotation[])tableMap.get("indexes");
            if (indexes != null && indexes.length > 0) {
                for (Annotation anno : indexes) {
                    Map<String, Object> mp = TableModelUtilsOfEntity.changeAnnotationValuesToMap(anno, anno.annotationType());
                    String columnListString = (String)mp.get("columnList");
                    String[] columns = columnListString.indexOf(44) >= 0 ? columnListString.split(",") : new String[]{columnListString};
                    if (columns.length <= 0) continue;
                    model.index((String)mp.get("name")).columns(columns).setUnique((Boolean)mp.get("unique"));
                }
            }
            if ((uniques = (Annotation[])tableMap.get("uniqueConstraints")) != null && uniques.length > 0) {
                for (Annotation anno : uniques) {
                    Map<String, Object> mp = TableModelUtilsOfEntity.changeAnnotationValuesToMap(anno, anno.annotationType());
                    String[] columnNames = (String[])mp.get("columnNames");
                    if (columnNames == null || columnNames.length <= 0) continue;
                    model.unique((String)mp.get("name")).columns(columnNames);
                }
            }
        }
        if (!(seqMap = TableModelUtilsOfEntity.getFirstEntityAnno(entityClass, "SequenceGenerator")).isEmpty()) {
            model.sequenceGenerator((String)seqMap.get("name"), (String)seqMap.get("sequenceName"), (Integer)seqMap.get("initialValue"), (Integer)seqMap.get("allocationSize"));
        }
        if (!(tableGenMap = TableModelUtilsOfEntity.getFirstEntityAnno(entityClass, "TableGenerator")).isEmpty()) {
            model.tableGenerator((String)tableGenMap.get("name"), (String)tableGenMap.get("table"), (String)tableGenMap.get("pkColumnName"), (String)tableGenMap.get("valueColumnName"), (String)tableGenMap.get("pkColumnValue"), (Integer)tableGenMap.get("initialValue"), (Integer)tableGenMap.get("allocationSize"));
        }
        if (!(uuidAnyMp = TableModelUtilsOfEntity.getFirstEntityAnno(entityClass, "UUIDAny")).isEmpty()) {
            model.uuidAny((String)uuidAnyMp.get("name"), (Integer)uuidAnyMp.get("length"));
        }
        List<Map<String, Object>> fkeys = TableModelUtilsOfEntity.getEntityAnnos(entityClass, "FKey");
        for (Map<String, Object> map : fkeys) {
            Boolean ddl = (Boolean)map.get("ddl");
            if (ddl == null) {
                ddl = true;
            }
            model.fkey((String)map.get("name")).columns((String[])map.get("columns")).refs((String[])map.get("refs")).ddl(ddl);
        }
        BeanInfo beanInfo = null;
        PropertyDescriptor[] pds = null;
        try {
            beanInfo = Introspector.getBeanInfo(entityClass);
            pds = beanInfo.getPropertyDescriptors();
        }
        catch (Exception e) {
            DialectException.throwEX("entity2Model can not get bean info", e);
        }
        for (PropertyDescriptor pd : pds) {
            Map<String, Object> uniMap;
            Map<String, Object> idxMap;
            Map<String, Object> refMap;
            Object strategy;
            Map<String, Object> gvMap;
            Map<String, Object> shardDatabaseMap;
            Map<String, Object> shardTableMap;
            Map<String, Object> TemporalMap;
            String entityfieldName = pd.getName();
            if ("class".equals(entityfieldName) || "simpleName".equals(entityfieldName) || "canonicalName".equals(entityfieldName)) continue;
            Class<?> propertyClass = pd.getPropertyType();
            Field field = ReflectionUtils.findField(entityClass, entityfieldName);
            if (field == null) continue;
            Object convertClassOrName = null;
            Map<String, Object> convertMap = TableModelUtilsOfEntity.getFirstEntityAnno(field, "Version");
            if (!convertMap.isEmpty()) {
                convertClassOrName = "Version";
            } else {
                convertMap = TableModelUtilsOfEntity.getFirstEntityAnno(field, "Convert");
                if (!convertMap.isEmpty()) {
                    convertClassOrName = (Class)convertMap.get("value");
                    if (convertClassOrName == null || convertClassOrName == Void.TYPE) {
                        convertClassOrName = (Class)convertMap.get("converter");
                    }
                    if (convertClassOrName == Void.TYPE) {
                        convertClassOrName = null;
                    }
                }
                if (!(convertMap = TableModelUtilsOfEntity.getFirstEntityAnno(field, "Enumerated")).isEmpty()) {
                    convertClassOrName = "EnumType." + convertMap.get("value");
                }
            }
            if (!TableModelUtilsOfEntity.getFirstEntityAnno(field, "Transient").isEmpty() || convertClassOrName == null && !TypeUtils.canMapToDialectType(propertyClass)) {
                ColumnModel col = new ColumnModel(entityfieldName);
                col.setColumnType(TypeUtils.javaType2DialectType(propertyClass));
                col.setTransientable(true);
                col.setEntityField(entityfieldName);
                col.setTableModel(model);
                model.addColumn(col);
                continue;
            }
            Map<String, Object> map = TableModelUtilsOfEntity.getFirstEntityAnno(field, "SequenceGenerator");
            if (!map.isEmpty()) {
                model.sequenceGenerator((String)map.get("name"), (String)map.get("sequenceName"), (Integer)map.get("initialValue"), (Integer)map.get("allocationSize"));
            }
            if (!(map = TableModelUtilsOfEntity.getFirstEntityAnno(field, "TableGenerator")).isEmpty()) {
                model.tableGenerator((String)map.get("name"), (String)map.get("table"), (String)map.get("pkColumnName"), (String)map.get("valueColumnName"), (String)map.get("pkColumnValue"), (Integer)map.get("initialValue"), (Integer)map.get("allocationSize"));
            }
            if (!(map = TableModelUtilsOfEntity.getFirstEntityAnno(field, "UUIDAny")).isEmpty()) {
                model.uuidAny((String)map.get("name"), (Integer)map.get("length"));
            }
            String columnName = entityfieldName;
            if (Dialect.globalNamingConversion != null) {
                columnName = Dialect.globalNamingConversion.getColumnName(columnName);
            }
            ColumnModel col = new ColumnModel(columnName);
            col.entityField(entityfieldName);
            col.setConverterClassOrName(convertClassOrName);
            Map<String, Object> colMap = TableModelUtilsOfEntity.getFirstEntityAnno(field, "Column");
            Map<String, Object> COLUMNMap = TableModelUtilsOfEntity.getFirstEntityAnno(field, "COLUMN");
            if (colMap.isEmpty()) {
                colMap = COLUMNMap;
            }
            if (!colMap.isEmpty()) {
                if (!((Boolean)colMap.get("nullable")).booleanValue()) {
                    col.setNullable(false);
                }
                if (!StrUtils.isEmpty(colMap.get("name"))) {
                    col.setColumnName((String)colMap.get("name"));
                }
                col.setLength((Integer)colMap.get("length"));
                col.setPrecision((Integer)colMap.get("precision"));
                col.setScale((Integer)colMap.get("scale"));
                if (!StrUtils.isEmpty(colMap.get("columnDefinition"))) {
                    String colDEF = (String)colMap.get("columnDefinition");
                    col.setColumnDefinition(colDEF);
                    colDEF = colDEF.trim();
                    if (colDEF.contains(" ")) {
                        colDEF = StrUtils.substringBefore(colDEF, " ");
                    }
                    col.setColumnType(TypeUtils.colDef2DialectType(colDEF));
                } else {
                    col.setColumnType(TypeUtils.javaType2DialectType(propertyClass));
                }
                col.setInsertable((Boolean)colMap.get("insertable"));
                col.setUpdatable((Boolean)colMap.get("updatable"));
                if (!COLUMNMap.isEmpty()) {
                    col.setTail((String)COLUMNMap.get("tail"));
                    col.setComment((String)COLUMNMap.get("comment"));
                    col.setCreateTimestamp((Boolean)COLUMNMap.get("createTimestamp"));
                    col.setUpdateTimestamp((Boolean)COLUMNMap.get("updateTimestamp"));
                    col.setCreatedBy((Boolean)COLUMNMap.get("createdBy"));
                    col.setLastModifiedBy((Boolean)COLUMNMap.get("lastModifiedBy"));
                }
            } else {
                col.setColumnType(TypeUtils.javaType2DialectType(propertyClass));
            }
            if (TableModelUtilsOfEntity.existEntityAnno(field, "CreateTimestamp")) {
                col.setCreateTimestamp(true);
            }
            if (TableModelUtilsOfEntity.existEntityAnno(field, "UpdateTimestamp")) {
                col.setUpdateTimestamp(true);
            }
            if (TableModelUtilsOfEntity.existEntityAnno(field, "CreatedBy")) {
                col.setCreatedBy(true);
            }
            if (TableModelUtilsOfEntity.existEntityAnno(field, "LastModifiedBy")) {
                col.setLastModifiedBy(true);
            }
            if ("EnumType.ORDINAL".equals(col.getConverterClassOrName())) {
                col.setColumnType(Type.INTEGER);
            } else if ("EnumType.STRING".equals(col.getConverterClassOrName())) {
                col.setColumnType(Type.VARCHAR);
            }
            if (!TableModelUtilsOfEntity.getFirstEntityAnno(field, "Id").isEmpty() || !TableModelUtilsOfEntity.getFirstEntityAnno(field, "PKey").isEmpty()) {
                col.pkey();
            }
            if (!(TemporalMap = TableModelUtilsOfEntity.getFirstEntityAnno(field, "Temporal")).isEmpty()) {
                String temporalType = TemporalMap.get("value").toString();
                if ("TIMESTAMP".equals(temporalType)) {
                    col.setColumnType(Type.TIMESTAMP);
                } else if ("DATE".equals(temporalType)) {
                    col.setColumnType(Type.DATE);
                } else if ("TIME".equals(temporalType)) {
                    col.setColumnType(Type.TIME);
                }
            }
            if (!(shardTableMap = TableModelUtilsOfEntity.getFirstEntityAnno(field, "ShardTable")).isEmpty()) {
                col.shardTable((String[])shardTableMap.get("value"));
            }
            if (!(shardDatabaseMap = TableModelUtilsOfEntity.getFirstEntityAnno(field, "ShardDatabase")).isEmpty()) {
                col.shardDatabase((String[])shardDatabaseMap.get("value"));
            }
            col.setEntityField(entityfieldName);
            col.setTableModel(model);
            model.addColumn(col);
            if (TableModelUtilsOfEntity.existEntityAnno(field, "AutoId")) {
                col.autoId();
            }
            if (TableModelUtilsOfEntity.existEntityAnno(field, "IdentityId")) {
                col.identityId();
            }
            if (TableModelUtilsOfEntity.existEntityAnno(field, "TimeStampId")) {
                col.timeStampId();
            }
            if (TableModelUtilsOfEntity.existEntityAnno(field, "UUID")) {
                col.uuid();
            }
            if (TableModelUtilsOfEntity.existEntityAnno(field, "UUID25")) {
                col.uuid25();
            }
            if (TableModelUtilsOfEntity.existEntityAnno(field, "UUID26")) {
                col.uuid26();
            }
            if (TableModelUtilsOfEntity.existEntityAnno(field, "UUID32")) {
                col.uuid32();
            }
            if (TableModelUtilsOfEntity.existEntityAnno(field, "UUID36")) {
                col.uuid36();
            }
            if (TableModelUtilsOfEntity.existEntityAnno(field, "Snowflake")) {
                col.snowflake();
            }
            if (!(gvMap = TableModelUtilsOfEntity.getFirstEntityAnno(field, "GeneratedValue")).isEmpty() && (strategy = gvMap.get("strategy")) != null) {
                String strategyStr = strategy.toString();
                if ("AUTO".equals(strategyStr)) {
                    col.autoId();
                } else if ("IDENTITY".equals(strategyStr)) {
                    col.identityId();
                } else if ("UUID".equals(strategyStr)) {
                    col.uuid();
                } else if ("UUID25".equals(strategyStr)) {
                    col.uuid25();
                } else if ("UUID26".equals(strategyStr)) {
                    col.uuid26();
                } else if ("UUID32".equals(strategyStr)) {
                    col.uuid32();
                } else if ("UUID36".equals(strategyStr)) {
                    col.uuid36();
                } else if ("TIMESTAMP".equals(strategyStr)) {
                    col.timeStampId();
                } else {
                    String generator = (String)gvMap.get("generator");
                    if (StrUtils.isEmpty(generator)) {
                        throw new DialectException("GeneratedValue strategy '" + strategyStr + "' can not find a generator");
                    }
                    col.idGenerator(generator);
                }
            }
            if (!(refMap = TableModelUtilsOfEntity.getFirstEntityAnno(field, "SingleFKey")).isEmpty()) {
                Boolean ddl = (Boolean)refMap.get("ddl");
                if (ddl == null) {
                    ddl = true;
                }
                model.fkey((String)refMap.get("name")).columns(col.getColumnName()).refs((String[])refMap.get("refs")).ddl(ddl);
            }
            if (!(idxMap = TableModelUtilsOfEntity.getFirstEntityAnno(field, "SingleIndex")).isEmpty()) {
                model.index((String)idxMap.get("name")).columns(col.getColumnName());
            }
            if ((uniMap = TableModelUtilsOfEntity.getFirstEntityAnno(field, "SingleUnique")).isEmpty()) continue;
            model.unique((String)uniMap.get("name")).columns(col.getColumnName());
        }
        return model;
    }

    private static TableModel entity2ModelWithConfig(Class<?> entityClass) {
        TableModel model = TableModelUtilsOfEntity.entity2ModelIgnoreConfigMethod(entityClass);
        Method method = null;
        try {
            method = entityClass.getMethod("config", TableModel.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (method != null) {
            try {
                method.invoke(null, model);
            }
            catch (Exception e) {
                throw new DialectException(e);
            }
        }
        if (model == null) {
            throw new DialectException("Can not create TableModel for entityClass " + entityClass);
        }
        TableModel.sortColumns(model.getColumns());
        return model;
    }
}

