/*
 * Decompiled with CFR 0.152.
 */
package com.getui.push.v2.sdk;

import com.getui.push.v2.sdk.GtHttpProxyConfig;
import com.getui.push.v2.sdk.common.Assert;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class GtApiConfiguration {
    private String appId;
    private String appKey;
    private String masterSecret;
    private String domain = "https://restapi.getui.com/v2";
    public static final String ANALYSE_STABLE_DOMAIN_SWITCH_KEY = "gt.analyse.stable.domain.switch";
    public static final String GT_TOP_LEVEL_DOMAIN_LIST_KEY = "gt.top.level.domain.list";
    private static final String DEFAULT_GT_TOP_LEVEL_DOMAIN_LIST = "getui.com,getui.cn";
    private Set<String> gtTopLevelDomainList;
    private long analyseStableDomainInterval = 120000L;
    public static final String CHECK_HEALTH_DATA_SWITCH_KEY = "gt_healthy_switch";
    private long checkHealthInterval = 30000L;
    private final String SOCKET_TIMEOUT_KEY = "gt.socket.timeout";
    private int soTimeout = 30000;
    private final String CONNECT_TIMEOUT_KEY = "gt.connect.timeout";
    private int connectTimeout = 10000;
    private int connectionRequestTimeout = 0;
    private final String MAX_HTTP_TRY_TIME_KEY = "gt.max.http.try.times";
    private int maxHttpTryTime = 1;
    private long keepAliveSeconds = 30L;
    final long MAX_KEEP_ALIVE_SECONDS = 1200L;
    private boolean trustSSL = false;
    private GtHttpProxyConfig proxyConfig;
    private Map<String, Integer> uriToSocketTimeoutMap = new ConcurrentHashMap<String, Integer>();
    public static final String MAX_FAILED_NUM_KEY = "gt.max.failed.num";
    private int maxFailedNum = 10;
    public static final String CONTINUOUS_FAILED_NUM_KEY = "gt.continuous.failed.num";
    private int continuousFailedNum = 3;
    public static final String CHECK_MAX_FAILED_NUM_INTERVAL_KEY = "gt.check.max.failed.num.interval";
    private long checkMaxFailedNumInterval = 3000L;
    public static final String HTTP_CHECK_TIMEOUT_KEY = "gt.http.check.timeout";
    private int httpCheckTimeout = 100;

    public void setDomain(String domain) {
        Assert.notBlank(domain, true);
        this.domain = domain;
    }

    public void check() {
        Assert.notBlank(this.appId, true);
        Assert.notBlank(this.appKey, true);
        Assert.notBlank(this.masterSecret, true);
        Assert.notBlank(this.domain, true);
    }

    public boolean isTrustSSL() {
        return this.trustSSL;
    }

    public void setTrustSSL(boolean trustSSL) {
        this.trustSSL = trustSSL;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getMasterSecret() {
        return this.masterSecret;
    }

    public void setMasterSecret(String masterSecret) {
        this.masterSecret = masterSecret;
    }

    public String getDomain() {
        return this.domain;
    }

    private boolean notGtDomain() {
        for (String gtDomain : this.getGtTopLevelDomainList()) {
            if (!this.domain.contains(gtDomain)) continue;
            return false;
        }
        return true;
    }

    public Set<String> getGtTopLevelDomainList() {
        if (this.gtTopLevelDomainList == null) {
            this.gtTopLevelDomainList = new HashSet<String>(Arrays.asList(System.getProperty(GT_TOP_LEVEL_DOMAIN_LIST_KEY, DEFAULT_GT_TOP_LEVEL_DOMAIN_LIST).split(",")));
        }
        return this.gtTopLevelDomainList;
    }

    public void setGtTopLevelDomainList(String list) {
        System.setProperty(GT_TOP_LEVEL_DOMAIN_LIST_KEY, list);
    }

    public boolean isOpenAnalyseStableDomainSwitch() {
        if (this.notGtDomain()) {
            return false;
        }
        return Boolean.parseBoolean(System.getProperty(ANALYSE_STABLE_DOMAIN_SWITCH_KEY, "true"));
    }

    public void setOpenAnalyseStableDomainSwitch(boolean openAnalyseStableDomainSwitch) {
        System.setProperty(ANALYSE_STABLE_DOMAIN_SWITCH_KEY, String.valueOf(openAnalyseStableDomainSwitch));
    }

    public long getAnalyseStableDomainInterval() {
        return this.analyseStableDomainInterval;
    }

    public void setAnalyseStableDomainInterval(long analyseStableDomainInterval) {
        this.analyseStableDomainInterval = analyseStableDomainInterval;
    }

    public boolean isOpenCheckHealthDataSwitch() {
        return Boolean.getBoolean(CHECK_HEALTH_DATA_SWITCH_KEY);
    }

    public void setOpenCheckHealthDataSwitch(boolean openCheckHealthDataSwitch) {
        System.setProperty(CHECK_HEALTH_DATA_SWITCH_KEY, String.valueOf(openCheckHealthDataSwitch));
    }

    public long getCheckHealthInterval() {
        return this.checkHealthInterval;
    }

    public void setCheckHealthInterval(long checkHealthInterval) {
        this.checkHealthInterval = checkHealthInterval;
    }

    public int getSoTimeout() {
        return Integer.getInteger("gt.socket.timeout", this.soTimeout);
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public int getConnectTimeout() {
        return Integer.getInteger("gt.connect.timeout", this.connectTimeout);
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public void setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    public int getMaxHttpTryTime() {
        return Integer.getInteger("gt.max.http.try.times", this.maxHttpTryTime);
    }

    public void setMaxHttpTryTime(int maxHttpTryTime) {
        this.maxHttpTryTime = maxHttpTryTime;
    }

    public long getKeepAliveSeconds() {
        return this.keepAliveSeconds;
    }

    public void setKeepAliveSeconds(long keepAliveSeconds) {
        this.keepAliveSeconds = keepAliveSeconds > 1200L ? 1200L : keepAliveSeconds;
    }

    @Deprecated
    public long getKeepAliveMinutes() {
        return 0L;
    }

    @Deprecated
    public void setKeepAliveMinutes(long keepAliveMinutes) {
    }

    public GtHttpProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public void setProxyConfig(GtHttpProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
    }

    public int getContinuousFailedNum() {
        return Integer.getInteger(CONTINUOUS_FAILED_NUM_KEY, this.continuousFailedNum);
    }

    public void setContinuousFailedNum(int continuousFailedNum) {
        this.continuousFailedNum = continuousFailedNum;
    }

    public int getMaxFailedNum() {
        return Integer.getInteger(MAX_FAILED_NUM_KEY, this.maxFailedNum);
    }

    public void setMaxFailedNum(int maxFailedNum) {
        this.maxFailedNum = maxFailedNum;
    }

    public long getCheckMaxFailedNumInterval() {
        return Long.getLong(CHECK_MAX_FAILED_NUM_INTERVAL_KEY, this.checkMaxFailedNumInterval);
    }

    public void setCheckMaxFailedNumInterval(long checkMaxFailedNumInterval) {
        this.checkMaxFailedNumInterval = checkMaxFailedNumInterval;
    }

    public int getHttpCheckTimeout() {
        return Integer.getInteger(HTTP_CHECK_TIMEOUT_KEY, this.httpCheckTimeout);
    }

    public void setHttpCheckTimeout(int httpCheckTimeout) {
        this.httpCheckTimeout = httpCheckTimeout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GtApiConfiguration that = (GtApiConfiguration)o;
        if (!this.appId.equals(that.appId)) {
            return false;
        }
        if (!this.appKey.equals(that.appKey)) {
            return false;
        }
        return this.masterSecret.equals(that.masterSecret);
    }

    public int hashCode() {
        int result = this.appId.hashCode();
        result = 31 * result + this.appKey.hashCode();
        result = 31 * result + this.masterSecret.hashCode();
        return result;
    }

    public String keyOfCache() {
        this.check();
        return String.format("%s|%s|%s", this.getAppId(), this.getAppKey(), this.getMasterSecret());
    }

    public String prefixOfKey() {
        this.check();
        return String.format("%s|%s", this.getAppId(), this.getAppKey());
    }

    public void setCustomSocketTimeout(String uri, int socketTimeout) {
        this.uriToSocketTimeoutMap.put(uri, socketTimeout);
    }

    public void resetConnectAndSocketTimeout() {
        this.setConnectTimeout(3000);
        this.setCustomSocketTimeout("/push/single/cid", 3000);
        this.setCustomSocketTimeout("/push/single/alias", 3000);
        this.setCustomSocketTimeout("/push/single/batch/cid", 6000);
        this.setCustomSocketTimeout("/push/single/batch/alias", 6000);
        this.setCustomSocketTimeout("/push/single/batch/alias", 6000);
        this.setCustomSocketTimeout("/push/list/message", 3000);
        this.setCustomSocketTimeout("/push/list/cid", 6000);
        this.setCustomSocketTimeout("/push/list/alias", 6000);
    }

    public int getCustomSocketTimeout(String uri) {
        return Integer.getInteger(uri, this.uriToSocketTimeoutMap.getOrDefault(uri, 0));
    }
}

