/*
 * Decompiled with CFR 0.152.
 */
package com.geccocrawler.gecco.spider.render.html;

import com.geccocrawler.gecco.annotation.HtmlField;
import com.geccocrawler.gecco.request.HttpRequest;
import com.geccocrawler.gecco.response.HttpResponse;
import com.geccocrawler.gecco.spider.SpiderBean;
import com.geccocrawler.gecco.spider.render.FieldRender;
import com.geccocrawler.gecco.spider.render.FieldRenderException;
import com.geccocrawler.gecco.spider.render.RenderException;
import com.geccocrawler.gecco.spider.render.html.HtmlParser;
import com.geccocrawler.gecco.utils.ReflectUtils;
import com.google.common.base.Predicate;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.sf.cglib.beans.BeanMap;
import org.reflections.ReflectionUtils;

public class HtmlFieldRender
implements FieldRender {
    @Override
    public void render(HttpRequest request, HttpResponse response, BeanMap beanMap, SpiderBean bean) throws FieldRenderException {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        Set htmlFields = ReflectionUtils.getAllFields(bean.getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(HtmlField.class)});
        for (Field htmlField : htmlFields) {
            try {
                Object value = this.injectHtmlField(request, response, htmlField, bean.getClass());
                fieldMap.put(htmlField.getName(), value);
            }
            catch (RenderException ex) {
                throw new FieldRenderException(htmlField, (Throwable)ex);
            }
        }
        beanMap.putAll(fieldMap);
    }

    private Object injectHtmlField(HttpRequest request, HttpResponse response, Field field, Class<? extends SpiderBean> clazz) throws RenderException, FieldRenderException {
        HtmlField htmlField = field.getAnnotation(HtmlField.class);
        String content = response.getContent();
        HtmlParser parser = new HtmlParser(request.getUrl(), content);
        parser.setLogClass(clazz);
        String cssPath = htmlField.cssPath();
        Class<?> type = field.getType();
        boolean isList = ReflectUtils.haveSuperType(type, List.class);
        if (isList) {
            Type genericType = field.getGenericType();
            Class genericClass = ReflectUtils.getGenericClass(genericType, 0);
            if (ReflectUtils.haveSuperType(genericClass, SpiderBean.class)) {
                return parser.$beanList(cssPath, request, genericClass);
            }
            try {
                return parser.$basicList(cssPath, field);
            }
            catch (Exception ex) {
                throw new FieldRenderException(field, content, ex);
            }
        }
        if (ReflectUtils.haveSuperType(type, SpiderBean.class)) {
            return parser.$bean(cssPath, request, type);
        }
        try {
            return parser.$basic(cssPath, field);
        }
        catch (Exception ex) {
            throw new FieldRenderException(field, content, ex);
        }
    }
}

