/*
 * Decompiled with CFR 0.152.
 */
package com.geccocrawler.gecco.spider.render;

import com.geccocrawler.gecco.annotation.FieldRenderName;
import com.geccocrawler.gecco.annotation.Href;
import com.geccocrawler.gecco.request.HttpRequest;
import com.geccocrawler.gecco.response.HttpResponse;
import com.geccocrawler.gecco.scheduler.SchedulerContext;
import com.geccocrawler.gecco.spider.SpiderBean;
import com.geccocrawler.gecco.spider.render.CustomFieldRender;
import com.geccocrawler.gecco.spider.render.CustomFieldRenderFactory;
import com.geccocrawler.gecco.spider.render.FieldRenderException;
import com.geccocrawler.gecco.spider.render.Render;
import com.geccocrawler.gecco.spider.render.RenderException;
import com.geccocrawler.gecco.spider.render.RequestFieldRender;
import com.geccocrawler.gecco.spider.render.RequestParameterFieldRender;
import com.geccocrawler.gecco.utils.ReflectUtils;
import com.google.common.base.Predicate;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import net.sf.cglib.beans.BeanMap;
import org.apache.commons.lang3.StringUtils;
import org.reflections.ReflectionUtils;

public abstract class AbstractRender
implements Render {
    private RequestFieldRender requestFieldRender = new RequestFieldRender();
    private RequestParameterFieldRender requestParameterFieldRender = new RequestParameterFieldRender();
    private CustomFieldRenderFactory customFieldRenderFactory;

    @Override
    public SpiderBean inject(Class<? extends SpiderBean> clazz, HttpRequest request, HttpResponse response) throws RenderException {
        try {
            SpiderBean bean = clazz.newInstance();
            BeanMap beanMap = BeanMap.create((Object)bean);
            this.requestFieldRender.render(request, response, beanMap, bean);
            this.requestParameterFieldRender.render(request, response, beanMap, bean);
            this.fieldRender(request, response, beanMap, bean);
            Set customFields = ReflectionUtils.getAllFields(bean.getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(FieldRenderName.class)});
            for (Field customField : customFields) {
                FieldRenderName fieldRender = customField.getAnnotation(FieldRenderName.class);
                String name = fieldRender.value();
                CustomFieldRender customFieldRender = this.customFieldRenderFactory.getCustomFieldRender(name);
                if (customFieldRender == null) continue;
                customFieldRender.render(request, response, beanMap, bean, customField);
            }
            this.requests(request, bean);
            return bean;
        }
        catch (FieldRenderException ex) {
            throw new RenderException(clazz, ex);
        }
        catch (Exception ex) {
            throw new RenderException(clazz);
        }
    }

    public abstract void fieldRender(HttpRequest var1, HttpResponse var2, BeanMap var3, SpiderBean var4) throws FieldRenderException;

    @Override
    public void requests(HttpRequest request, SpiderBean bean) {
        BeanMap beanMap = BeanMap.create((Object)bean);
        Set hrefFields = ReflectionUtils.getAllFields(bean.getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(Href.class)});
        for (Field hrefField : hrefFields) {
            Object o;
            Href href = hrefField.getAnnotation(Href.class);
            if (!href.click() || (o = beanMap.get((Object)hrefField.getName())) == null) continue;
            boolean isList = ReflectUtils.haveSuperType(o.getClass(), List.class);
            if (isList) {
                List list = (List)o;
                for (String url : list) {
                    if (!StringUtils.isNotEmpty((CharSequence)url)) continue;
                    SchedulerContext.into(request.subRequest(url));
                }
                continue;
            }
            String url = (String)o;
            if (!StringUtils.isNotEmpty((CharSequence)url)) continue;
            SchedulerContext.into(request.subRequest(url));
        }
    }

    public void setCustomFieldRenderFactory(CustomFieldRenderFactory customFieldRenderFactory) {
        this.customFieldRenderFactory = customFieldRenderFactory;
    }
}

