/*
 * Decompiled with CFR 0.152.
 */
package com.geccocrawler.gecco.scheduler;

import com.geccocrawler.gecco.request.HttpRequest;
import com.geccocrawler.gecco.scheduler.Scheduler;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FIFOScheduler
implements Scheduler {
    private static Log log = LogFactory.getLog(FIFOScheduler.class);
    private LinkedBlockingQueue<HttpRequest> starQueue = new LinkedBlockingQueue();
    private ConcurrentLinkedQueue<HttpRequest> queue = new ConcurrentLinkedQueue();
    private ReentrantLock outLock = new ReentrantLock();

    @Override
    public void into(HttpRequest request) {
        if (request == null) {
            return;
        }
        if (this.queue.offer(request)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("<===" + request.getUrl()));
            }
        } else {
            log.error((Object)request.getUrl());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpRequest out() {
        this.outLock.lock();
        try {
            HttpRequest request = this.queue.poll();
            if (request == null) {
                request = this.starQueue.take();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("[start]===>" + request.getUrl()));
                }
                this.starQueue.put(request);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("<===[start]" + request.getUrl()));
                }
                HttpRequest httpRequest = request;
                return httpRequest;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("===>" + request.getUrl()));
            }
            HttpRequest httpRequest = request;
            return httpRequest;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            HttpRequest httpRequest = null;
            return httpRequest;
        }
        finally {
            this.outLock.unlock();
        }
    }
}

