/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.uc.sdk;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class SignUtils {
    private static final Logger log = LoggerFactory.getLogger(SignUtils.class);
    public static final String U_SIGN = "u-sign";
    public static final String U_APP_KEY = "u-appKey";
    public static final String U_ONCE = "u-once";
    public static final String U_TIMESTAMP = "u-timestamp";
    public static final String U_NAME = "u-uname";
    public static final String U_SIGNATURE = "u-signature";
    public static final long TIME_OUT = 1800000L;
    public static final String DEFAULT_SIGN = "sign";
    private static final Cache<String, Boolean> ONCE_KEY_CACHE = Caffeine.newBuilder().expireAfterWrite(1800000L, TimeUnit.MILLISECONDS).build();

    public static String sign(Map<String, String> header, String secret) {
        String appKey = header.get(U_APP_KEY);
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)appKey), (String)"u-appKey\u4e3a\u7a7a");
        String uSign = header.get(U_SIGN);
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)uSign), (String)"u-sign\u4e3a\u7a7a");
        String once = header.get(U_ONCE);
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)once), (String)"u-once\u4e3a\u7a7a");
        String timestamp = header.get(U_TIMESTAMP);
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)timestamp), (String)"u-timestamp\u4e3a\u7a7a");
        String uname = header.get(U_NAME);
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)uname), (String)"u-uname\u4e3a\u7a7a");
        String sign = new HmacUtils(HmacAlgorithms.HMAC_SHA_256, secret).hmacHex(appKey + once + timestamp + uname);
        return sign;
    }

    public static void validateSign(HttpServletRequest req, String secret) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put(U_APP_KEY, req.getHeader(U_APP_KEY));
        header.put(U_TIMESTAMP, req.getHeader(U_TIMESTAMP));
        header.put(U_ONCE, req.getHeader(U_ONCE));
        header.put(U_NAME, req.getHeader(U_NAME));
        header.put(U_SIGNATURE, req.getHeader(U_SIGNATURE));
        SignUtils.validateSign(header, secret);
    }

    public static void validateSign(Map<String, String> header, String secret) {
        String appKey = header.get(U_APP_KEY);
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)appKey), (String)"u-appKey\u4e3a\u7a7a");
        String timestampStr = header.get(U_TIMESTAMP);
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)timestampStr), (String)"u-timestamp\u4e3a\u7a7a");
        long timestamp = Long.parseLong(timestampStr);
        long now = System.currentTimeMillis();
        Assert.isTrue((Math.abs(now - timestamp) <= 1800000L ? 1 : 0) != 0, (String)"u-timestamp\u6709\u6548\u671f\u4e0d\u5bf9");
        String once = header.get(U_ONCE);
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)once), (String)"u-once\u4e3a\u7a7a");
        String uname = header.get(U_NAME);
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)uname), (String)"u-uname\u4e3a\u7a7a");
        String sign = header.get(U_SIGNATURE);
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)sign), (String)"u-signature\u4e3a\u7a7a");
        String signResult = new HmacUtils(HmacAlgorithms.HMAC_SHA_256, secret).hmacHex(appKey + once + timestamp + uname);
        Assert.isTrue((boolean)sign.equals(signResult), (String)"\u7b7e\u540d\u4e0d\u4e00\u81f4");
        Boolean cachedOnce = (Boolean)ONCE_KEY_CACHE.getIfPresent((Object)once);
        Assert.isTrue((cachedOnce == null ? 1 : 0) != 0, (String)"\u975e\u6cd5\u91cd\u653e\u653b\u51fb");
        ONCE_KEY_CACHE.put((Object)once, (Object)true);
    }

    public static void main(String[] args) {
        String secret = "4ua4uQggI0g5DRIxc3oP5hDElUX8TcYW";
        HashMap<String, String> header = new HashMap<String, String>();
        header.put(U_SIGN, DEFAULT_SIGN);
        header.put(U_APP_KEY, "zREjZx9tT1eg5bPkSMsrqp03HLo9Mtad");
        header.put(U_ONCE, UUID.randomUUID().toString().replaceAll("-", ""));
        header.put(U_TIMESTAMP, System.currentTimeMillis() + "");
        header.put(U_NAME, "admin");
        String sign = SignUtils.sign(header, secret);
        header.put(U_SIGNATURE, sign);
        log.info("header:{}", header);
        SignUtils.validateSign(header, secret);
    }
}

