/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.oauth.controller.register;

import com.gccloud.starter.common.annation.SysLog;
import com.gccloud.starter.common.exception.GlobalException;
import com.gccloud.starter.common.module.register.dto.SysRegDTO;
import com.gccloud.starter.common.module.secure.service.IWeakPwdService;
import com.gccloud.starter.common.validator.ValidatorUtils;
import com.gccloud.starter.common.validator.group.Insert;
import com.gccloud.starter.common.vo.R;
import com.gccloud.starter.core.vo.SysTokenVO;
import com.gccloud.starter.oauth.service.service.sys.service.ISysAccountRegisterService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiSort;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys"})
@Api(tags={"\u8d26\u53f7\u5bc6\u7801\u6ce8\u518c"})
@ApiSort(value=30)
@ConditionalOnProperty(prefix="gc.starter.component", name={"SysAccountRegisterController"}, havingValue="SysAccountRegisterController", matchIfMissing=true)
public class SysAccountRegisterController {
    @Resource
    private ISysAccountRegisterService accountRegisterService;
    @Resource
    private IWeakPwdService weakPwdService;

    @PostMapping(value={"/regist", "/register"})
    @ApiOperation(value="\u6ce8\u518c", notes="\u6ce8\u518c\u7528\u6237", produces="application/json")
    @SysLog(value="\u6ce8\u518c\u7528\u6237", type=12)
    public R<SysTokenVO> registerByAcount(@ApiParam(name="\u6ce8\u518c\u7528\u6237", value="\u4f20\u5165json\u683c\u5f0f", required=true) @RequestBody SysRegDTO regDTO) {
        ValidatorUtils.validateEntity((Object)regDTO, (Class[])new Class[]{Insert.class});
        if (StringUtils.isBlank((CharSequence)regDTO.getPassword()) || this.weakPwdService.exist(regDTO.getPassword())) {
            throw new GlobalException("\u4e0d\u5141\u8bb8\u8fdb\u884c\u5f31\u5bc6\u7801\u8bbe\u7f6e");
        }
        SysTokenVO tokenVO = this.accountRegisterService.register(regDTO);
        return R.success((Object)tokenVO);
    }
}

