/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.oauth.controller.login;

import com.gccloud.starter.common.annation.SysLog;
import com.gccloud.starter.common.config.GlobalConfig;
import com.gccloud.starter.common.constant.GlobalConst;
import com.gccloud.starter.common.entity.SysUserEntity;
import com.gccloud.starter.common.exception.GlobalException;
import com.gccloud.starter.common.module.login.dto.SysPhoneLoginDTO;
import com.gccloud.starter.common.validator.ValidatorUtils;
import com.gccloud.starter.common.vo.R;
import com.gccloud.starter.core.service.ISysTokenService;
import com.gccloud.starter.core.service.ISysUserService;
import com.gccloud.starter.core.vo.SysTokenVO;
import com.gccloud.starter.oauth.service.service.sys.service.impl.SysPhoneCaptchaServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiSort;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/login"})
@Api(tags={"\u624b\u673a\u53f7\u767b\u5f55"})
@ApiSort(value=20)
@ConditionalOnProperty(prefix="gc.starter.component", name={"SysPhoneLoginController"}, havingValue="SysPhoneLoginController", matchIfMissing=true)
public class SysPhoneLoginController {
    private static final Logger log = LoggerFactory.getLogger(SysPhoneLoginController.class);
    @Resource
    private SysPhoneCaptchaServiceImpl phoneCaptchaService;
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private ISysTokenService sysTokenService;
    @Resource
    private GlobalConfig globalConfig;

    @PostMapping(value={"/phone"})
    @SysLog(value="\u624b\u673a\u53f7\u767b\u5f55", type=9)
    @ApiOperation(value="\u624b\u673a\u53f7\u767b\u5f55", notes="\u624b\u673a\u53f7\u767b\u5f55", produces="application/json")
    public R<SysTokenVO> login(@ApiParam(name="\u624b\u673a\u53f7\u767b\u5f55", value="\u4f20\u5165json\u683c\u5f0f", required=true) @RequestBody SysPhoneLoginDTO phoneLoginDTO) {
        ValidatorUtils.validateEntity((Object)phoneLoginDTO, (Class[])new Class[0]);
        this.sysTokenService.checkAllowedTerminal(phoneLoginDTO.getTerminal());
        this.phoneCaptchaService.validate("login-" + phoneLoginDTO.getPhone(), phoneLoginDTO.getCaptcha());
        SysUserEntity user = this.sysUserService.getByPhone(phoneLoginDTO.getPhone());
        if (user == null) {
            throw new GlobalException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (user.getStatus() == null) {
            return R.error((String)"\u8d26\u53f7\u72b6\u6001\u5f02\u5e38");
        }
        if (GlobalConst.User.Status.LOCKED.equals(user.getStatus())) {
            Integer lockTime = this.globalConfig.getPassword().getLockTime();
            Long lastPwdErrorDate = user.getLastPwdErrorDate().getTime();
            if (lockTime != 0 && !ObjectUtils.isEmpty((Object)lastPwdErrorDate)) {
                Long nowDate = System.currentTimeMillis();
                Long lockDate = nowDate - lastPwdErrorDate;
                if (lockDate <= (long)(lockTime * 60 * 1000)) {
                    user.setLastPwdErrorDate(new Date());
                    this.sysUserService.updateById((Object)user);
                    return R.error((String)("\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a\u3002\u8bf7" + this.globalConfig.getPassword().getLockTime() + "\u5206\u949f\u540e\u91cd\u8bd5"));
                }
                user.setStatus(GlobalConst.User.Status.NORMAL);
                this.sysUserService.updateById((Object)user);
            } else {
                return R.error((String)"\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a,\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u8fdb\u884c\u89e3\u9501");
            }
        }
        this.sysUserService.updateLoginSuccessInfo(user.getId());
        SysTokenVO tokenVO = this.sysTokenService.create(user.getId(), phoneLoginDTO.getTerminal());
        return R.success((Object)tokenVO);
    }
}

