/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.oauth.controller.login;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.gccloud.starter.common.annation.SysLog;
import com.gccloud.starter.common.config.GlobalConfig;
import com.gccloud.starter.common.constant.GlobalConst;
import com.gccloud.starter.common.entity.SysUserEntity;
import com.gccloud.starter.common.exception.GlobalException;
import com.gccloud.starter.common.module.login.dto.SysAccountLoginDTO;
import com.gccloud.starter.common.module.login.vo.LoginTipVO;
import com.gccloud.starter.common.module.secure.service.IWeakPwdService;
import com.gccloud.starter.common.validator.ValidatorUtils;
import com.gccloud.starter.common.validator.group.Captcha;
import com.gccloud.starter.common.validator.group.Uuid;
import com.gccloud.starter.common.vo.R;
import com.gccloud.starter.core.service.ISysLoginAuthService;
import com.gccloud.starter.core.service.ISysLoginErrorService;
import com.gccloud.starter.core.service.ISysTokenService;
import com.gccloud.starter.core.service.ISysUserService;
import com.gccloud.starter.core.vo.SysTokenVO;
import com.gccloud.starter.oauth.service.service.sys.service.impl.SysCaptchaServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiSort;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.shiro.crypto.hash.Sha256Hash;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys"})
@Api(tags={"\u767b\u5f55"})
@ApiSort(value=20)
@ConditionalOnProperty(prefix="gc.starter.component", name={"SysAccountLoginController"}, havingValue="SysAccountLoginController", matchIfMissing=true)
public class SysAccountLoginController {
    @Resource
    private SysCaptchaServiceImpl sysCaptchaService;
    @Autowired
    private GlobalConfig globalConfig;
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private ISysTokenService sysTokenService;
    @Autowired
    private ISysLoginAuthService loginAuthService;
    @Resource
    private IWeakPwdService weakPwdService;
    @Resource
    private ISysLoginErrorService loginErrorService;

    @PostMapping(value={"/login"})
    @SysLog(value="\u767b\u5f55", type=9)
    @ApiOperation(value="\u767b\u5f55", notes="\u767b\u5f55", produces="application/json")
    public R<SysTokenVO> login(@ApiParam(name="\u767b\u5f55\u53c2\u6570", value="\u4f20\u5165json\u683c\u5f0f", required=true) @RequestBody SysAccountLoginDTO accountLoginDTO) {
        SysUserEntity user;
        ValidatorUtils.validateEntity((Object)accountLoginDTO, (Class[])new Class[0]);
        this.sysTokenService.checkAllowedTerminal(accountLoginDTO.getTerminal());
        if (this.globalConfig.getCaptcha().isEnable()) {
            ValidatorUtils.validateEntity((Object)accountLoginDTO, (Class[])new Class[]{Uuid.class, Captcha.class});
            this.sysCaptchaService.validate(accountLoginDTO.getUuid(), accountLoginDTO.getCaptcha());
        }
        if ((user = this.sysUserService.getByUserName(accountLoginDTO.getUsername())) == null) {
            throw new GlobalException("\u8d26\u53f7\u6216\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        if (user.getStatus() == null) {
            return R.error((String)"\u8d26\u53f7\u72b6\u6001\u5f02\u5e38, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (!this.loginAuthService.auth(accountLoginDTO.getPassword(), user)) {
            if (this.globalConfig.getPassword().getInputErrorPasswordTime() != 0 && this.globalConfig.getPassword().getLockTime() != 0 && this.globalConfig.getPassword().getErrorPasswordNum() != 0) {
                Integer loginNum;
                if (GlobalConst.User.Status.LOCKED.equals(user.getStatus())) {
                    Long lastPwdErrorDate = user.getLastPwdErrorDate().getTime();
                    Long nowDate = System.currentTimeMillis();
                    Long lockDate = nowDate - lastPwdErrorDate;
                    if (lockDate <= (long)(this.globalConfig.getPassword().getLockTime() * 60 * 1000)) {
                        user.setLastPwdErrorDate(new Date());
                        this.sysUserService.updateById((Object)user);
                        return R.error((String)("\u8f93\u5165\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef\u6b21\u6570\u8fc7\u591a\uff0c\u8d26\u53f7\u5df2\u9501\u5b9a\u3002\u8bf7" + this.globalConfig.getPassword().getLockTime() + "\u5206\u949f\u540e\u91cd\u8bd5"));
                    }
                    user.setStatus(Integer.valueOf(1));
                    this.sysUserService.updateById((Object)user);
                }
                if ((loginNum = this.loginErrorService.errorLoginHandle(user)) == 0) {
                    return R.error((String)("\u8f93\u5165\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef\u6b21\u6570\u8fc7\u591a\uff0c\u8d26\u53f7\u5df2\u9501\u5b9a\u3002\u8bf7" + this.globalConfig.getPassword().getLockTime() + "\u5206\u949f\u540e\u91cd\u8bd5"));
                }
            }
            return R.error((String)"\u8d26\u53f7\u6216\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        if (GlobalConst.User.Status.LOCKED.equals(user.getStatus())) {
            Integer lockTime = this.globalConfig.getPassword().getLockTime();
            Long lastPwdErrorDate = user.getLastPwdErrorDate().getTime();
            if (lockTime != 0 && !ObjectUtils.isEmpty((Object)lastPwdErrorDate)) {
                Long nowDate = System.currentTimeMillis();
                Long lockDate = nowDate - lastPwdErrorDate;
                if (lockDate <= (long)(lockTime * 60 * 1000)) {
                    return R.error((String)("\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a,\u8bf7" + this.globalConfig.getPassword().getLockTime() + "\u5206\u949f\u540e\u91cd\u8bd5"));
                }
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                wrapper.set(SysUserEntity::getStatus, (Object)1);
                wrapper.eq(SysUserEntity::getId, (Object)user.getId());
                this.sysUserService.update((Wrapper)wrapper);
            } else {
                return R.error((String)"\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a,\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u8fdb\u884c\u89e3\u9501");
            }
        }
        LoginTipVO loginTipVO = new LoginTipVO();
        String pwdWillExpireTip = "";
        if (user.getPwdExpireDate() != null) {
            Date nowTime = DateTime.now().toDate();
            Date pwdExpireTime = user.getPwdExpireDate();
            if (pwdExpireTime.getTime() <= nowTime.getTime()) {
                throw new GlobalException("\u60a8\u7684\u5bc6\u7801\u5df2\u7ecf\u8fc7\u671f\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458");
            }
            if (DateTime.now().plusDays(this.globalConfig.getPassword().getNoticeDate().intValue()).toDate().getTime() >= pwdExpireTime.getTime()) {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String date = formatter.format(user.getPwdExpireDate());
                pwdWillExpireTip = "\u60a8\u7684\u5bc6\u7801\u5c06\u4e8e" + date + "\u8fc7\u671f,\u4e3a\u4e86\u5b89\u5168\u8bf7\u7acb\u5373\u4fee\u6539\u5bc6\u7801";
            }
        }
        loginTipVO.setPwdWillExpireTip(pwdWillExpireTip);
        String defaultPwd = this.globalConfig.getPassword().getDefaultPwd();
        defaultPwd = new Sha256Hash((Object)(new Sha256Hash((Object)defaultPwd).toHex() + defaultPwd)).toHex();
        if (defaultPwd.equals(accountLoginDTO.getPassword()) || this.weakPwdService.exist(accountLoginDTO.getPassword())) {
            loginTipVO.setWeakPwd(Boolean.valueOf(true));
        }
        this.sysUserService.updateLoginSuccessInfo(user.getId());
        SysTokenVO tokenVO = this.sysTokenService.create(user.getId(), accountLoginDTO.getTerminal());
        R r = R.success((Object)tokenVO);
        tokenVO.setTip(loginTipVO);
        return r;
    }
}

