/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.oauth.controller.forgotPwd;

import com.gccloud.starter.common.annation.SysLog;
import com.gccloud.starter.common.exception.GlobalException;
import com.gccloud.starter.common.module.forgotPwd.dto.SysForgotPwdPhoneDTO;
import com.gccloud.starter.common.module.secure.service.IWeakPwdService;
import com.gccloud.starter.common.validator.ValidatorUtils;
import com.gccloud.starter.common.vo.R;
import com.gccloud.starter.core.service.ISysUserService;
import com.gccloud.starter.oauth.service.service.sys.service.impl.SysPhoneCaptchaServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiSort;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/forgotPwd"})
@Api(tags={"\u624b\u673a\u627e\u56de\u5bc6\u7801"})
@ApiSort(value=20)
@ConditionalOnProperty(prefix="gc.starter.component", name={"SysPhoneForgotPwdController"}, havingValue="SysPhoneForgotPwdController", matchIfMissing=true)
public class SysPhoneForgotPwdController {
    @Resource
    private IWeakPwdService weakPwdService;
    @Resource
    private ISysUserService userService;
    @Resource
    private SysPhoneCaptchaServiceImpl phoneCaptchaService;

    @PostMapping(value={"/phone"})
    @SysLog(value="\u624b\u673a\u53f7\u627e\u56de\u5bc6\u7801", type=13)
    @ApiOperation(value="\u624b\u673a\u53f7\u627e\u56de\u5bc6\u7801", notes="\u624b\u673a\u53f7\u627e\u56de\u5bc6\u7801", produces="image/jpeg")
    public R<Boolean> forgotPwdByPhone(@RequestBody SysForgotPwdPhoneDTO forgotPwdPhoneDTO) {
        ValidatorUtils.validateEntity((Object)forgotPwdPhoneDTO, (Class[])new Class[0]);
        if (this.weakPwdService.exist(forgotPwdPhoneDTO.getPassword())) {
            throw new GlobalException("\u4e0d\u5141\u8bb8\u8fdb\u884c\u5f31\u5bc6\u7801\u8bbe\u7f6e");
        }
        this.phoneCaptchaService.validate("forgotPwd-" + forgotPwdPhoneDTO.getPhone(), forgotPwdPhoneDTO.getCaptcha());
        if (Boolean.FALSE.equals(this.userService.checkPhoneExist(forgotPwdPhoneDTO.getPhone()))) {
            throw new GlobalException("\u7cfb\u7edf\u4e2d\u6ca1\u6709\u8be5\u624b\u673a\u53f7\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u65b0\u8f93\u5165");
        }
        this.userService.updatePwdByPhone(forgotPwdPhoneDTO.getPhone(), forgotPwdPhoneDTO.getPassword());
        return R.success((Object)true);
    }
}

