/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.oauth.controller.captcha;

import cn.hutool.core.util.RandomUtil;
import com.gccloud.starter.common.constant.GlobalConst;
import com.gccloud.starter.common.exception.GlobalException;
import com.gccloud.starter.common.module.login.cache.SysSmsCaptchaCache;
import com.gccloud.starter.common.module.login.dto.SysPhoneCaptchaDTO;
import com.gccloud.starter.common.validator.ValidatorUtils;
import com.gccloud.starter.common.vo.R;
import com.gccloud.starter.core.service.ISysSmsService;
import com.gccloud.starter.oauth.service.service.sys.service.impl.SysPhoneCaptchaServiceImpl;
import com.gccloud.starter.plugins.cache.common.IStarterCache;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiSort;
import java.io.Serializable;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys"})
@Api(tags={"\u624b\u673a\u9a8c\u8bc1\u7801\u83b7\u53d6"})
@ApiSort(value=11)
@ConditionalOnProperty(prefix="gc.starter.component", name={"SysPhoneCaptchaController"}, havingValue="SysPhoneCaptchaController", matchIfMissing=true)
public class SysPhoneCaptchaController {
    @Resource
    private ISysSmsService smsService;
    @Resource
    private IStarterCache starterCache;
    @Resource
    private SysPhoneCaptchaServiceImpl phoneCaptchaService;

    @PostMapping(value={"/captcha/phone"})
    @ApiOperation(value="\u624b\u673a\u53f7\u9a8c\u8bc1\u7801", notes="\u624b\u673a\u53f7\u9a8c\u8bc1\u7801", produces="application/json")
    public R<Void> captcha(@RequestBody SysPhoneCaptchaDTO phoneCaptchaDTO) {
        ValidatorUtils.validateEntity((Object)phoneCaptchaDTO, (Class[])new Class[0]);
        String prefix = this.getCachePrefix(phoneCaptchaDTO.getFromType());
        String phoneCaptcha = (String)this.starterCache.get(SysSmsCaptchaCache.class, (Serializable)((Object)(prefix + phoneCaptchaDTO.getPhone())), String.class);
        if (StringUtils.isNotBlank((CharSequence)phoneCaptcha)) {
            throw new GlobalException("\u9a8c\u8bc1\u7801\u5728\u6709\u6548\u671f\u5185\uff0c\u8bf7\u4e0d\u8981\u9891\u7e41\u53d1\u9001\u9a8c\u8bc1\u7801");
        }
        String captcha = RandomUtil.randomNumbers((int)6);
        boolean success = this.smsService.sendCaptcha(phoneCaptchaDTO.getPhone(), captcha);
        if (!success) {
            throw new GlobalException("\u9a8c\u8bc1\u7801\u53d1\u9001\u5931\u8d25,\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458");
        }
        this.phoneCaptchaService.saveCaptcha(prefix + phoneCaptchaDTO.getPhone(), captcha);
        return R.success();
    }

    private String getCachePrefix(Integer fromType) {
        String prefix = "";
        if (GlobalConst.Captcha.FromType.LOGIN.equals(fromType)) {
            prefix = "login-";
        }
        if (GlobalConst.Captcha.FromType.REGISTER.equals(fromType)) {
            prefix = "register-";
        }
        if (GlobalConst.Captcha.FromType.FORGOT_PWD.equals(fromType)) {
            prefix = "forgotPwd-";
        }
        return prefix;
    }
}

