/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.oauth.controller.captcha;

import com.gccloud.starter.common.config.GlobalConfig;
import com.gccloud.starter.common.exception.GlobalException;
import com.gccloud.starter.common.validator.UuidValidator;
import com.gccloud.starter.oauth.service.service.sys.service.impl.SysCaptchaServiceImpl;
import com.wf.captcha.ArithmeticCaptcha;
import com.wf.captcha.ChineseCaptcha;
import com.wf.captcha.ChineseGifCaptcha;
import com.wf.captcha.GifCaptcha;
import com.wf.captcha.SpecCaptcha;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiSort;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys"})
@Api(tags={"\u56fe\u5f62\u9a8c\u8bc1\u7801\u83b7\u53d6"})
@ApiSort(value=10)
@ConditionalOnProperty(prefix="gc.starter.component", name={"SysImageCaptchaController"}, havingValue="SysImageCaptchaController", matchIfMissing=true)
public class SysImageCaptchaController {
    private static final Logger log = LoggerFactory.getLogger(SysImageCaptchaController.class);
    @Resource
    private GlobalConfig globalConfig;
    @Resource
    private SysCaptchaServiceImpl sysCaptchaService;

    @GetMapping(value={"/captcha"})
    @ApiOperation(value="\u56fe\u5f62\u9a8c\u8bc1\u7801", notes="\u56fe\u5f62\u9a8c\u8bc1\u7801", produces="image/jpeg")
    public void captcha(HttpServletResponse response, @RequestParam(value="uuid") String uuid) throws IOException {
        if (!this.globalConfig.getCaptcha().isEnable()) {
            log.error("\u9a8c\u8bc1\u7801\u5f00\u5173\u5173\u95ed\uff0c\u65e0\u6cd5\u83b7\u53d6\u9a8c\u8bc1\u7801");
            throw new GlobalException("\u9a8c\u8bc1\u7801\u83b7\u53d6\u5931\u8d25");
        }
        if (!UuidValidator.isValid((String)uuid)) {
            throw new GlobalException("UUID\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        response.setHeader("Cache-Control", "no-store, n o-cache\u2211");
        response.setContentType("image/jpeg");
        ArithmeticCaptcha captcha = null;
        int type = this.globalConfig.getCaptcha().getType();
        int width = this.globalConfig.getCaptcha().getWidth();
        int height = this.globalConfig.getCaptcha().getHeight();
        int length = this.globalConfig.getCaptcha().getLength();
        switch (type) {
            case 0: {
                captcha = new GifCaptcha(width, height, length);
                break;
            }
            case 2: {
                captcha = new ChineseGifCaptcha(width, height, length);
                break;
            }
            case 1: {
                captcha = new ChineseCaptcha(width, height, length);
                break;
            }
            case 3: {
                captcha = new ArithmeticCaptcha(width, height);
                captcha.getArithmeticString();
                break;
            }
            default: {
                captcha = new SpecCaptcha(width, height, length);
            }
        }
        String code = captcha.text();
        this.sysCaptchaService.saveCaptcha(uuid, code);
        captcha.out((OutputStream)response.getOutputStream());
    }
}

