/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.oauth.controller.captcha;

import cn.hutool.core.util.RandomUtil;
import com.gccloud.starter.common.constant.GlobalConst;
import com.gccloud.starter.common.exception.GlobalException;
import com.gccloud.starter.common.module.login.cache.SysEmailCaptchaCache;
import com.gccloud.starter.common.module.login.dto.SysEmailCaptchaDTO;
import com.gccloud.starter.common.validator.ValidatorUtils;
import com.gccloud.starter.common.vo.R;
import com.gccloud.starter.core.service.ISysEmailService;
import com.gccloud.starter.oauth.service.service.sys.service.impl.SysEmailCaptchaServiceImpl;
import com.gccloud.starter.plugins.cache.common.IStarterCache;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiSort;
import java.io.IOException;
import java.io.Serializable;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys"})
@Api(tags={"\u90ae\u7bb1\u9a8c\u8bc1\u7801\u83b7\u53d6"})
@ApiSort(value=12)
@ConditionalOnProperty(prefix="gc.starter.component", name={"SysEmailCaptchaController"}, havingValue="SysEmailCaptchaController", matchIfMissing=true)
public class SysEmailCaptchaController {
    @Resource
    private ISysEmailService emailService;
    @Resource
    private IStarterCache starterCache;
    @Resource
    private SysEmailCaptchaServiceImpl emailCaptchaService;

    @PostMapping(value={"/captcha/email"})
    @ApiOperation(value="\u90ae\u7bb1\u9a8c\u8bc1\u7801", notes="\u90ae\u7bb1\u9a8c\u8bc1\u7801", produces="application/json")
    public R<Void> captcha(@RequestBody SysEmailCaptchaDTO emailCaptchaDTO) throws IOException {
        ValidatorUtils.validateEntity((Object)emailCaptchaDTO, (Class[])new Class[0]);
        String prefix = this.getCachePrefix(emailCaptchaDTO.getFromType());
        String emailCaptcha = (String)this.starterCache.get(SysEmailCaptchaCache.class, (Serializable)((Object)(prefix + emailCaptchaDTO.getEmail())), String.class);
        if (StringUtils.isNotBlank((CharSequence)emailCaptcha)) {
            throw new GlobalException("\u9a8c\u8bc1\u7801\u5728\u6709\u6548\u671f\u5185\uff0c\u8bf7\u4e0d\u8981\u9891\u7e41\u53d1\u9001\u9a8c\u8bc1\u7801");
        }
        String captcha = RandomUtil.randomString((int)6);
        boolean success = this.emailService.sendCaptcha(emailCaptchaDTO.getEmail(), captcha);
        if (!success) {
            throw new GlobalException("\u9a8c\u8bc1\u7801\u53d1\u9001\u5931\u8d25,\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458");
        }
        this.emailCaptchaService.saveCaptcha(prefix + emailCaptchaDTO.getEmail(), captcha);
        return R.success();
    }

    private String getCachePrefix(Integer fromType) {
        String prefix = "";
        if (GlobalConst.Captcha.FromType.LOGIN.equals(fromType)) {
            prefix = "login-";
        }
        if (GlobalConst.Captcha.FromType.REGISTER.equals(fromType)) {
            prefix = "register-";
        }
        if (GlobalConst.Captcha.FromType.FORGOT_PWD.equals(fromType)) {
            prefix = "forgotPwd-";
        }
        return prefix;
    }
}

