/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.oauth.controller;

import com.gccloud.starter.common.annation.SysLog;
import com.gccloud.starter.common.module.login.cache.SysTokenCache;
import com.gccloud.starter.common.utils.UserUtils;
import com.gccloud.starter.common.vo.CurrentUserBase;
import com.gccloud.starter.common.vo.R;
import com.gccloud.starter.core.controller.SuperController;
import com.gccloud.starter.core.service.ISysTokenService;
import com.gccloud.starter.core.vo.SysTokenVO;
import com.gccloud.starter.plugins.cache.common.IStarterCache;
import io.jsonwebtoken.Claims;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiSort;
import java.io.Serializable;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys"})
@Api(tags={"\u767b\u51fa"})
@ApiSort(value=40)
@ConditionalOnProperty(prefix="gc.starter.component", name={"SysLogoutController"}, havingValue="SysLogoutController", matchIfMissing=true)
public class SysLogoutController
extends SuperController {
    @Resource
    private IStarterCache starterCache;
    @Resource
    private ISysTokenService sysTokenService;

    @PostMapping(value={"/logout/delete"})
    @SysLog(value="\u767b\u51fa", type=10)
    @ApiOperation(value="\u767b\u51fa", notes="\u767b\u51fa", produces="application/json")
    public R<SysTokenVO> logout(HttpServletRequest request) {
        CurrentUserBase user = UserUtils.getCurrentUser();
        Claims jwtClaims = this.sysTokenService.getJwtClaims();
        Assert.isTrue((jwtClaims != null ? 1 : 0) != 0, (String)"\u975e\u6cd5\u64cd\u4f5c");
        String tokenId = (String)jwtClaims.get("id", String.class);
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tokenId), (String)"\u975e\u6cd5\u64cd\u4f5c");
        request.getSession().invalidate();
        this.starterCache.invalidate(SysTokenCache.class.getSimpleName(), (Serializable)((Object)tokenId));
        return this.success();
    }
}

