package com.gccloud.starter.authority.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gccloud.starter.core.dao.SysUserRoleDao;
import com.gccloud.starter.core.dto.SysUserRoleDTO;
import com.gccloud.starter.core.entity.SysUserRoleEntity;
import com.gccloud.starter.core.service.ISysUserRoleService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author tang.jiawen
 * @Date 2020/6/18
 * @Version 1.0.0
 */
@Service
public class SysUserRoleServiceImpl extends ServiceImpl<SysUserRoleDao, SysUserRoleEntity> implements ISysUserRoleService {

    @Override
    public void add(String userId, List<String> roleIdList, SysUserRoleDTO userRoleDTO) {
        if (CollectionUtils.isEmpty(roleIdList)) {
            return;
        }
        this.deleteByUserId(userId);
        // 保存用户与角色关系
        List<SysUserRoleEntity> list = new ArrayList<>(roleIdList.size());
        for (String roleId : roleIdList) {
            SysUserRoleEntity sysUserRoleEntity = new SysUserRoleEntity();
            sysUserRoleEntity.setUserId(userId);
            sysUserRoleEntity.setRoleId(roleId);
            if (userRoleDTO != null) {
                sysUserRoleEntity.setTenantId(userRoleDTO.getTenantId());
                sysUserRoleEntity.setCreateBy(userRoleDTO.getCreateBy());
            }
            list.add(sysUserRoleEntity);
        }
        this.saveBatch(list);
    }

    @Override
    public void update(String userId, List<String> roleIdList) {
        this.deleteByUserId(userId);
        this.add(userId, roleIdList, null);
    }

    @Override
    public List<String> getRoleIdList(String userId) {
        LambdaQueryWrapper<SysUserRoleEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(SysUserRoleEntity::getUserId, userId);
        List<SysUserRoleEntity> sysUserRoleEntities = this.list(queryWrapper);
        List<String> roleList = new ArrayList<>();
        for (SysUserRoleEntity entity : sysUserRoleEntities) {
            roleList.add(entity.getRoleId());
        }
        return roleList;
    }

    @Override
    public void deleteByRoleIds(String[] roleIds) {
        if (ArrayUtils.isEmpty(roleIds)) {
            return;
        }
        LambdaQueryWrapper<SysUserRoleEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(SysUserRoleEntity::getRoleId, roleIds);
        this.delete(queryWrapper);
    }

    @Override
    public void deleteByUserId(String userId) {
        if (StringUtils.isBlank(userId)) {
            return;
        }
        LambdaQueryWrapper<SysUserRoleEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(SysUserRoleEntity::getUserId, userId);
        if (count(queryWrapper) > 0) {
            this.delete(queryWrapper);
        }
    }

    @Override
    public void deleteByUserIds(String[] userIds) {
        if (ArrayUtils.isEmpty(userIds)) {
            return;
        }
        LambdaQueryWrapper<SysUserRoleEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(SysUserRoleEntity::getUserId, userIds);
        this.delete(queryWrapper);
    }
}
