package com.gccloud.starter.authority.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gccloud.starter.common.exception.GlobalException;
import com.gccloud.starter.core.dao.SysTenantDao;
import com.gccloud.starter.core.entity.SysTenantEntity;
import com.gccloud.starter.core.service.ISysTenantService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;


/**
 * @Author tang.jiawen
 * @Date 2020/6/24
 * @Version 1.0.0
 */

@Service
@Slf4j
public class SysTenantServiceImpl extends ServiceImpl<SysTenantDao, SysTenantEntity> implements ISysTenantService {

    @Override
    public void add(SysTenantEntity tenant) {
        // 计算重名
        boolean repeat = this.repeat(tenant);
        if (repeat) {
            throw new GlobalException(String.format("租户【%s】已存在", tenant.getName()));
        }
        this.save(tenant);
    }

    @Override
    public void update(SysTenantEntity tenant) {
        this.updateById(tenant);
    }

    @Override
    public void setDefaultManager(String id) {
        LambdaUpdateWrapper<SysTenantEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper
                .set(SysTenantEntity::getDefaultTenant, true)
                .eq(SysTenantEntity::getId, id);
        this.update(updateWrapper);
        LambdaUpdateWrapper<SysTenantEntity> updateOtherWrapper = new LambdaUpdateWrapper<>();
        updateOtherWrapper
                .set(SysTenantEntity::getDefaultTenant, false)
                .ne(SysTenantEntity::getId, id);
        this.update(updateOtherWrapper);
    }

    @Override
    public SysTenantEntity getDefaultTenant() {
        LambdaQueryWrapper<SysTenantEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper
                .eq(SysTenantEntity::getDefaultTenant, true);
        return this.list(queryWrapper).get(0);
    }

    /**
     * 判重
     *
     * @param entity
     * @return
     */
    private boolean repeat(SysTenantEntity entity) {
        LambdaQueryWrapper<SysTenantEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper
                .eq(SysTenantEntity::getName, entity.getName());
        int count = count(queryWrapper);
        return count > 0;
    }
}
