package com.gccloud.starter.authority.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gccloud.starter.core.dao.SysRoleMenuDao;
import com.gccloud.starter.core.entity.SysRoleMenuEntity;
import com.gccloud.starter.core.service.ISysRoleMenuService;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @Author tang.jiawen
 * @Date 2020/6/22
 * @Version 1.0.0
 */
@Service
public class SysRoleMenuServiceImpl extends ServiceImpl<SysRoleMenuDao, SysRoleMenuEntity> implements ISysRoleMenuService {

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void addOrUpdate(String roleId, List<String> menuIdList) {
        if (StringUtils.isBlank(roleId)) {
            return;
        }
        // 先删除角色与菜单关系
        deleteByRoleIds(new String[]{roleId});
        if (CollectionUtils.isEmpty(menuIdList)) {
            return;
        }
        List<SysRoleMenuEntity> list = Lists.newArrayList();
        // 保存角色与菜单关系
        for (String menuId : menuIdList) {
            SysRoleMenuEntity sysRoleMenuEntity = new SysRoleMenuEntity();
            sysRoleMenuEntity.setMenuId(menuId);
            sysRoleMenuEntity.setRoleId(roleId);
            list.add(sysRoleMenuEntity);
        }
        this.saveBatch(list);
    }

    @Override
    public void deleteByRoleIds(String[] roleIds) {
        if (roleIds == null || roleIds.length == 0) {
            return;
        }
        LambdaQueryWrapper<SysRoleMenuEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(SysRoleMenuEntity::getRoleId, roleIds);
        this.remove(queryWrapper);
    }

    @Override
    public void deleteByMenuId(String menuId) {
        LambdaQueryWrapper<SysRoleMenuEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(SysRoleMenuEntity::getMenuId, menuId);
        this.delete(queryWrapper);
    }
}
