package com.gccloud.starter.authority.service.service.impl;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gccloud.starter.common.dto.SearchDTO;
import com.gccloud.starter.core.dao.SysLogDao;
import com.gccloud.starter.core.dto.SysLogSearchDTO;
import com.gccloud.starter.core.entity.SysLogEntity;
import com.gccloud.starter.core.service.ISysLogService;
import com.gccloud.starter.core.utils.WrapperUtils;
import com.gccloud.starter.mybatis.page.PageVO;
import com.gccloud.starter.mybatis.utils.QueryWrapperUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * @Author maoshufeng
 * @Date 2020-06-16
 * @Version 1.0.0
 */
@Service
public class SysLogServiceImpl extends ServiceImpl<SysLogDao, SysLogEntity> implements ISysLogService {

    @Override
    public PageVO<SysLogEntity> getPage(SysLogSearchDTO searchDTO) {
        LambdaQueryWrapper<SysLogEntity> queryWrapper = QueryWrapperUtils.wrapperLike(new LambdaQueryWrapper(), searchDTO.getSearchKey(), SysLogEntity::getUsername, SysLogEntity::getOperation, SysLogEntity::getParams, SysLogEntity::getClientIp, SysLogEntity::getRequestUri);
        // 根据时间查询
        String startTime = searchDTO.getStartTime();
        Date startDate = parseDate(startTime);
        queryWrapper.ge(startDate != null, SysLogEntity::getCreateDate, startDate);
        String endTime = searchDTO.getEndTime();
        Date endDate = parseDate(endTime);
        queryWrapper.le(endDate != null, SysLogEntity::getCreateDate, endDate);
        if (searchDTO.getType() != null) {
            queryWrapper.eq(SysLogEntity::getType, searchDTO.getType());
        }
        if (searchDTO.getState() != null) {
            queryWrapper.eq(SysLogEntity::getState, searchDTO.getState());
        }
        queryWrapper.orderByDesc(SysLogEntity::getCreateDate);
        // 按数据权限查询
        return pageWithDp(searchDTO, queryWrapper.orderByAsc(SysLogEntity::getCreateDate));
    }

    private Date parseDate(String date) {
        if (StringUtils.isNotBlank(date)) {
            return DateUtil.parse(date, DatePattern.NORM_DATETIME_PATTERN);
        }
        return null;
    }

    @Override
    public void deleteByDate(String start, String end) {
        LambdaQueryWrapper<SysLogEntity> queryWrapper = new LambdaQueryWrapper<>();
        Date startDate = parseDate(start);
        queryWrapper.ge(startDate != null, SysLogEntity::getCreateDate, startDate);
        Date endDate = parseDate(end);
        queryWrapper.le(endDate != null, SysLogEntity::getCreateDate, endDate);
        deleteWithDp(queryWrapper);
    }

    @Override
    public void deleteKeepCount(Integer keepCount) {
        // 计算一共有多少条记录个数
        LambdaQueryWrapper<SysLogEntity> countWrapper = new LambdaQueryWrapper<>();
        countWrapper.select(SysLogEntity::getId);
        WrapperUtils.wrapDp(countWrapper);
        int count = this.count(countWrapper);
        if (count <= keepCount) {
            // 不需要删除
            return;
        }
        // 获取最大值ID、然后删除
        LambdaQueryWrapper<SysLogEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.orderByAsc(SysLogEntity::getId);
        SearchDTO searchDTO = new SearchDTO();
        searchDTO.setSize(1);
        searchDTO.setCurrent(count - keepCount);
        PageVO<SysLogEntity> page = pageWithDp(searchDTO, queryWrapper);
        List<SysLogEntity> list = page.getList();
        if (list == null || list.size() == 0) {
            return;
        }
        SysLogEntity sysLogEntity = list.get(0);
        // 删除
        LambdaQueryWrapper<SysLogEntity> deleteWrapper = new LambdaQueryWrapper<>();
        deleteWrapper.gt(SysLogEntity::getId, sysLogEntity.getId());
        this.deleteWithDp(deleteWrapper);
    }
}
