package com.gccloud.starter.authority.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gccloud.starter.core.dao.SysDataPermissionDao;
import com.gccloud.starter.core.entity.SysDataPermissionEntity;
import com.gccloud.starter.core.service.ISysDataPermissionService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author tang.jiawen
 * @Date 2020/6/28
 * @Version 1.0.0
 */
@Service
public class SysDataPermissionImpl extends ServiceImpl<SysDataPermissionDao, SysDataPermissionEntity> implements ISysDataPermissionService {

    @Override
    public void add(String userId, List<String> orgIdList) {
        if (CollectionUtils.isEmpty(orgIdList)) {
            return;
        }

        LambdaUpdateWrapper<SysDataPermissionEntity> deleteWrapper = new LambdaUpdateWrapper<>();
        deleteWrapper.eq(SysDataPermissionEntity::getUserId, userId);
        this.delete(deleteWrapper);

        // 保存用户与机构的数据权限关系
        List<SysDataPermissionEntity> list = new ArrayList<>(orgIdList.size());
        for (String orgId : orgIdList) {
            SysDataPermissionEntity dp = new SysDataPermissionEntity();
            dp.setUserId(userId);
            dp.setOrgId(orgId);
            list.add(dp);
        }
        this.saveBatch(list);
    }

    @Override
    public List<String> getOrgIds(String userId) {
        List<String> orgIdList = new ArrayList<>();
        LambdaQueryWrapper<SysDataPermissionEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper
                .select(SysDataPermissionEntity::getOrgId)
                .eq(SysDataPermissionEntity::getUserId, userId);
        List<SysDataPermissionEntity> list = this.list(queryWrapper);
        for (SysDataPermissionEntity entity : list) {
            orgIdList.add(entity.getOrgId());
        }
        return orgIdList;
    }

}
