package com.gccloud.starter.authority.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gccloud.starter.common.constant.GlobalConst;
import com.gccloud.starter.common.exception.GlobalException;
import com.gccloud.starter.core.dao.SysConfigDao;
import com.gccloud.starter.core.dto.SysConfigSearchDTO;
import com.gccloud.starter.core.entity.SysConfigEntity;
import com.gccloud.starter.core.entity.SysRoleEntity;
import com.gccloud.starter.core.service.ISysConfigService;
import com.gccloud.starter.core.service.ISysRoleService;
import com.gccloud.starter.core.vo.SysRegistConfigVO;
import com.gccloud.starter.mybatis.page.PageVO;
import com.gccloud.starter.mybatis.utils.QueryWrapperUtils;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 参数配置
 *
 * @Author maoshufeng
 * @Date 2020-06-19
 * @Version 1.0.0
 */
@Service
@Slf4j
public class SysConfigServiceImpl extends ServiceImpl<SysConfigDao, SysConfigEntity> implements ISysConfigService {

    @Autowired
    private ISysRoleService roleService;

    @Override
    public PageVO<SysConfigEntity> getPage(SysConfigSearchDTO searchDTO) {
        LambdaQueryWrapper<SysConfigEntity> queryWrapper = QueryWrapperUtils.wrapperLike(new LambdaQueryWrapper<>(), searchDTO.getSearchKey(), SysConfigEntity::getConfigKey, SysConfigEntity::getConfigValue, SysConfigEntity::getRemark);
        queryWrapper.eq(searchDTO.getSys() != null, SysConfigEntity::getSys, searchDTO.getSys());
        queryWrapper.orderByDesc(SysConfigEntity::getUpdateDate);
        return this.page(searchDTO, queryWrapper);
    }

    @Override
    public void add(SysConfigEntity configEntity) {
        if (repeatTenant(SysConfigEntity::getId, configEntity.getId(), SysConfigEntity::getConfigKey, configEntity.getConfigKey())) {
            throw new GlobalException(String.format("参数键名: %s 已存在", configEntity.getConfigKey()));
        }
        // 设置默认状态
        if (configEntity.getSys() == null) {
            configEntity.setSys(true);
        }
        this.save(configEntity);
    }

    @Override
    public void deleteById(String id) {
        if (getById(id) == null) {
            throw new GlobalException("不存在该参数");
        }
        this.removeById(id);
    }

    @Override
    public void update(SysConfigEntity configEntity) {
        if (repeatGlobal(SysConfigEntity::getId, configEntity.getId(), SysConfigEntity::getConfigKey, configEntity.getConfigKey())) {
            throw new GlobalException(String.format("该参数: %s 已存在", configEntity.getConfigKey()));
        }
        this.updateById(configEntity);
    }

    @Override
    public SysConfigEntity getByConfigKey(String configKey) {
        LambdaQueryWrapper<SysConfigEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(SysConfigEntity::getConfigKey, configKey);
        return getOne(queryWrapper);
    }

    @Override
    public SysRegistConfigVO getRegistConfigByTenantId(String tenantId) {
        SysRegistConfigVO configVO = new SysRegistConfigVO();
        LambdaQueryWrapper<SysConfigEntity> queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysConfigEntity::getConfigKey, GlobalConst.RegistConfig.REGIST_ROLE_CODE_LIST);
        String roleCodes = this.getOne(queryWrapper).getConfigValue();
        List<String> roleIdList = Lists.newArrayList();
        Splitter.on(",").split(roleCodes).forEach(code -> {
            SysRoleEntity role = roleService.getEntityByField(SysRoleEntity::getCode, code);
            roleIdList.add(role.getId());
        });
        LambdaQueryWrapper<SysConfigEntity> lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SysConfigEntity::getConfigKey, GlobalConst.RegistConfig.REGIST_ORG_ID_LIST);
        String orgId = this.getOne(lambdaQueryWrapper).getConfigValue();
        configVO.setRoleIdList(roleIdList);
        configVO.setOrgId(orgId);
        configVO.setTenantId(tenantId);
        return configVO;
    }
}


