package com.gccloud.starter.authority.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.gccloud.starter.common.constant.GlobalConst;
import com.gccloud.starter.core.cache.SysTokenCache;
import com.gccloud.starter.core.dao.SysMenuDao;
import com.gccloud.starter.core.dao.SysUserDao;
import com.gccloud.starter.core.entity.SysMenuEntity;
import com.gccloud.starter.core.entity.SysUserEntity;
import com.gccloud.starter.core.service.IShiroService;
import com.gccloud.starter.plugins.cache.common.IAdminCache;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @Author tang.jiawen
 * @Date 2020/6/23
 * @Version 1.0.0
 */
@Service
public class ShiroServiceImpl implements IShiroService {
    @Resource
    private SysMenuDao menuDao;
    @Resource
    private SysUserDao userDao;
    @Resource
    private IAdminCache cache;

    @Override
    public Set<String> getUserPermissions(String userId) {
        SysUserEntity user = userDao.selectById(userId);
        if (user.getTenantManager()) {
            LambdaQueryWrapper<SysMenuEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(SysMenuEntity::getType, GlobalConst.Menu.Type.BUTTON);
            queryWrapper.eq(SysMenuEntity::getTenantId, user.getTenantId());
            queryWrapper.select(SysMenuEntity::getPermissions);
            List<SysMenuEntity> permissionList = menuDao.selectList(queryWrapper);
            Set<String> permissionSet = permissionList.stream().map(menu -> menu.getPermissions()).collect(Collectors.toSet());
            return permissionSet;
        }
        List<String> permissionList = userDao.getAllPerms(userId);
        Set<String> permissionSet = permissionList.stream().collect(Collectors.toSet());
        return permissionSet;
    }

    @Override
    public SysTokenCache queryByToken(String token) {
        return cache.get(SysTokenCache.class, token);
    }

    @Override
    public SysUserEntity queryUser(String userId) {
        return userDao.selectById(userId);
    }
}
