/*
 * Decompiled with CFR 0.152.
 */
package udtudrmgr;

import com.gbasedbt.jdbc.IfmxCallableStatement;
import com.gbasedbt.jdbc.IfxConnection;
import com.gbasedbt.jdbc.IfxInteger;
import com.gbasedbt.jdbc.IfxLvarchar;
import com.gbasedbt.jdbc.IfxObject;
import com.gbasedbt.jdbc.IfxSqli;
import com.gbasedbt.jdbc.IfxSqliConnect;
import com.gbasedbt.util.IfxErrMsg;
import com.gbasedbt.util.Trace;
import com.gbasedbt.util.TraceFlag;
import java.io.File;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import udtudrmgr.UDRMetaData;

public class UDRManager {
    private IfxConnection conn = null;
    private String jarTmpPath = null;
    private Locale locale = Locale.getDefault();
    private Trace trace = null;
    private boolean isInUserTx = false;
    static Hashtable JavaToIfxNameTable;
    static final String IFX_FILE_TO_FILE = "function gbasedbt.ifx_file_to_file(lvarchar,int,lvarchar,int)";
    static final int LO_SERVER_FILE = 0x10000000;
    static final int LO_CLIENT_FILE = 0x20000000;

    public UDRManager(Connection conn) throws SQLException {
        if (conn == null) {
            throw IfxErrMsg.getSQLException(-79708, "", this.locale);
        }
        this.conn = (IfxConnection)conn;
        this.jarTmpPath = UDRManager.isNTServer(this.conn) ? "c:\\Temp\\" : "/tmp/";
        if (TraceFlag.compiletrace) {
            this.trace = this.conn.getTrace();
            if (this.trace == null) {
                System.out.println("UDRManager: Trace is NULL");
            } else {
                this.trace.writeTrace(1, "UDRManager: constructor exited");
            }
        }
    }

    public void createUDRs(UDRMetaData mdata, String jarfile, String classname, int deploy) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDRManager:createUDRs() entered");
        }
        if (mdata == null) {
            throw IfxErrMsg.getSQLException(-79708, "", this.locale);
        }
        if (classname == null) {
            throw IfxErrMsg.getSQLException(-79708, "", this.locale);
        }
        UDRManager.checkJarFile(jarfile, this.locale);
        int dbtype = this.conn.getDatabaseType();
        if (dbtype == 0) {
            throw IfxErrMsg.getSQLException(-79844, "", this.locale);
        }
        Hashtable udrs = mdata.udrs;
        if (udrs == null || udrs.size() == 0) {
            throw IfxErrMsg.getSQLException(-79842, "", this.locale);
        }
        String jarFileSQLName = mdata.jarFileSQLName;
        if (jarFileSQLName == null) {
            throw IfxErrMsg.getSQLException(-79843, "", this.locale);
        }
        UDRManager.checkJarInSysCatalog(jarFileSQLName, this.conn, this.locale);
        String jarFileInServer = UDRManager.transportJarToServer(jarfile, this.jarTmpPath, this.conn, this.locale);
        if (dbtype == 1 || dbtype == 2) {
            if (((IfxSqliConnect)this.conn).isInUserTransaction()) {
                this.isInUserTx = true;
            } else {
                this.conn.setAutoCommit(false);
            }
        }
        try {
            UDRManager.installJarNow(jarFileSQLName, jarFileInServer, deploy, this.conn);
            UDRManager.registerUDRs(mdata, classname, null, this.conn, this.locale);
        }
        catch (SQLException e2) {
            if (!this.isInUserTx) {
                this.conn.rollback();
                throw e2;
            }
            throw e2;
        }
        if (!(dbtype != 1 && dbtype != 2 || this.isInUserTx)) {
            this.conn.commit();
            this.conn.setAutoCommit(true);
        }
        UDRManager.removeFileInServer(jarFileInServer, this.conn);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDRManager:createUDRs() exited");
        }
    }

    public void removeUDR(String sqlname) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDRManager:removeUDR(String) entered");
        }
        if (sqlname == null) {
            throw IfxErrMsg.getSQLException(-79708, "", this.locale);
        }
        String sql = "DROP ROUTINE " + sqlname;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "sql = " + sql);
        }
        Statement stmt = this.conn.createStatement();
        stmt.executeUpdate(sql);
        stmt.close();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDRManager:removeUDR(String) exited");
        }
    }

    public void removeUDR(String sqlname, Class[] methodparams) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDRManager:removeUDR(String, Class[]) entered");
        }
        if (sqlname == null) {
            throw IfxErrMsg.getSQLException(-79708, "", this.locale);
        }
        String sqlparams = "";
        if (methodparams != null) {
            sqlparams = UDRManager.fromClassesToIfxNames(methodparams, null, null, this.trace, this.locale);
        }
        String sql = "DROP ROUTINE " + sqlname + "(" + sqlparams + ")";
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "sql = " + sql);
        }
        Statement stmt = this.conn.createStatement();
        stmt.executeUpdate(sql);
        stmt.close();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDRManager:removeUDR(String, Class[]) exited");
        }
    }

    public void removeJar(String jarfilesqlname, int undeploy) throws SQLException {
        UDRManager.removeJarNow(jarfilesqlname, undeploy, this.conn, this.locale);
    }

    public void setJarTmpPath(String path) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDRManager:setJarTmpPath() entered");
        }
        this.jarTmpPath = UDRManager.getJarTmpPathNow(this.conn, path, this.locale);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "jarTmpPath = " + this.jarTmpPath);
            this.trace.writeTrace(1, "UDRManager:setJarTmpPath() exited");
        }
    }

    static boolean isNTServer(IfxConnection conn) throws SQLException {
        boolean NTserver = false;
        int points = 0;
        if (conn == null) {
            return false;
        }
        String dbversion = conn.getDbVersion();
        for (int i2 = 0; !NTserver && i2 < dbversion.length(); ++i2) {
            if (dbversion.charAt(i2) != '.' || ++points != 2 || dbversion.charAt(i2 + 1) != 'T') continue;
            NTserver = true;
        }
        return NTserver;
    }

    static String getJarTmpPathNow(IfxConnection conn, String path, Locale locale) throws SQLException {
        if (path == null) {
            throw IfxErrMsg.getSQLException(-79708, "", locale);
        }
        if (UDRManager.isNTServer(conn)) {
            return path + "\\";
        }
        return path + "/";
    }

    static void checkJarFile(String jarfile, Locale locale) throws SQLException {
        if (jarfile == null) {
            throw IfxErrMsg.getSQLException(-79708, "", locale);
        }
        File jarFileObj = new File(jarfile);
        if (!jarFileObj.exists() || !jarFileObj.canRead()) {
            throw IfxErrMsg.getSQLException(-79845, "", locale);
        }
    }

    static void checkJarInSysCatalog(String jarfilesqlname, IfxConnection conn, Locale locale) throws SQLException {
        Trace trace = null;
        if (TraceFlag.compiletrace) {
            trace = conn.getTrace();
            trace.writeTrace(1, "UDRManager:checkJarInSysCatalog() entered");
        }
        String sql = "select tabname from gbasedbt.systables where tabname = 'retained_jars' and owner = 'sqlj'";
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        boolean tabExists = rs.next();
        rs.close();
        if (!tabExists) {
            stmt.close();
            if (TraceFlag.compiletrace) {
                trace.writeTrace(3, "sql = " + sql);
                trace.writeTrace(1, "UDRManager:checkJarInSysCatalog() exited");
            }
            return;
        }
        String jarfullname = conn.getDbName() + "." + conn.getUserName() + "." + jarfilesqlname;
        sql = "select jarname from 'sqlj'.retained_jars where jarname = '" + jarfullname + "'";
        rs = stmt.executeQuery(sql);
        boolean jarExists = rs.next();
        rs.close();
        stmt.close();
        if (jarExists) {
            throw IfxErrMsg.getSQLException(-79839, "", locale);
        }
        if (TraceFlag.compiletrace) {
            trace.writeTrace(3, "sql = " + sql);
            trace.writeTrace(1, "UDRManager:checkJarInSysCatalog() exited");
        }
    }

    static String transportJarToServer(String jarfile, String jarTmpPath, IfxConnection conn, Locale locale) throws SQLException {
        int idx;
        String jarnameDotJar;
        Trace trace = null;
        if (TraceFlag.compiletrace) {
            trace = conn.getTrace();
            trace.writeTrace(1, "UDRManager:transportJarToServer() entered");
            trace.writeTrace(3, "jarfile = '" + jarfile + "'");
            trace.writeTrace(3, "jarTmpPath = '" + jarTmpPath + "'");
        }
        String fsep = System.getProperty("file.separator");
        if (TraceFlag.compiletrace) {
            trace.writeTrace(3, "fsep = '" + fsep + "'");
        }
        if (!(jarnameDotJar = jarfile.substring((idx = jarfile.lastIndexOf(fsep)) + 1)).endsWith(".jar")) {
            throw IfxErrMsg.getSQLException(-79846, "", locale);
        }
        if (TraceFlag.compiletrace) {
            trace.writeTrace(3, "jarnameDotJar = '" + jarnameDotJar + "'");
        }
        String jarFileInServer = jarTmpPath + jarnameDotJar;
        IfxLvarchar ip1 = new IfxLvarchar(jarfile);
        ip1.setConnection(conn);
        ip1.setExtendedTypeName("lvarchar");
        IfxInteger ip2 = new IfxInteger(0x20000000);
        IfxLvarchar ip3 = new IfxLvarchar(jarFileInServer);
        ip3.setConnection(conn);
        ip3.setExtendedTypeName("lvarchar");
        IfxInteger ip4 = new IfxInteger(0x10000000);
        Vector<IfxObject> inVec = new Vector<IfxObject>();
        inVec.addElement(ip1);
        inVec.addElement(ip2);
        inVec.addElement(ip3);
        inVec.addElement(ip4);
        IfxSqli prot = null;
        try {
            prot = new IfxSqli((IfxSqliConnect)conn);
        }
        catch (Exception e2) {
            if (TraceFlag.compiletrace) {
                trace.writeTrace(3, "exception occurs: " + e2.toString());
            }
            throw IfxErrMsg.getSQLException(-79735, "", locale);
        }
        if (TraceFlag.compiletrace) {
            trace.writeTrace(3, "UDRManager.transportJarToServer():");
            trace.writeTrace(3, "Transport from: '" + jarfile + "'");
            trace.writeTrace(3, "            to: '" + jarFileInServer + "'");
        }
        Vector<IfxObject> outVec = prot.executeFastPath(IFX_FILE_TO_FILE, inVec, false);
        prot.clear();
        prot = null;
        if (!UDRManager.isNTServer(conn)) {
            UDRManager.changeFilePermissionInServer(jarFileInServer, conn);
        }
        UDRManager.changeFilePermissionInClient(jarfile, conn, locale);
        if (TraceFlag.compiletrace) {
            trace.writeTrace(1, "UDRManager:transportJarToServer() exited");
        }
        return jarFileInServer;
    }

    static void changeFilePermissionInClient(String jarfile, IfxConnection conn, Locale locale) throws SQLException {
        Trace trace = null;
        if (TraceFlag.compiletrace) {
            trace = conn.getTrace();
            trace.writeTrace(1, "UDRManager:changeFilePermissionInClient() entered");
        }
        String cmd = null;
        cmd = System.getProperty("file.separator").equals("/") ? "chmod a+w " + jarfile : "attrib -r " + jarfile;
        if (TraceFlag.compiletrace) {
            trace.writeTrace(3, "cmd is '" + cmd + "'");
        }
        try {
            Process child = Runtime.getRuntime().exec(cmd);
            if (child.waitFor() != 0) {
                throw IfxErrMsg.getSQLException(-79838, "", locale);
            }
        }
        catch (Exception e2) {
            if (TraceFlag.compiletrace) {
                trace.writeTrace(3, "exception occurs: " + e2.toString());
            }
            throw IfxErrMsg.getSQLException(-79838, "", locale);
        }
        if (TraceFlag.compiletrace) {
            trace.writeTrace(1, "UDRManager:changeFilePermissionInClient() exited");
        }
    }

    static void changeFilePermissionInServer(String jarfile, IfxConnection conn) throws SQLException {
        Trace trace = null;
        if (TraceFlag.compiletrace) {
            trace = conn.getTrace();
            trace.writeTrace(1, "UDRManager:changeFilePermissionInServer() entered");
        }
        Statement stmt = conn.createStatement();
        String sql = null;
        sql = UDRManager.isNTServer(conn) ? "CREATE PROCEDURE udtudrmgr_chperm (fname varchar(80)) \nsystem 'cmd /C attrib -r ' || fname; \nEND PROCEDURE" : "CREATE PROCEDURE udtudrmgr_chperm (fname varchar(80)) \nsystem 'chmod 666 ' || fname; \nEND PROCEDURE";
        if (TraceFlag.compiletrace) {
            trace.writeTrace(3, "UDRManager: sql = " + sql);
        }
        stmt.execute(sql);
        sql = "EXECUTE PROCEDURE udtudrmgr_chperm ('" + jarfile + "')";
        if (TraceFlag.compiletrace) {
            trace.writeTrace(3, "UDRManager: sql = " + sql);
        }
        stmt.execute(sql);
        sql = "DROP PROCEDURE udtudrmgr_chperm (varchar)";
        if (TraceFlag.compiletrace) {
            trace.writeTrace(3, "UDRManager: sql = " + sql);
        }
        stmt.execute(sql);
        stmt.close();
        if (TraceFlag.compiletrace) {
            trace.writeTrace(1, "UDRManager:changeFilePermissionInServer() exited");
        }
    }

    static void removeFileInServer(String jarfile, IfxConnection conn) throws SQLException {
        Trace trace = null;
        if (TraceFlag.compiletrace) {
            trace = conn.getTrace();
            trace.writeTrace(1, "UDRManager:removeFileInServer() entered");
        }
        Statement stmt = conn.createStatement();
        String sql = null;
        sql = UDRManager.isNTServer(conn) ? "CREATE PROCEDURE udtudrmgr_rmfile (fname varchar(80)) \nsystem 'cmd /C del ' || fname; \nEND PROCEDURE" : "CREATE PROCEDURE udtudrmgr_rmfile (fname varchar(80)) \nsystem 'rm ' || fname; \nEND PROCEDURE";
        if (TraceFlag.compiletrace) {
            trace.writeTrace(3, "UDRManager: sql = " + sql);
        }
        stmt.execute(sql);
        sql = "EXECUTE PROCEDURE udtudrmgr_rmfile ('" + jarfile + "')";
        if (TraceFlag.compiletrace) {
            trace.writeTrace(3, "UDRManager: sql = " + sql);
        }
        stmt.execute(sql);
        sql = "DROP PROCEDURE udtudrmgr_rmfile (varchar)";
        if (TraceFlag.compiletrace) {
            trace.writeTrace(3, "UDRManager: sql = " + sql);
        }
        stmt.execute(sql);
        stmt.close();
        if (TraceFlag.compiletrace) {
            trace.writeTrace(1, "UDRManager:removeFileInServer() exited");
        }
    }

    static void installJarNow(String jarFileSQLName, String jarFileInServer, int deploy, IfxConnection conn) throws SQLException {
        Trace trace = null;
        if (TraceFlag.compiletrace) {
            trace = conn.getTrace();
            trace.writeTrace(1, "UDRManager:installJarNow() entered");
        }
        String jarURLOnServer = "file:" + jarFileInServer;
        if (TraceFlag.compiletrace) {
            trace.writeTrace(3, "sql = execute procedure sqlj.install_jar('" + jarURLOnServer + "', '" + jarFileSQLName + "', " + deploy + ")");
        }
        IfmxCallableStatement cstmt = (IfmxCallableStatement)conn.prepareCall("{ call sqlj.install_jar(?,?,?) }");
        cstmt.setString(1, jarURLOnServer);
        cstmt.setString(2, jarFileSQLName);
        cstmt.setInt(3, deploy);
        cstmt.executeUpdate();
        cstmt.close();
        if (TraceFlag.compiletrace) {
            trace.writeTrace(1, "UDRManager:installJarNow() exited");
        }
    }

    static void removeJarNow(String jarfilesqlname, int undeploy, IfxConnection conn, Locale locale) throws SQLException {
        Trace trace = null;
        if (TraceFlag.compiletrace) {
            trace = conn.getTrace();
            trace.writeTrace(1, "UDRManager:removeJarNow() entered");
        }
        if (jarfilesqlname == null) {
            throw IfxErrMsg.getSQLException(-79708, "", locale);
        }
        if (TraceFlag.compiletrace) {
            trace.writeTrace(3, "sql = execute procedure sqlj.remove_jar('" + jarfilesqlname + "', " + undeploy + ")");
        }
        IfmxCallableStatement cstmt = (IfmxCallableStatement)conn.prepareCall("{ call sqlj.remove_jar(?,?) }");
        cstmt.setString(1, jarfilesqlname);
        cstmt.setInt(2, undeploy);
        cstmt.executeUpdate();
        if (TraceFlag.compiletrace) {
            trace.writeTrace(1, "UDRManager:removeJarNow() exited");
        }
    }

    static void registerUDRs(UDRMetaData mdata, String classname, String udtsqlname, IfxConnection conn, Locale locale) throws SQLException {
        Trace trace = null;
        if (TraceFlag.compiletrace) {
            trace = conn.getTrace();
            trace.writeTrace(1, "UDRManager:registerUDRs() entered");
        }
        Method m2 = null;
        String mName = null;
        String mSQLName = null;
        String mSQLParams = null;
        String mJavaParams = null;
        String mSQLReturn = null;
        String sql = null;
        Hashtable udrs = mdata.udrs;
        if (udrs == null || udrs.size() == 0) {
            if (TraceFlag.compiletrace) {
                trace.writeTrace(1, "UDRManager:registerUDRs() exited");
            }
            return;
        }
        String jarFileSQLName = mdata.jarFileSQLName;
        Statement stmt = conn.createStatement();
        Enumeration keys = udrs.keys();
        while (keys.hasMoreElements()) {
            m2 = (Method)keys.nextElement();
            if (TraceFlag.compiletrace) {
                trace.writeTrace(3, "m = " + m2.toString());
            }
            mName = m2.getName();
            UDRMetaData.udrinfo udr = (UDRMetaData.udrinfo)udrs.get(m2);
            mSQLName = udr.sqlname;
            mSQLParams = UDRManager.fromClassesToIfxNames(m2.getParameterTypes(), classname, udtsqlname, trace, locale);
            mJavaParams = UDRManager.fromClassesToJavaNames(m2.getParameterTypes(), trace);
            mSQLReturn = UDRManager.fromClassesToIfxNames(new Class[]{m2.getReturnType()}, classname, udtsqlname, trace, locale);
            sql = mSQLReturn.equals("void") ? "CREATE PROCEDURE " + mSQLName + " (" + mSQLParams + ") EXTERNAL NAME '" + jarFileSQLName + ":" + classname + "." + mName + "(" + mJavaParams + ")' LANGUAGE JAVA NOT VARIANT END PROCEDURE" : "CREATE FUNCTION " + mSQLName + " (" + mSQLParams + ") RETURNS " + mSQLReturn + " EXTERNAL NAME '" + jarFileSQLName + ":" + classname + "." + mName + "(" + mJavaParams + ")' LANGUAGE JAVA NOT VARIANT END FUNCTION";
            if (TraceFlag.compiletrace) {
                trace.writeTrace(3, "sql = " + sql);
            }
            stmt.executeUpdate(sql);
        }
        stmt.close();
        if (TraceFlag.compiletrace) {
            trace.writeTrace(1, "UDRManager:registerUDRs() exited");
        }
    }

    static String fromClassesToJavaNames(Class[] classes, Trace trace) {
        int numclass;
        if (TraceFlag.compiletrace) {
            trace.writeTrace(1, "UDRManager:fromClassesToJavaNames() entered");
        }
        if ((numclass = classes.length) == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i2 = 0; i2 < numclass; ++i2) {
            if (i2 != numclass - 1) {
                buf.append(classes[i2].getName() + ", ");
                continue;
            }
            buf.append(classes[i2].getName());
        }
        if (TraceFlag.compiletrace) {
            trace.writeTrace(3, "buf = '" + buf.toString() + "'");
            trace.writeTrace(1, "UDRManager:fromClassesToJavaNames() exited");
        }
        return buf.toString();
    }

    static String fromClassesToIfxNames(Class[] classes, String classname, String udtsqlname, Trace trace, Locale locale) throws SQLException {
        int numclass;
        if (TraceFlag.compiletrace) {
            trace.writeTrace(1, "UDRManager:fromClassesToIfxNames() entered");
        }
        if ((numclass = classes.length) == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i2 = 0; i2 < numclass; ++i2) {
            int ifxtype = -1;
            String ifxname = null;
            String javatypename = classes[i2].getName();
            if (TraceFlag.compiletrace) {
                trace.writeTrace(3, "javatypename = " + javatypename);
            }
            if (javatypename.equals(classname)) {
                if (udtsqlname != null) {
                    ifxname = udtsqlname;
                }
            } else {
                if (javatypename.equals("java.lang.Object") || javatypename.equals("java.sql.SQLData")) {
                    throw IfxErrMsg.getSQLException(-79860, "", locale);
                }
                ifxname = UDRManager.JavaToIfxName(javatypename);
                if (ifxname.equals("unknown")) {
                    throw IfxErrMsg.getSQLException(-79714, "", locale);
                }
            }
            if (i2 != numclass - 1) {
                buf.append(ifxname + ", ");
                continue;
            }
            buf.append(ifxname);
        }
        if (TraceFlag.compiletrace) {
            trace.writeTrace(3, "buf = '" + buf.toString() + "'");
            trace.writeTrace(1, "UDRManager:fromClassesToIfxNames() exited");
        }
        return buf.toString();
    }

    private static String JavaToIfxName(String javatypename) {
        String name = (String)JavaToIfxNameTable.get(javatypename);
        if (name == null) {
            return "unknown";
        }
        return name;
    }

    static {
        if (JavaToIfxNameTable == null) {
            JavaToIfxNameTable = new Hashtable(30);
            JavaToIfxNameTable.put(new String("boolean"), new String("boolean"));
            JavaToIfxNameTable.put(new String("char"), new String("char(1)"));
            JavaToIfxNameTable.put(new String("byte"), new String("char(1)"));
            JavaToIfxNameTable.put(new String("short"), new String("smallint"));
            JavaToIfxNameTable.put(new String("int"), new String("int"));
            JavaToIfxNameTable.put(new String("long"), new String("int8"));
            JavaToIfxNameTable.put(new String("float"), new String("smallfloat"));
            JavaToIfxNameTable.put(new String("double"), new String("float"));
            JavaToIfxNameTable.put(new String("java.lang.String"), new String("lvarchar"));
            JavaToIfxNameTable.put(new String("java.math.BigDecimal"), new String("decimal"));
            JavaToIfxNameTable.put(new String("java.lang.Boolean"), new String("boolean"));
            JavaToIfxNameTable.put(new String("java.lang.Integer"), new String("int"));
            JavaToIfxNameTable.put(new String("java.lang.Short"), new String("smallint"));
            JavaToIfxNameTable.put(new String("java.lang.Long"), new String("int8"));
            JavaToIfxNameTable.put(new String("java.lang.Float"), new String("smallfloat"));
            JavaToIfxNameTable.put(new String("java.lang.Double"), new String("float"));
            JavaToIfxNameTable.put(new String("java.sql.Date"), new String("date"));
            JavaToIfxNameTable.put(new String("java.sql.Time"), new String("datetime hour to second"));
            JavaToIfxNameTable.put(new String("java.sql.Timestamp"), new String("datetime year to fraction(5)"));
            JavaToIfxNameTable.put(new String("com.gbasedbt.lang.IntervalYM"), new String("interval year to month"));
            JavaToIfxNameTable.put(new String("com.gbasedbt.lang.IntervalDF"), new String("interval day to fraction(5)"));
            JavaToIfxNameTable.put(new String("java.sql.Blob"), new String("blob"));
            JavaToIfxNameTable.put(new String("java.sql.Clob"), new String("clob"));
        }
    }
}

