/*
 * Decompiled with CFR 0.152.
 */
package sqlj.translator;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import sqlj.framework.ClassResolver;
import sqlj.framework.error.ErrorLog;
import sqlj.framework.error.JSError;
import sqlj.mesg.TranslatorErrors;
import sqlj.translator.ClassResolverImpl;
import sqlj.translator.Main;
import sqlj.translator.TranslationUnit;
import sqlj.util.OutputContext;
import sqlj.util.ParseContext;
import sqlj.util.io.CharStream;
import sqlj.util.io.ErrorLogger;
import sqlj.util.io.OracleOutputStreamWriter;
import sqlj.util.io.StringWriter;
import sqlj.util.io.UCode_CharStream;

class FileTranslationUnit
implements TranslationUnit,
ParseContext,
OutputContext {
    private static final String JAVA_SUFFIX = ".java";
    private static final String JAVA_TMP_SUFFIX = ".java.tmp";
    private static final String SQLJ_SUFFIX = ".sqlj";
    private static final String PROFILE_SUFFIX = ".ser";
    private static final ClassResolver m_resolver = new ClassResolverImpl();
    private Reader m_reader = null;
    private UCode_CharStream m_charStream = null;
    private ErrorLogger m_log = null;
    private String m_package = "";
    private String m_resultDir;
    private String m_resultSerDir;
    private String m_encoding;
    private String m_name;
    private File m_infile;
    private int m_type;
    private StringWriter m_baseWriter = null;
    private Writer m_writer = null;
    private File m_tmpfile = null;

    public FileTranslationUnit(String string, String string2, String string3, String string4, ErrorLogger errorLogger) throws IOException {
        this.m_infile = new File(string);
        this.m_resultDir = string2;
        this.m_resultSerDir = string3;
        this.m_encoding = string4;
        this.m_name = string;
        this.m_log = errorLogger;
        this.m_log.setFileName(string);
        if (string.endsWith(JAVA_SUFFIX)) {
            this.m_type = 2;
        } else if (string.endsWith(SQLJ_SUFFIX)) {
            this.m_type = 1;
        } else {
            this.m_log.addEntry(new JSError(TranslatorErrors.illegal_input_extension(string)));
            throw new IOException();
        }
        if (!this.m_infile.canRead()) {
            this.m_log.addEntry(new JSError(TranslatorErrors.input_file_not_readable(string)));
            throw new IOException();
        }
    }

    @Override
    public String getFileName() {
        String string = this.m_infile.getName();
        if (string.endsWith(JAVA_SUFFIX)) {
            string = string.substring(0, string.length() - JAVA_SUFFIX.length());
        } else if (string.endsWith(SQLJ_SUFFIX)) {
            string = string.substring(0, string.length() - SQLJ_SUFFIX.length());
        }
        return string;
    }

    private String validateOutDir(String string, File file) throws IOException {
        return this.validateOutDir(string, file, null);
    }

    private String validateOutDir(String string, File file, String string2) throws IOException {
        CharSequence charSequence;
        String string3;
        String string4;
        boolean bl = string2 != null && string2.endsWith(PROFILE_SUFFIX) || file.getName().endsWith(PROFILE_SUFFIX);
        String string5 = string4 = bl ? this.m_resultSerDir : this.m_resultDir;
        if (string4 == null) {
            string3 = file.getParent();
        } else {
            charSequence = new StringBuffer(string4);
            if (!string4.endsWith(File.separator)) {
                charSequence.append(File.separator);
            }
            if (string != null) {
                charSequence.append(string.replace('.', File.separatorChar));
            }
            string3 = charSequence.toString();
        }
        if (!this.createDir(string3)) {
            this.getErrorLogger().addEntry(new JSError(TranslatorErrors.cannot_create_package_dir(string3)));
            throw new IOException();
        }
        if (Main.classFilesTable != null && string2 != null && string2.endsWith(JAVA_SUFFIX)) {
            charSequence = file.toString();
            String string6 = file.getName();
            string6 = string6.substring(0, string6.length() - 5);
            String string7 = (string3 == null ? "" : string3 + File.separator) + string6 + JAVA_SUFFIX;
            Main.javaFilesTable.put(charSequence, string7);
            try {
                String string8 = this.validateOutDir(string, file, PROFILE_SUFFIX);
                String string9 = (string8 == null ? "" : string8 + File.separator) + string6 + ".class";
                Main.classFilesTable.put(string7, string9);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string3;
    }

    private File newXXXXFile(String string, File file, String string2) throws IOException {
        String string3 = this.validateOutDir(string, file, string2);
        String string4 = file.getName();
        StringBuffer stringBuffer = new StringBuffer(string4);
        stringBuffer.setLength(string4.lastIndexOf(46));
        stringBuffer.append(string2);
        return new File(string3, stringBuffer.toString());
    }

    private File newJavaFile(String string, File file) throws IOException {
        return this.newXXXXFile(string, file, JAVA_SUFFIX);
    }

    private File newJavaTmpFile(String string, File file) throws IOException {
        return this.newXXXXFile(string, file, JAVA_TMP_SUFFIX);
    }

    @Override
    public ParseContext getInput() throws IOException {
        if (this.m_reader == null) {
            this.createInput();
        }
        return this;
    }

    @Override
    public ClassResolver getClassResolver() {
        return m_resolver;
    }

    @Override
    public Reader getReader() {
        return this.m_reader;
    }

    @Override
    public CharStream getCharStream() {
        return this.m_charStream;
    }

    @Override
    public ErrorLogger getErrorLogger() {
        return this.m_log;
    }

    private void createInput() throws IOException {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.m_infile);
            this.m_log = this.m_log.createChild(this.m_name);
            this.m_charStream = new UCode_CharStream((InputStream)fileInputStream, this.m_encoding, (ErrorLog)this.m_log);
            this.m_reader = this.m_charStream.getReader();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.m_log.addEntry(new JSError(TranslatorErrors.input_file_not_found(this.m_infile.getPath())));
            throw fileNotFoundException;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.m_log.addEntry(new JSError(TranslatorErrors.unsupported_file_encoding(this.m_encoding)));
            throw unsupportedEncodingException;
        }
    }

    void deleteInput() {
        this.m_charStream = null;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public int getType() {
        return this.m_type;
    }

    @Override
    public void setPackageName(String string) {
        this.m_package = string;
    }

    @Override
    public OutputContext getOutput() throws IOException {
        if (this.m_writer == null) {
            this.createOutput();
        }
        return this;
    }

    @Override
    public Writer getWriter() {
        return this.m_writer;
    }

    @Override
    public Writer createWriter(String string) throws IOException {
        String string2 = this.validateOutDir(this.m_package, this.m_infile);
        return new OracleOutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(new File(string2, string))), this.m_encoding);
    }

    @Override
    public OutputStream createOutputStream(String string) throws IOException {
        String string2 = this.validateOutDir(this.m_package, this.m_infile, string);
        File file = new File(string2, string);
        if (Main.serFilesVector != null) {
            Main.serFilesVector.addElement(file);
        }
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    private void createOutput() throws IOException {
        try {
            this.m_tmpfile = this.newJavaTmpFile(this.m_package, this.m_infile);
            this.m_writer = new OracleOutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(this.m_tmpfile)), this.m_encoding);
        }
        catch (IOException iOException) {
            this.m_log.addEntry(new JSError(TranslatorErrors.cannot_create_output_file(this.m_tmpfile.getPath())));
            throw iOException;
        }
    }

    @Override
    public void translationComplete(boolean bl) throws IOException {
        if (this.m_writer != null) {
            this.m_writer.close();
            if (this.m_type == 1 && bl) {
                File file = this.newJavaFile(this.m_package, this.m_infile);
                if (file.exists()) {
                    file.delete();
                }
                this.m_tmpfile.renameTo(file);
            } else {
                this.m_tmpfile.delete();
            }
            this.m_writer = null;
            this.m_tmpfile = null;
        }
        if (Main.immediateStream != null) {
            this.m_log.printLog(Main.immediateStream);
            Main.immediateStream.flush();
        }
    }

    private boolean createDir(String string) {
        if (string == null) {
            return true;
        }
        File file = new File(string);
        if (file.isDirectory()) {
            return true;
        }
        return file.mkdirs();
    }

    public static void main(String[] stringArray) throws Exception {
        int n2;
        String string = null;
        String string2 = null;
        String string3 = "";
        String string4 = System.getProperty("file.encoding", "8859_1");
        for (n2 = 0; n2 < stringArray.length && stringArray[n2].startsWith("-"); ++n2) {
            if (stringArray[n2].startsWith("-dir=")) {
                string = stringArray[n2].substring(5);
                continue;
            }
            if (stringArray[n2].startsWith("-d=")) {
                string2 = stringArray[n2].substring(3);
                continue;
            }
            if (stringArray[n2].startsWith("-package=")) {
                string3 = stringArray[n2].substring(9);
                continue;
            }
            if (!stringArray[n2].startsWith("-encoding=")) continue;
            string4 = stringArray[n2].substring(10);
        }
        while (n2 < stringArray.length) {
            ErrorLogger errorLogger = new ErrorLogger();
            PrintWriter printWriter = new PrintWriter(System.out, true);
            try {
                int n3;
                FileTranslationUnit fileTranslationUnit = new FileTranslationUnit(stringArray[n2], string, string2, string4, errorLogger);
                fileTranslationUnit.setPackageName(string3);
                printWriter.println(fileTranslationUnit.getName());
                printWriter.println(fileTranslationUnit.getType());
                Reader reader = fileTranslationUnit.getInput().getReader();
                Writer writer = fileTranslationUnit.getOutput().getWriter();
                while ((n3 = reader.read()) != -1) {
                    if (fileTranslationUnit.getType() != 1) continue;
                    writer.write(n3);
                }
                reader.close();
                writer.close();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                printWriter.println("success?");
                String string5 = bufferedReader.readLine();
                fileTranslationUnit.translationComplete(string5.equals("y"));
            }
            catch (Exception exception) {
                exception.printStackTrace(printWriter);
            }
            errorLogger.printLog(printWriter);
            printWriter.flush();
            ++n2;
        }
    }
}

